/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.callgraph2;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackSymbol;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.AggregatedCallSite;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.CallGraph;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallStackAnalysisStub;
import org.eclipse.tracecompass.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTreeGroupBy;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTreeSet;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.AllGroupDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class CallGraphGroupByInstrumentedTest
extends CallStackTestBase2 {
    private static Map<String, CallGraphExpected> getExpectedAll() {
        return ImmutableMap.of((Object)"op1", (Object)new CallGraphExpected(28L, 8L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op2", (Object)new CallGraphExpected(7L, 5L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(2L, 2L, Collections.emptyMap()))), (Object)"op3", (Object)new CallGraphExpected(5L, 3L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op1", (Object)new CallGraphExpected(2L, 2L, Collections.emptyMap()))), (Object)"op4", (Object)new CallGraphExpected(8L, 8L, Collections.emptyMap()))), (Object)"op4", (Object)new CallGraphExpected(8L, 8L, Collections.emptyMap()), (Object)"op2", (Object)new CallGraphExpected(17L, 10L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()), (Object)"op2", (Object)new CallGraphExpected(6L, 6L, Collections.emptyMap()))), (Object)"op5", (Object)new CallGraphExpected(19L, 7L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op2", (Object)new CallGraphExpected(12L, 11L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()))))));
    }

    private static Map<String, CallGraphExpected> getExpectedProcess1() {
        return ImmutableMap.of((Object)"op1", (Object)new CallGraphExpected(9L, 5L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op2", (Object)new CallGraphExpected(4L, 3L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()))))), (Object)"op4", (Object)new CallGraphExpected(8L, 8L, Collections.emptyMap()), (Object)"op2", (Object)new CallGraphExpected(17L, 10L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()), (Object)"op2", (Object)new CallGraphExpected(6L, 6L, Collections.emptyMap()))));
    }

    private static Map<String, CallGraphExpected> getExpectedProcess5() {
        return ImmutableMap.of((Object)"op1", (Object)new CallGraphExpected(19L, 3L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(5L, 3L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op1", (Object)new CallGraphExpected(2L, 2L, Collections.emptyMap()))), (Object)"op2", (Object)new CallGraphExpected(3L, 2L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()))), (Object)"op4", (Object)new CallGraphExpected(8L, 8L, Collections.emptyMap()))), (Object)"op5", (Object)new CallGraphExpected(19L, 7L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op2", (Object)new CallGraphExpected(12L, 11L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()))))));
    }

    private static Map<String, CallGraphExpected> getExpectedThread2() {
        return ImmutableMap.of((Object)"op1", (Object)new CallGraphExpected(9L, 5L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op2", (Object)new CallGraphExpected(4L, 3L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()))))), (Object)"op4", (Object)new CallGraphExpected(8L, 8L, Collections.emptyMap()));
    }

    private static Map<String, CallGraphExpected> getExpectedThread3() {
        return ImmutableMap.of((Object)"op2", (Object)new CallGraphExpected(17L, 10L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()), (Object)"op2", (Object)new CallGraphExpected(6L, 6L, Collections.emptyMap()))));
    }

    private static Map<String, CallGraphExpected> getExpectedThread6() {
        return ImmutableMap.of((Object)"op1", (Object)new CallGraphExpected(19L, 3L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op2", (Object)new CallGraphExpected(3L, 2L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()))), (Object)"op3", (Object)new CallGraphExpected(5L, 3L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op1", (Object)new CallGraphExpected(2L, 2L, Collections.emptyMap()))), (Object)"op4", (Object)new CallGraphExpected(8L, 8L, Collections.emptyMap()))));
    }

    private static Map<String, CallGraphExpected> getExpectedThread7() {
        return ImmutableMap.of((Object)"op5", (Object)new CallGraphExpected(19L, 7L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op2", (Object)new CallGraphExpected(12L, 11L, (Map<String, CallGraphExpected>)ImmutableMap.of((Object)"op3", (Object)new CallGraphExpected(1L, 1L, Collections.emptyMap()))))));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testGroupByAllInstrumented() {
        CallStackAnalysisStub cga = this.getModule();
        CallGraph baseCallGraph = cga.getCallGraph();
        @NonNull @NonNull WeightedTreeSet callGraph = WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)AllGroupDescriptor.getInstance(), (IWeightedTreeSet)baseCallGraph, (IWeightedTreeProvider)cga);
        Collection elements = callGraph.getElements();
        Assert.assertEquals((long)1L, (long)elements.size());
        Object element = Iterables.getFirst((Iterable)elements, null);
        Assert.assertNotNull((Object)element);
        @NonNull Collection callingContextTree = callGraph.getTreesFor(element);
        CallGraphGroupByInstrumentedTest.compareCcts("", CallGraphGroupByInstrumentedTest.getExpectedAll(), callingContextTree);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testGroupByProcessInstrumented() {
        CallStackAnalysisStub cga = this.getModule();
        CallGraph baseCallGraph = cga.getCallGraph();
        Collection groupDescriptors = cga.getGroupDescriptors();
        IWeightedTreeGroupDescriptor processGroup = (IWeightedTreeGroupDescriptor)Iterables.getFirst((Iterable)groupDescriptors, null);
        Assert.assertNotNull((Object)processGroup);
        @NonNull @NonNull WeightedTreeSet callGraph = WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)processGroup, (IWeightedTreeSet)baseCallGraph, (IWeightedTreeProvider)cga);
        Collection elements = callGraph.getElements();
        Assert.assertEquals((long)2L, (long)elements.size());
        for (Object element : elements) {
            Assert.assertTrue((boolean)(element instanceof ICallStackElement));
            switch (String.valueOf(element)) {
                case "1": {
                    Collection children = ((ICallStackElement)element).getChildren();
                    Assert.assertEquals((long)0L, (long)children.size());
                    for (ITree child : children) {
                        Assert.assertTrue((boolean)callGraph.getTreesFor((Object)child).isEmpty());
                    }
                    @NonNull @NonNull Collection callingContextTree = callGraph.getTreesFor(element);
                    CallGraphGroupByInstrumentedTest.compareCcts("", CallGraphGroupByInstrumentedTest.getExpectedProcess1(), callingContextTree);
                    break;
                }
                case "5": {
                    Collection children = ((ICallStackElement)element).getChildren();
                    Assert.assertEquals((long)0L, (long)children.size());
                    for (ITree child : children) {
                        Assert.assertTrue((boolean)callGraph.getTreesFor((Object)child).isEmpty());
                    }
                    @NonNull @NonNull Collection callingContextTree = callGraph.getTreesFor(element);
                    CallGraphGroupByInstrumentedTest.compareCcts("", CallGraphGroupByInstrumentedTest.getExpectedProcess5(), callingContextTree);
                    break;
                }
                default: {
                    Assert.fail((String)("Unexpected element: " + element));
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testGroupByThreadInstrumented() {
        CallStackAnalysisStub cga = this.getModule();
        CallGraph baseCallGraph = cga.getCallGraph();
        Collection groupDescriptors = cga.getGroupDescriptors();
        IWeightedTreeGroupDescriptor group = (IWeightedTreeGroupDescriptor)Iterables.getFirst((Iterable)groupDescriptors, null);
        Assert.assertNotNull((Object)group);
        while (group.getNextGroup() != null) {
            group = group.getNextGroup();
            Assert.assertNotNull((Object)group);
        }
        @NonNull @NonNull WeightedTreeSet callGraph = WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)group, (IWeightedTreeSet)baseCallGraph, (IWeightedTreeProvider)cga);
        Collection elements = callGraph.getElements();
        Assert.assertEquals((long)2L, (long)elements.size());
        block25: for (Object element : elements) {
            Assert.assertTrue((boolean)(element instanceof ICallStackElement));
            switch (String.valueOf(element)) {
                case "1": {
                    Collection callingContextTree;
                    Collection children = ((ICallStackElement)element).getChildren();
                    Assert.assertEquals((long)2L, (long)children.size());
                    for (ITree thread : children) {
                        switch (String.valueOf(thread)) {
                            case "2": {
                                callingContextTree = callGraph.getTreesFor((Object)thread);
                                CallGraphGroupByInstrumentedTest.compareCcts("", CallGraphGroupByInstrumentedTest.getExpectedThread2(), callingContextTree);
                                break;
                            }
                            case "3": {
                                callingContextTree = callGraph.getTreesFor((Object)thread);
                                CallGraphGroupByInstrumentedTest.compareCcts("", CallGraphGroupByInstrumentedTest.getExpectedThread3(), callingContextTree);
                                break;
                            }
                            default: {
                                Assert.fail((String)("Unexpected thread element: " + thread));
                            }
                        }
                    }
                    continue block25;
                }
                case "5": {
                    Collection callingContextTree;
                    Collection children = ((ICallStackElement)element).getChildren();
                    Assert.assertEquals((long)2L, (long)children.size());
                    for (ITree thread : children) {
                        switch (String.valueOf(thread)) {
                            case "6": {
                                callingContextTree = callGraph.getTreesFor((Object)thread);
                                CallGraphGroupByInstrumentedTest.compareCcts("", CallGraphGroupByInstrumentedTest.getExpectedThread6(), callingContextTree);
                                break;
                            }
                            case "7": {
                                callingContextTree = callGraph.getTreesFor((Object)thread);
                                CallGraphGroupByInstrumentedTest.compareCcts("", CallGraphGroupByInstrumentedTest.getExpectedThread7(), callingContextTree);
                                break;
                            }
                            default: {
                                Assert.fail((String)("Unexpected thread element: " + thread));
                            }
                        }
                    }
                    continue block25;
                }
                default: {
                    Assert.fail((String)("Unexpected element: " + element));
                }
            }
        }
    }

    @Test
    public void testMultiGroupBys() {
        this.testGroupByProcessInstrumented();
        this.testGroupByThreadInstrumented();
        this.testGroupByAllInstrumented();
        this.testGroupByProcessInstrumented();
        this.testGroupByAllInstrumented();
        this.testGroupByThreadInstrumented();
    }

    private static void compareCcts(String prefix, Map<String, CallGraphExpected> expected, Collection<WeightedTree<@NonNull ICallStackSymbol>> callingContextTree) {
        Assert.assertEquals((long)expected.size(), (long)callingContextTree.size());
        for (WeightedTree<ICallStackSymbol> callsite : callingContextTree) {
            Assert.assertTrue((boolean)(callsite instanceof AggregatedCalledFunction));
            AggregatedCalledFunction function = (AggregatedCalledFunction)callsite;
            ICallStackSymbol callSiteSymbol = CallGraphGroupByInstrumentedTest.getCallSiteSymbol((AggregatedCallSite)function);
            CallGraphExpected cgExpected = expected.get(callSiteSymbol.resolve(Collections.emptySet()));
            Assert.assertNotNull((Object)cgExpected);
            Assert.assertEquals((String)("Callsite " + callSiteSymbol), (long)cgExpected.duration, (long)function.getDuration());
            Assert.assertEquals((String)("Callsite " + callSiteSymbol), (long)cgExpected.selfTime, (long)function.getSelfTime());
            CallGraphGroupByInstrumentedTest.compareCcts(String.valueOf(prefix) + callSiteSymbol + ", ", cgExpected.children, callsite.getChildren());
        }
    }

    private static class CallGraphExpected {
        private final long duration;
        private final long selfTime;
        private final Map<String, CallGraphExpected> children;

        public CallGraphExpected(long dur, long self, Map<String, CallGraphExpected> childMap) {
            this.duration = dur;
            this.selfTime = self;
            this.children = childMap;
        }
    }
}

