/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.graph;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraphVisitor;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.TestGraphWorker;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.TmfGraphStatistics;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ITmfGraphTest {
    protected static final @NonNull IGraphWorker WORKER1 = new TestGraphWorker(1);
    protected static final @NonNull IGraphWorker WORKER2 = new TestGraphWorker(2);
    protected static final @NonNull IGraphWorker WORKER3 = new TestGraphWorker(3);
    private ITmfGraph fGraph;

    @Before
    public void setup() throws IOException {
        this.fGraph = this.createNewGraph();
    }

    protected abstract ITmfGraph createNewGraph() throws IOException;

    @After
    public void cleanup() throws IOException {
        if (this.fGraph != null) {
            this.deleteGraph(this.fGraph);
        }
    }

    protected abstract void deleteGraph(ITmfGraph var1) throws IOException;

    protected @NonNull ITmfGraph getGraph() {
        return Objects.requireNonNull(this.fGraph);
    }

    @Test
    public void testAddVertex() {
        ITmfVertex vertex;
        ITmfVertex v0 = this.fGraph.createVertex(WORKER1, 0L);
        this.fGraph.add(v0);
        ITmfVertex v1 = this.fGraph.createVertex(WORKER1, 1L);
        this.fGraph.add(v1);
        Iterator it = this.fGraph.getNodesOf(WORKER1);
        int count = 0;
        while (it.hasNext()) {
            ITmfVertex vertex2 = (ITmfVertex)it.next();
            Assert.assertEquals((String)("Vertext at count " + count), (long)count, (long)vertex2.getTimestamp());
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex2, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE));
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex2, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex2, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex2, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        ITmfVertex v2 = this.fGraph.createVertex(WORKER2, 2L);
        this.fGraph.add(v2);
        ITmfVertex v3 = this.fGraph.createVertex(WORKER2, 3L);
        this.fGraph.add(v3);
        it = this.fGraph.getNodesOf(WORKER1);
        count = 0;
        while (it.hasNext()) {
            vertex = (ITmfVertex)it.next();
            Assert.assertEquals((long)count, (long)vertex.getTimestamp());
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE));
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        it = this.fGraph.getNodesOf(WORKER2);
        count = 0;
        while (it.hasNext()) {
            vertex = (ITmfVertex)it.next();
            Assert.assertEquals((long)(count + 2), (long)vertex.getTimestamp());
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE));
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE));
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
            Assert.assertNull((Object)this.fGraph.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testAppendVertex() {
        ITmfVertex v0 = this.fGraph.createVertex(WORKER1, 0L);
        ITmfEdge edge = this.fGraph.append(v0);
        Assert.assertNull((String)"First edge of a worker", (Object)edge);
        ITmfVertex v1 = this.fGraph.createVertex(WORKER1, 1L);
        edge = this.fGraph.append(v1);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.DEFAULT, (Object)edge.getEdgeContextState().getContextEnum());
        Assert.assertEquals((Object)v1, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)v0, (Object)edge.getVertexFrom());
        Assert.assertEquals((long)(v1.getTimestamp() - v0.getTimestamp()), (long)edge.getDuration());
        @NonNull Iterator it = this.fGraph.getNodesOf(WORKER1);
        @NonNull ImmutableList list = ImmutableList.copyOf((Iterator)it);
        Assert.assertEquals((long)2L, (long)list.size());
        ITmfGraphTest.checkLinkHorizontal((List<ITmfVertex>)list, this.fGraph);
        ITmfVertex v2 = this.fGraph.createVertex(WORKER1, 2L);
        edge = this.fGraph.append(v2, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.BLOCKED, (Object)edge.getEdgeContextState().getContextEnum());
        Assert.assertEquals((Object)v2, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)v1, (Object)edge.getVertexFrom());
        Assert.assertEquals((long)(v2.getTimestamp() - v1.getTimestamp()), (long)edge.getDuration());
        it = this.fGraph.getNodesOf(WORKER1);
        list = ImmutableList.copyOf((Iterator)it);
        Assert.assertEquals((long)3L, (long)list.size());
        ITmfGraphTest.checkLinkHorizontal((List<ITmfVertex>)list, this.fGraph);
    }

    @Test
    public void testLink() {
        ITmfVertex v0 = this.fGraph.createVertex(WORKER1, 0L);
        this.fGraph.add(v0);
        ITmfVertex v1 = this.fGraph.createVertex(WORKER1, 1L);
        ITmfEdge edge = this.fGraph.edge(v0, v1);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.DEFAULT, (Object)edge.getEdgeContextState().getContextEnum());
        Assert.assertEquals((Object)v1, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)v0, (Object)edge.getVertexFrom());
        Assert.assertEquals((long)(v1.getTimestamp() - v0.getTimestamp()), (long)edge.getDuration());
        Iterator it = this.fGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)2L, (long)ImmutableList.copyOf((Iterator)it).size());
        ITmfEdge edge1 = this.fGraph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge1);
        Assert.assertEquals((Object)v0, (Object)edge1.getVertexFrom());
        edge1 = this.fGraph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        Assert.assertNull((Object)edge1);
        edge1 = this.fGraph.getEdgeFrom(v0, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge1);
        Assert.assertEquals((Object)v1, (Object)edge1.getVertexTo());
        ITmfVertex v2 = this.fGraph.createVertex(WORKER1, 2L);
        edge = this.fGraph.edge(v1, v2, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.NETWORK, (Object)edge.getEdgeContextState().getContextEnum());
        Assert.assertEquals((Object)v2, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)v1, (Object)edge.getVertexFrom());
        Assert.assertEquals((long)(v2.getTimestamp() - v1.getTimestamp()), (long)edge.getDuration());
        it = this.fGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)3L, (long)ImmutableList.copyOf((Iterator)it).size());
        edge1 = this.fGraph.getEdgeFrom(v2, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge1);
        Assert.assertEquals((Object)v1, (Object)edge1.getVertexFrom());
        edge1 = this.fGraph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge1);
        Assert.assertEquals((Object)v2, (Object)edge1.getVertexTo());
        ITmfVertex v3 = this.fGraph.createVertex(WORKER2, 3L);
        edge = this.fGraph.edge(v2, v3, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v3, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)v2, (Object)edge.getVertexFrom());
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.NETWORK, (Object)edge.getEdgeContextState().getContextEnum());
        it = this.fGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)3L, (long)ImmutableList.copyOf((Iterator)it).size());
        it = this.fGraph.getNodesOf(WORKER2);
        Assert.assertEquals((long)1L, (long)ImmutableList.copyOf((Iterator)it).size());
        edge1 = this.fGraph.getEdgeFrom(v2, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge1);
        Assert.assertEquals((Object)v3, (Object)edge1.getVertexTo());
        edge1 = this.fGraph.getEdgeFrom(v3, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge1);
        Assert.assertEquals((Object)v2, (Object)edge1.getVertexFrom());
        ITmfVertex v4 = this.fGraph.createVertex(WORKER3, 3L);
        edge = this.fGraph.edge(v3, v4, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), "test");
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v4, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)v3, (Object)edge.getVertexFrom());
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.NETWORK, (Object)edge.getEdgeContextState().getContextEnum());
        edge1 = this.fGraph.getEdgeFrom(v3, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge1);
        Assert.assertEquals((Object)v4, (Object)edge1.getVertexTo());
        edge1 = this.fGraph.getEdgeFrom(v4, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge1);
        Assert.assertEquals((Object)v3, (Object)edge1.getVertexFrom());
    }

    @Test
    public void testLinkVertical() {
        ITmfVertex v0 = this.fGraph.createVertex(WORKER1, 0L);
        this.fGraph.add(v0);
        ITmfVertex v1 = this.fGraph.createVertex(WORKER1, 1L);
        this.fGraph.add(v1);
        ITmfEdge edge = this.fGraph.edgeVertical(v0, v1, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), null);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.RUNNING, (Object)edge.getEdgeContextState().getContextEnum());
        Assert.assertEquals((Object)v1, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)v0, (Object)edge.getVertexFrom());
        Assert.assertEquals((long)(v1.getTimestamp() - v0.getTimestamp()), (long)edge.getDuration());
        edge = this.fGraph.getEdgeFrom(v0, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge);
        edge = this.fGraph.getEdgeFrom(v0, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        Assert.assertNull((Object)edge);
        edge = this.fGraph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge);
        edge = this.fGraph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        Assert.assertNull((Object)edge);
    }

    private static void checkLinkHorizontal(List<@NonNull ITmfVertex> list, ITmfGraph graph) {
        if (list.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < list.size() - 1) {
            ITmfVertex v0 = list.get(i);
            ITmfVertex v1 = list.get(i + 1);
            ITmfEdge edgeOut = graph.getEdgeFrom(v0, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
            Assert.assertNotNull((Object)edgeOut);
            Assert.assertEquals((Object)v0, (Object)edgeOut.getVertexFrom());
            Assert.assertEquals((Object)v1, (Object)edgeOut.getVertexTo());
            ITmfEdge edgeIn = graph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
            Assert.assertNotNull((Object)edgeIn);
            Assert.assertEquals((Object)v0, (Object)edgeIn.getVertexFrom());
            Assert.assertEquals((Object)v1, (Object)edgeIn.getVertexTo());
            Assert.assertEquals((Object)edgeOut.getEdgeContextState().getContextEnum(), (Object)edgeIn.getEdgeContextState().getContextEnum());
            Assert.assertNull((Object)graph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
            Assert.assertNull((Object)graph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
            Assert.assertNull((Object)graph.getEdgeFrom(v0, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE));
            Assert.assertNull((Object)graph.getEdgeFrom(v0, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE));
            ++i;
        }
    }

    @Test
    public void testTail() {
        ITmfVertex v0 = this.fGraph.createVertex(WORKER1, 0L);
        ITmfVertex v1 = this.fGraph.createVertex(WORKER1, 1L);
        ITmfVertex v2 = this.fGraph.createVertex(WORKER2, 2L);
        ITmfVertex v3 = this.fGraph.createVertex(WORKER2, 3L);
        this.fGraph.append(v0);
        this.fGraph.append(v1);
        this.fGraph.append(v2);
        this.fGraph.append(v3);
        this.fGraph.closeGraph(3L);
        Assert.assertEquals((Object)v1, (Object)this.fGraph.getTail(WORKER1));
        Assert.assertEquals((Object)v3, (Object)this.fGraph.getTail(WORKER2));
    }

    @Test
    public void testHead() {
        ITmfVertex v0 = this.fGraph.createVertex(WORKER1, 0L);
        ITmfVertex v1 = this.fGraph.createVertex(WORKER1, 1L);
        ITmfVertex v2 = this.fGraph.createVertex(WORKER2, 2L);
        ITmfVertex v3 = this.fGraph.createVertex(WORKER2, 3L);
        this.fGraph.append(v0);
        this.fGraph.append(v1);
        this.fGraph.append(v2);
        this.fGraph.append(v3);
        this.fGraph.closeGraph(3L);
        Assert.assertEquals((Object)v0, (Object)this.fGraph.getHead(WORKER1));
        Assert.assertEquals((Object)v0, (Object)this.fGraph.getHead(v1));
        Assert.assertEquals((Object)v0, (Object)this.fGraph.getHead(v0));
        Assert.assertEquals((Object)v2, (Object)this.fGraph.getHead(WORKER2));
        Assert.assertEquals((Object)v2, (Object)this.fGraph.getHead(v2));
        Assert.assertEquals((Object)v2, (Object)this.fGraph.getHead(v3));
    }

    @Test
    public void testHeadSequence() {
        ITmfVertex v0 = this.fGraph.createVertex(WORKER1, 0L);
        ITmfVertex v1 = this.fGraph.createVertex(WORKER1, 1L);
        ITmfVertex v2 = this.fGraph.createVertex(WORKER1, 2L);
        ITmfVertex v3 = this.fGraph.createVertex(WORKER1, 3L);
        this.fGraph.append(v0);
        this.fGraph.append(v1);
        this.fGraph.add(v2);
        this.fGraph.append(v3);
        this.fGraph.closeGraph(3L);
        Assert.assertEquals((Object)v0, (Object)this.fGraph.getHead(v1));
        Assert.assertEquals((Object)v0, (Object)this.fGraph.getHead(v0));
        Assert.assertEquals((Object)v2, (Object)this.fGraph.getHead(v2));
        Assert.assertEquals((Object)v2, (Object)this.fGraph.getHead(v3));
    }

    @Test
    public void testParent() {
        ITmfVertex v0 = this.fGraph.createVertex(WORKER1, 0L);
        ITmfVertex v1 = this.fGraph.createVertex(WORKER2, 1L);
        this.fGraph.append(v0);
        this.fGraph.append(v1);
        Assert.assertEquals((Object)WORKER1, (Object)this.fGraph.getParentOf(v0));
        Assert.assertNotSame((Object)WORKER1, (Object)this.fGraph.getParentOf(v1));
        Assert.assertEquals((Object)WORKER2, (Object)this.fGraph.getParentOf(v1));
    }

    private void buildFullGraph() {
        long[] lArray = new long[12];
        lArray[1] = 2L;
        lArray[2] = 4L;
        lArray[3] = 5L;
        lArray[4] = 7L;
        lArray[5] = 8L;
        lArray[6] = 9L;
        lArray[7] = 10L;
        lArray[8] = 11L;
        lArray[9] = 12L;
        lArray[10] = 13L;
        lArray[11] = 15L;
        long[] timesA = lArray;
        long[] timesB = new long[]{1L, 2L, 3L, 5L, 6L, 8L, 11L, 12L, 14L};
        ITmfVertex[] vertexA = new ITmfVertex[timesA.length];
        ITmfVertex[] vertexB = new ITmfVertex[timesB.length];
        int i = 0;
        while (i < timesA.length) {
            vertexA[i] = this.fGraph.createVertex(WORKER1, timesA[i]);
            ++i;
        }
        i = 0;
        while (i < timesB.length) {
            vertexB[i] = this.fGraph.createVertex(WORKER2, timesB[i]);
            ++i;
        }
        this.fGraph.append(vertexA[0]);
        this.fGraph.append(vertexA[1]);
        this.fGraph.add(vertexA[2]);
        this.fGraph.append(vertexA[3]);
        this.fGraph.append(vertexA[4]);
        this.fGraph.append(vertexA[5]);
        this.fGraph.append(vertexA[6]);
        this.fGraph.add(vertexA[7]);
        this.fGraph.append(vertexA[8]);
        this.fGraph.append(vertexA[9]);
        this.fGraph.append(vertexA[10]);
        this.fGraph.append(vertexA[11]);
        this.fGraph.append(vertexB[0]);
        this.fGraph.append(vertexB[1]);
        this.fGraph.append(vertexB[2]);
        this.fGraph.append(vertexB[3]);
        this.fGraph.add(vertexB[4]);
        this.fGraph.append(vertexB[5]);
        this.fGraph.append(vertexB[6]);
        this.fGraph.add(vertexB[7]);
        this.fGraph.append(vertexB[8]);
        this.fGraph.edge(vertexA[1], vertexB[1]);
        this.fGraph.edge(vertexB[3], vertexA[3]);
        this.fGraph.edge(vertexA[5], vertexB[5]);
        this.fGraph.edge(vertexB[6], vertexA[8]);
        this.fGraph.edge(vertexA[9], vertexB[7]);
    }

    @Test
    public void testScanCount() {
        this.buildFullGraph();
        ScanCountVertex visitor = new ScanCountVertex();
        this.fGraph.scanLineTraverse(this.fGraph.getHead(WORKER1), (ITmfGraphVisitor)visitor);
        Assert.assertEquals((long)21L, (long)visitor.nbVertex);
        Assert.assertEquals((long)6L, (long)visitor.nbStartVertex);
        Assert.assertEquals((long)5L, (long)visitor.nbVLink);
        Assert.assertEquals((long)15L, (long)visitor.nbHLink);
    }

    @Test
    public void testGraphStatistics() {
        this.buildFullGraph();
        TmfGraphStatistics stats = new TmfGraphStatistics();
        stats.computeGraphStatistics(this.fGraph, WORKER1);
        Assert.assertEquals((long)12L, (long)stats.getSum(WORKER1));
        Assert.assertEquals((long)11L, (long)stats.getSum(WORKER2));
        Assert.assertEquals((long)23L, (long)stats.getSum());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHorizontalSelfLink() {
        ITmfVertex v1 = this.fGraph.createVertex(WORKER1, 1L);
        this.fGraph.add(v1);
        this.fGraph.edge(v1, v1);
    }

    private class ScanCountVertex
    implements ITmfGraphVisitor {
        public int nbVertex = 0;
        public int nbVLink = 0;
        public int nbHLink = 0;
        public int nbStartVertex = 0;

        private ScanCountVertex() {
        }

        public void visitHead(ITmfVertex node) {
            System.out.println("Start vertex " + node);
            ++this.nbStartVertex;
        }

        public void visit(ITmfVertex node) {
            System.out.println("Visit vertex " + node);
            ++this.nbVertex;
        }

        public void visit(ITmfEdge edge, boolean horizontal) {
            System.out.println("Visit edge " + edge);
            if (horizontal) {
                ++this.nbHLink;
            } else {
                ++this.nbVLink;
            }
        }
    }
}

