/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.pattern.DataDrivenPattern;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenActionSegment
implements DataDrivenAction {
    private DataDrivenValue fType;
    private @Nullable DataDrivenValue fStart;
    private @Nullable DataDrivenValue fDuration;
    private @Nullable DataDrivenValue fEnd;
    private Map<String, DataDrivenValue> fFields;

    public DataDrivenActionSegment(DataDrivenValue type, @Nullable DataDrivenValue start, @Nullable DataDrivenValue duration, @Nullable DataDrivenValue end, Map<String, DataDrivenValue> fields) {
        this.fType = type;
        this.fStart = start;
        this.fDuration = duration;
        this.fEnd = end;
        this.fFields = fields;
    }

    @Override
    public void eventHandle(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        Object durationVal;
        Object startVal;
        if (!(container instanceof DataDrivenPattern)) {
            return;
        }
        DataDrivenPattern provider = (DataDrivenPattern)container;
        long start = provider.getExecutionData().getHistoryBuilder().getStartTime(container, scenarioInfo, event);
        long end = event.getTimestamp().toNanos();
        Object segmentName = this.fType.getValue(event, -1, scenarioInfo, container);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (Map.Entry<String, DataDrivenValue> field : this.fFields.entrySet()) {
            Object value = field.getValue().getValue(event, -1, scenarioInfo, container);
            if (value == null) continue;
            if (value instanceof ITmfStateValue) {
                if (((ITmfStateValue)value).isNull()) continue;
                fields.put(field.getKey(), Objects.requireNonNull(((ITmfStateValue)value).unboxValue()));
                continue;
            }
            fields.put(field.getKey(), value);
        }
        if (this.fStart != null && (startVal = this.fStart.getValue(event, -1, scenarioInfo, container)) instanceof Number) {
            start = ((Number)startVal).longValue();
        }
        if (this.fEnd != null) {
            Object endVal = this.fEnd.getValue(event, -1, scenarioInfo, container);
            if (endVal instanceof Number) {
                long endL = ((Number)endVal).longValue();
                end = endL >= start ? endL : end;
            }
        } else if (this.fDuration != null && (durationVal = this.fDuration.getValue(event, -1, scenarioInfo, container)) instanceof Number) {
            long durationL = ((Number)durationVal).longValue();
            long endL = start + durationL;
            end = endL >= start ? endL : end;
        }
        TmfXmlPatternSegment segment = new TmfXmlPatternSegment(start, end, String.valueOf(segmentName), fields);
        provider.getListener().onNewSegment((ISegment)segment);
    }

    public int hashCode() {
        return Objects.hash(this.fType, this.fStart, this.fDuration, this.fEnd, this.fFields);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DataDrivenActionSegment)) {
            return false;
        }
        DataDrivenActionSegment other = (DataDrivenActionSegment)obj;
        return Objects.equals(this.fType, other.fType) && Objects.equals(this.fStart, other.fStart) && Objects.equals(this.fDuration, other.fDuration) && Objects.equals(this.fEnd, other.fEnd) && Objects.equals(this.fFields, other.fFields);
    }

    public String toString() {
        return "Segment action " + String.valueOf(this.fType) + (String)(this.fStart == null ? "" : " start: " + String.valueOf(this.fStart) + (this.fDuration == null ? " end: " + String.valueOf(this.fEnd) : " duration: " + String.valueOf(this.fDuration))) + " fields: " + String.valueOf(this.fFields);
    }
}

