/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.Activator;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.ResourceUtil;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

@javax.ws.rs.Path(value="/traces")
public class TraceManagerService {
    @GET
    @Produces(value={"application/json"})
    public Response getTraces() {
        return Response.ok((Object)Collections2.filter((Collection)TmfTraceManager.getInstance().getOpenedTraces(), (Predicate)Predicates.not(TmfExperiment.class::isInstance))).build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putTrace(QueryParameters queryParameters) {
        Map<String, Object> parameters = queryParameters.getParameters();
        String name = (String)parameters.get("name");
        String path = (String)parameters.get("uri");
        Object typeIDObject = parameters.get("typeID");
        String typeID = typeIDObject != null ? (String)typeIDObject : "";
        @NonNull Optional optional = Iterables.tryFind((Iterable)TmfTraceManager.getInstance().getOpenedTraces(), t -> t.getPath().equals(path));
        if (optional.isPresent()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity(optional.get()).build();
        }
        if (!Paths.get(path, new String[0]).toFile().exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No trace at " + path)).build();
        }
        try {
            ITmfTrace trace = this.put(path, name, typeID);
            if (trace == null) {
                return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"Trace type not supported").build();
            }
            return Response.ok((Object)trace).build();
        }
        catch (IllegalAccessException | InstantiationException | CoreException | TmfTraceException | TmfTraceImportException e) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)e.getMessage()).build();
        }
    }

    private ITmfTrace put(String path, String name, String typeID) throws TmfTraceException, TmfTraceImportException, InstantiationException, IllegalAccessException, CoreException {
        List traceTypes = TmfTraceType.selectTraceType((String)path, (String)typeID);
        if (traceTypes.isEmpty()) {
            return null;
        }
        IResource resource = TraceManagerService.getResource(path);
        TraceTypeHelper helper = (TraceTypeHelper)traceTypes.get(0);
        ITmfTrace trace = (ITmfTrace)helper.getTraceClass().newInstance();
        trace.initTrace(resource, path, ITmfEvent.class, name, typeID);
        trace.indexTrace(false);
        ITmfContext ctx = trace.seekEvent(0L);
        trace.getNext(ctx);
        ctx.dispose();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, trace, null));
        return trace;
    }

    private static IResource getResource(String path) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        Path iPath = Path.forPosix((String)path);
        IFile resource = null;
        boolean isSuccess = false;
        if (new File(path).isFile()) {
            IFile file = project.getFile(path);
            TraceManagerService.createFolder((IFolder)file.getParent(), null);
            isSuccess = ResourceUtil.createSymbolicLink((IResource)file, (IPath)iPath, (boolean)true, null);
            resource = file;
        } else {
            IFolder folder = project.getFolder(path);
            TraceManagerService.createFolder((IFolder)folder.getParent(), null);
            isSuccess = ResourceUtil.createSymbolicLink((IResource)folder, (IPath)iPath, (boolean)true, null);
            resource = folder;
        }
        if (!isSuccess) {
            return null;
        }
        IFolder supplRootFolder = project.getFolder(".tracing");
        IFolder supplFolder = supplRootFolder.getFolder(path);
        TraceManagerService.createFolder(supplFolder, null);
        resource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocation().toOSString());
        return resource;
    }

    @GET
    @javax.ws.rs.Path(value="/{uuid}")
    @Produces(value={"application/json"})
    public Response getTrace(@PathParam(value="uuid") @NotNull UUID uuid) {
        ITmfTrace trace = TraceManagerService.getTraceByUUID(uuid);
        if (trace == null || trace instanceof TmfExperiment) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)trace).build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{uuid}")
    @Produces(value={"application/json"})
    public Response deleteTrace(@PathParam(value="uuid") @NotNull UUID uuid) {
        ITmfTrace trace = TraceManagerService.getTraceByUUID(uuid);
        if (trace == null || trace instanceof TmfExperiment) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)this, trace));
        trace.dispose();
        TmfTraceManager.deleteSupplementaryFolder((ITmfTrace)trace);
        try {
            IResource resource = trace.getResource();
            if (resource != null) {
                resource.delete(1, null);
            }
            ResourcesPlugin.getWorkspace().getRoot().getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME).refreshLocal(Integer.MAX_VALUE, null);
        }
        catch (CoreException e) {
            Activator.getInstance().logError("Failed to delete trace", (Throwable)e);
        }
        return Response.ok((Object)trace).build();
    }

    public static @Nullable ITmfTrace getTraceByUUID(UUID uuid) {
        return (ITmfTrace)Iterables.tryFind((Iterable)TmfTraceManager.getInstance().getOpenedTraces(), t -> uuid.equals(t.getUUID())).orNull();
    }

    private static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                TraceManagerService.createFolder((IFolder)folder.getParent(), monitor);
            }
            folder.create(true, true, monitor);
        }
    }
}

