/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.rocm.core.trace;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.counters.core.CounterAnalysis;
import org.eclipse.tracecompass.analysis.counters.core.aspects.CounterAspect;
import org.eclipse.tracecompass.incubator.rocm.core.trace.GpuAspect;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public class RocmCounterAspect
extends CounterAspect {
    private Integer fCounterId;

    public RocmCounterAspect(@NonNull String fieldName, @NonNull String label, Class<@NonNull GpuAspect> class1, Integer counterId) {
        super(fieldName, label, new Class[]{class1});
        this.fCounterId = counterId;
    }

    public RocmCounterAspect(@NonNull String fieldName, @NonNull String label, Integer counterId) {
        super(fieldName, label, new Class[0]);
        this.fCounterId = counterId;
    }

    public boolean isCumulative() {
        return false;
    }

    public @Nullable Number resolve(@NonNull ITmfEvent event) {
        Integer counterId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"id"});
        if (this.fCounterId.equals(counterId)) {
            if (event.getName().equals("metric_double")) {
                return (Number)event.getContent().getFieldValue(Double.class, new String[]{"value"});
            }
            if (event.getName().equals("metric_uint64")) {
                return (Number)event.getContent().getFieldValue(Long.class, new String[]{"value"});
            }
        }
        if (event.getName().equals("hip_activity")) {
            CounterAnalysis module = (CounterAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)event.getTrace(), CounterAnalysis.class, (String)"org.eclipse.tracecompass.analysis.counters.core.counteranalysis");
            if (module == null) {
                return null;
            }
            ITmfStateSystem ss = module.getStateSystem();
            if (ss == null) {
                return null;
            }
            try {
                String gpuId = (String)event.getContent().getFieldValue(String.class, new String[]{"device_id"});
                int groupQuark = ss.getQuarkAbsolute(new String[]{"Grouped"});
                int gpuGroupQuark = ss.getQuarkRelative(groupQuark, new String[]{GpuAspect.INSTANCE.getName()});
                int gpuQuark = ss.getQuarkRelative(gpuGroupQuark, new String[]{gpuId});
                int counterQuark = ss.getQuarkRelative(gpuQuark, new String[]{this.getName()});
                Long timestampEnd = (Long)event.getContent().getFieldValue(Long.class, new String[]{"end"});
                if (timestampEnd != null) {
                    long valueBefore = ss.querySingleState(event.getTimestamp().getValue(), counterQuark).getValueLong();
                    long valueAfter = ss.querySingleState(((CtfTmfTrace)event.getTrace()).timestampCyclesToNanos(timestampEnd.longValue()), counterQuark).getValueLong();
                    return valueAfter - valueBefore;
                }
            }
            catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
                return null;
            }
        }
        return null;
    }
}

