/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SegmentStoreDensityDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeXYDataProvider<TmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreDensityDataProvider";
    private static final AtomicLong TRACE_IDS = new AtomicLong();
    private final String fID;
    private final String title = Objects.requireNonNull(Messages.SegmentStoreDensityDataProvider_title);
    private final ISegmentStoreProvider fProvider;
    private final long fTotalId = TRACE_IDS.getAndIncrement();
    private final long fTraceId = TRACE_IDS.getAndIncrement();

    public SegmentStoreDensityDataProvider(ITmfTrace trace, ISegmentStoreProvider provider, String id) {
        super(trace);
        this.fProvider = provider;
        this.fID = id;
        if (provider instanceof IAnalysisModule) {
            ((IAnalysisModule)provider).waitForCompletion();
        }
    }

    public TmfModelResponse<ITmfXyModel> fetchXY(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ISegmentStore<ISegment> segmentStore = this.fProvider.getSegmentStore();
        if (segmentStore == null) {
            return TmfXyResponseFactory.createFailedResponse((String)Objects.requireNonNull(Messages.SegmentStoreDataProvider_SegmentNotAvailable));
        }
        SelectionTimeQueryFilter queryFilter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (queryFilter == null && (queryFilter = FetchParametersUtils.createTimeQuery(fetchParameters)) == null) {
            return TmfXyResponseFactory.createFailedResponse((String)CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        return this.getXyData(segmentStore, (TimeQueryFilter)queryFilter);
    }

    private TmfModelResponse<ITmfXyModel> getXyData(ISegmentStore<ISegment> segmentStore, TimeQueryFilter queryFilter) {
        long startTraceTime = queryFilter.getStart();
        long endTraceTime = queryFilter.getEnd();
        int width = queryFilter.getTimesRequested().length;
        Iterable displayData = segmentStore.getIntersectingElements(startTraceTime, endTraceTime);
        IAnalysisModule module = this.fProvider instanceof IAnalysisModule ? (IAnalysisModule)this.fProvider : null;
        boolean complete = module != null && module.isQueryable(queryFilter.getEnd());
        Optional maxSegment = StreamSupport.stream(displayData.spliterator(), false).max(SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
        long maxLength = 1L;
        if (maxSegment.isPresent()) {
            maxLength = ((ISegment)maxSegment.get()).getLength();
        }
        double[] yValues = SegmentStoreDensityDataProvider.getYValues(displayData, width, maxLength);
        long[] xValues = SegmentStoreDensityDataProvider.getXValues(width, maxLength);
        ImmutableList.Builder builder = ImmutableList.builder();
        String totalName = String.valueOf(this.getTrace().getName()) + '/' + Messages.SegmentStoreDensity_TotalLabel;
        builder.add((Object)new YModel(this.fTotalId, totalName, yValues));
        return TmfXyResponseFactory.create((String)this.title, (long[])xValues, (Collection)builder.build(), (boolean)complete);
    }

    private static long[] getXValues(int width, long maxLength) {
        double timeWidth = (double)maxLength / (double)width;
        long[] xValues = new long[width];
        int i = 0;
        while (i < width) {
            xValues[i] = (long)((double)i * timeWidth);
            int n = i++;
            xValues[n] = (long)((double)xValues[n] + timeWidth / 2.0);
        }
        return xValues;
    }

    private static double[] getYValues(Iterable<ISegment> displayData, int width, long maxLength) {
        double maxFactor = 1.0 / ((double)maxLength + 1.0);
        double[] yValues = new double[width];
        Arrays.fill(yValues, Double.MIN_VALUE);
        for (ISegment segment : displayData) {
            double xBox = (double)segment.getLength() * maxFactor * (double)width;
            if (yValues[(int)xBox] < 1.0) {
                yValues[(int)xBox] = 1.0;
                continue;
            }
            int n = (int)xBox;
            yValues[n] = yValues[n] + 1.0;
        }
        return yValues;
    }

    public TmfModelResponse<TmfTreeModel<TmfTreeDataModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new TmfTreeDataModel(this.fTraceId, -1L, Collections.singletonList(String.valueOf(this.getTrace().getName()))));
        builder.add((Object)new TmfTreeDataModel(this.fTotalId, this.fTraceId, Collections.singletonList(Objects.requireNonNull(Messages.SegmentStoreDensity_TotalLabel))));
        return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), (List)builder.build()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public String getId() {
        return this.fID;
    }
}

