/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2CallbackObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2CallbackType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2NodeObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2Object;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class Ros2ObjectsUtil {
    private static final @NonNull String OBJECT_NODE = "Nodes";
    private static final @NonNull String OBJECT_PUBLISHER = "Publishers";
    private static final @NonNull String OBJECT_SUBSCRIPTION = "Subscriptions";
    private static final @NonNull String OBJECT_TIMER = "Timers";
    private static final @NonNull String OBJECT_CALLBACK = "Callbacks";

    private Ros2ObjectsUtil() {
    }

    private static void assertStateSystem(ITmfStateSystem ss) {
        if (!ss.getSSID().equals(Ros2ObjectsAnalysis.getFullAnalysisId())) {
            throw new IllegalArgumentException(String.format("wrong state system; need '%s', got '%s'", Ros2ObjectsAnalysis.getFullAnalysisId(), ss.getSSID()));
        }
    }

    private static String[] getNodeAttribute(@NonNull String stringId) {
        return new String[]{OBJECT_NODE, stringId};
    }

    private static String[] getPublisherAttribute(@NonNull String stringId) {
        return new String[]{OBJECT_PUBLISHER, stringId};
    }

    private static String[] getSubscriptionAttribute(@NonNull String stringId) {
        return new String[]{OBJECT_SUBSCRIPTION, stringId};
    }

    private static String[] getTimerAttribute(@NonNull String stringId) {
        return new String[]{OBJECT_TIMER, stringId};
    }

    private static String[] getCallbackAttribute(@NonNull String stringId) {
        return new String[]{OBJECT_CALLBACK, stringId};
    }

    private static String[] getNodeAttribute(@NonNull Ros2ObjectHandle nodeHandle) {
        return Ros2ObjectsUtil.getNodeAttribute(nodeHandle.getStringId());
    }

    private static String[] getPublisherAttribute(@NonNull Ros2ObjectHandle publisherHandle) {
        return Ros2ObjectsUtil.getPublisherAttribute(publisherHandle.getStringId());
    }

    private static String[] getSubscriptionAttribute(@NonNull Ros2ObjectHandle subscriptionHandle) {
        return Ros2ObjectsUtil.getSubscriptionAttribute(subscriptionHandle.getStringId());
    }

    private static String[] getTimerAttribute(@NonNull Ros2ObjectHandle timerHandle) {
        return Ros2ObjectsUtil.getTimerAttribute(timerHandle.getStringId());
    }

    private static String[] getCallbackAttribute(@NonNull HostProcessPointer callbackHandle) {
        return Ros2ObjectsUtil.getCallbackAttribute(callbackHandle.getStringId());
    }

    public static int getNodeQuarkAndAdd(ITmfStateSystemBuilder ss, @NonNull Ros2ObjectHandle nodeHandle) {
        Ros2ObjectsUtil.assertStateSystem((ITmfStateSystem)ss);
        return ss.getQuarkAbsoluteAndAdd(Ros2ObjectsUtil.getNodeAttribute(nodeHandle));
    }

    public static int getPublisherQuarkAndAdd(ITmfStateSystemBuilder ss, @NonNull Ros2ObjectHandle publisherHandle) {
        Ros2ObjectsUtil.assertStateSystem((ITmfStateSystem)ss);
        return ss.getQuarkAbsoluteAndAdd(Ros2ObjectsUtil.getPublisherAttribute(publisherHandle));
    }

    public static int getSubscriptionQuarkAndAdd(ITmfStateSystemBuilder ss, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Ros2ObjectsUtil.assertStateSystem((ITmfStateSystem)ss);
        return ss.getQuarkAbsoluteAndAdd(Ros2ObjectsUtil.getSubscriptionAttribute(subscriptionHandle));
    }

    public static int getTimerQuarkAndAdd(ITmfStateSystemBuilder ss, @NonNull Ros2ObjectHandle timerHandle) {
        Ros2ObjectsUtil.assertStateSystem((ITmfStateSystem)ss);
        return ss.getQuarkAbsoluteAndAdd(Ros2ObjectsUtil.getTimerAttribute(timerHandle));
    }

    public static int getCallbackQuarkAndAdd(ITmfStateSystemBuilder ss, @NonNull HostProcessPointer callbackHandle) {
        Ros2ObjectsUtil.assertStateSystem((ITmfStateSystem)ss);
        return ss.getQuarkAbsoluteAndAdd(Ros2ObjectsUtil.getCallbackAttribute(callbackHandle));
    }

    private static Integer getNodeQuark(ITmfStateSystem ss, @NonNull Ros2ObjectHandle nodeHandle) {
        Ros2ObjectsUtil.assertStateSystem(ss);
        try {
            return ss.getQuarkAbsolute(Ros2ObjectsUtil.getNodeAttribute(nodeHandle));
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
    }

    private static Integer getPublisherQuark(ITmfStateSystem ss, @NonNull Ros2ObjectHandle publisherHandle) {
        Ros2ObjectsUtil.assertStateSystem(ss);
        try {
            return ss.getQuarkAbsolute(Ros2ObjectsUtil.getPublisherAttribute(publisherHandle));
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
    }

    private static Integer getSubscriptionQuark(ITmfStateSystem ss, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Ros2ObjectsUtil.assertStateSystem(ss);
        try {
            return ss.getQuarkAbsolute(Ros2ObjectsUtil.getSubscriptionAttribute(subscriptionHandle));
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
    }

    private static Integer getTimerQuark(ITmfStateSystem ss, @NonNull Ros2ObjectHandle timerHandle) {
        Ros2ObjectsUtil.assertStateSystem(ss);
        try {
            return ss.getQuarkAbsolute(Ros2ObjectsUtil.getTimerAttribute(timerHandle));
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
    }

    private static Integer getCallbackQuark(ITmfStateSystem ss, @NonNull HostProcessPointer callbackHandle) {
        Ros2ObjectsUtil.assertStateSystem(ss);
        try {
            return ss.getQuarkAbsolute(Ros2ObjectsUtil.getCallbackAttribute(callbackHandle));
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
    }

    public static @Nullable ITmfStateInterval getNodeObjectIntervalFromHandle(ITmfStateSystem ss, long timestamp, @NonNull Ros2ObjectHandle nodeHandle) {
        Integer nodeQuark = Ros2ObjectsUtil.getNodeQuark(ss, nodeHandle);
        if (nodeQuark == null) {
            return null;
        }
        try {
            return ss.querySingleState(timestamp, nodeQuark.intValue());
        }
        catch (StateSystemDisposedException e) {
            return null;
        }
    }

    public static @Nullable Ros2NodeObject getNodeObjectFromHandle(ITmfStateSystem ss, long timestamp, @NonNull Ros2ObjectHandle nodeHandle) {
        @Nullable ITmfStateInterval nodeObjectInterval = Ros2ObjectsUtil.getNodeObjectIntervalFromHandle(ss, timestamp, nodeHandle);
        if (nodeObjectInterval != null && nodeObjectInterval.getValue() != null) {
            return (Ros2NodeObject)((Object)nodeObjectInterval.getValue());
        }
        return null;
    }

    private static @NonNull String getMissingIntervalMessage(boolean multipleUnexpected, @NonNull Class<@NonNull ?> clazz, Integer quark) {
        return String.format("%s %s state intervals for quark=%d", multipleUnexpected ? "more than 1" : "no", clazz.getName(), quark);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static <O extends Ros2Object<?>> @Nullable O getObjectFromHandle(ITmfStateSystem ss, @NonNull Class<@NonNull O> objectClass, @NonNull String objectListAttribute, @NonNull Ros2ObjectHandle objectHandle) {
        Ros2ObjectsUtil.assertStateSystem(ss);
        try {
            int objectQuark = ss.getQuarkAbsolute(new String[]{objectListAttribute, objectHandle.getStringId()});
            @NonNull Iterable objectIntervalsIterable = ss.query2D(Collections.singleton(objectQuark), ss.getStartTime(), ss.getCurrentEndTime());
            List<@NonNull T> objectIntervals = Lists.newArrayList((Iterable)objectIntervalsIterable).stream().filter(interval -> interval.getValue() != null).collect(Collectors.toList());
            if (!objectIntervals.isEmpty()) {
                if (objectIntervals.size() > 1) {
                    Activator.getInstance().logError(Ros2ObjectsUtil.getMissingIntervalMessage(true, objectClass, objectQuark));
                }
                Ros2Object object = (Ros2Object)((Object)((ITmfStateInterval)objectIntervals.get(0)).getValue());
                return (O)((Object)object);
            }
            Activator.getInstance().logError(Ros2ObjectsUtil.getMissingIntervalMessage(false, objectClass, objectQuark));
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            return null;
        }
        return null;
    }

    public static @Nullable Ros2SubscriptionObject getSubscriptionObjectFromHandle(ITmfStateSystem ss, long timestamp, @NonNull Ros2ObjectHandle subscriptionHandle) {
        Integer subQuark = Ros2ObjectsUtil.getSubscriptionQuark(ss, subscriptionHandle);
        if (subQuark == null) {
            return null;
        }
        try {
            return (Ros2SubscriptionObject)((Object)ss.querySingleState(timestamp, subQuark.intValue()).getValue());
        }
        catch (StateSystemDisposedException e) {
            return null;
        }
    }

    public static @Nullable Ros2PublisherObject getPublisherObjectFromHandle(ITmfStateSystem ss, long timestamp, @NonNull Ros2ObjectHandle publisherHandle) {
        Integer pubQuark = Ros2ObjectsUtil.getPublisherQuark(ss, publisherHandle);
        if (pubQuark == null) {
            return null;
        }
        try {
            return (Ros2PublisherObject)((Object)ss.querySingleState(timestamp, pubQuark.intValue()).getValue());
        }
        catch (StateSystemDisposedException e) {
            return null;
        }
    }

    public static @Nullable Ros2TimerObject getTimerObjectFromHandle(ITmfStateSystem ss, long timestamp, @NonNull Ros2ObjectHandle timerHandle) {
        Integer timerQuark = Ros2ObjectsUtil.getTimerQuark(ss, timerHandle);
        if (timerQuark == null) {
            return null;
        }
        try {
            return (Ros2TimerObject)((Object)ss.querySingleState(timestamp, timerQuark.intValue()).getValue());
        }
        catch (StateSystemDisposedException e) {
            return null;
        }
    }

    public static @Nullable Ros2SubscriptionObject getSubscriptionObjectFromHandle(ITmfStateSystem ss, @NonNull Ros2ObjectHandle subscriptionHandle) {
        return Ros2ObjectsUtil.getObjectFromHandle(ss, Ros2SubscriptionObject.class, OBJECT_SUBSCRIPTION, subscriptionHandle);
    }

    public static @Nullable Ros2PublisherObject getPublisherObjectFromHandle(ITmfStateSystem ss, @NonNull Ros2ObjectHandle publisherHandle) {
        return Ros2ObjectsUtil.getObjectFromHandle(ss, Ros2PublisherObject.class, OBJECT_PUBLISHER, publisherHandle);
    }

    public static @Nullable Ros2NodeObject getNodeObjectFromHandle(ITmfStateSystem ss, @NonNull Ros2ObjectHandle nodeHandle) {
        return Ros2ObjectsUtil.getObjectFromHandle(ss, Ros2NodeObject.class, OBJECT_NODE, nodeHandle);
    }

    public static @Nullable Ros2TimerObject getTimerObjectFromHandle(ITmfStateSystem ss, @NonNull Ros2ObjectHandle timerHandle) {
        return Ros2ObjectsUtil.getObjectFromHandle(ss, Ros2TimerObject.class, OBJECT_TIMER, timerHandle);
    }

    public static @Nullable Ros2CallbackObject getCallbackObjectFromHandle(ITmfStateSystem ss, long timestamp, @NonNull HostProcessPointer callback) {
        Integer callbackQuark = Ros2ObjectsUtil.getCallbackQuark(ss, callback);
        if (callbackQuark == null) {
            return null;
        }
        try {
            return (Ros2CallbackObject)((Object)ss.querySingleState(timestamp, callbackQuark.intValue()).getValue());
        }
        catch (StateSystemDisposedException e) {
            return null;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable Ros2ObjectHandle getSubscriptionHandleFromRmwSubscriptionHandle(ITmfStateSystem ss, long timestamp, @NonNull Ros2ObjectHandle rmwSubscriptionHandle) {
        Ros2ObjectsUtil.assertStateSystem(ss);
        try {
            int subscriptionsQuark = ss.getQuarkAbsolute(new String[]{OBJECT_SUBSCRIPTION});
            @NonNull List subsQuarks = ss.getSubAttributes(subscriptionsQuark, false);
            for (Integer subQuark : subsQuarks) {
                Ros2SubscriptionObject subscription = (Ros2SubscriptionObject)((Object)ss.querySingleState(timestamp, subQuark.intValue()).getValue());
                if (subscription == null || !subscription.getRmwHandle().equals((Object)rmwSubscriptionHandle)) continue;
                return (Ros2ObjectHandle)((Object)subscription.getHandle());
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            return null;
        }
        return null;
    }

    public static @Nullable Pair<@NonNull Ros2ObjectHandle, Ros2CallbackType> getCallbackOwnerHandle(ITmfStateSystem ss, long timestamp, @NonNull HostProcessPointer callback) {
        @Nullable Ros2CallbackObject callbackObject = Ros2ObjectsUtil.getCallbackObjectFromHandle(ss, timestamp, callback);
        if (callbackObject != null) {
            return new Pair((Object)callbackObject.getOwnerHandle(), (Object)callbackObject.getCallbackType());
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static <O extends Ros2Object<?>> Collection<@NonNull ITmfStateInterval> getObjectsIntervals(ITmfStateSystem ss, @NonNull Class<@NonNull O> objectClass, @NonNull String objectListAttribute) {
        Ros2ObjectsUtil.assertStateSystem(ss);
        try {
            ArrayList<@NonNull ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
            for (Integer quark : ss.getQuarks(new String[]{objectListAttribute, "*"})) {
                @NonNull Iterable objectIntervalsIterable = ss.query2D(Collections.singleton(quark), ss.getStartTime(), ss.getCurrentEndTime());
                List<@NonNull T> objectIntervals = Lists.newArrayList((Iterable)objectIntervalsIterable).stream().filter(interval -> interval.getValue() != null).collect(Collectors.toList());
                if (objectIntervals.isEmpty()) {
                    Activator.getInstance().logError(Ros2ObjectsUtil.getMissingIntervalMessage(false, objectClass, quark));
                    continue;
                }
                if (objectIntervals.size() > 1) {
                    Activator.getInstance().logError(Ros2ObjectsUtil.getMissingIntervalMessage(true, objectClass, quark));
                }
                intervals.add((ITmfStateInterval)objectIntervals.get(0));
            }
            return intervals;
        }
        catch (StateSystemDisposedException e) {
            return Collections.emptyList();
        }
    }

    public static Collection<@NonNull ITmfStateInterval> getNodeObjectIntervals(ITmfStateSystem ss) {
        return Ros2ObjectsUtil.getObjectsIntervals(ss, Ros2NodeObject.class, OBJECT_NODE);
    }

    private static <O extends Ros2Object<?>> Collection<@NonNull O> getObjects(ITmfStateSystem ss, @NonNull Class<@NonNull O> objectClass, @NonNull String objectListAttribute) {
        return Ros2ObjectsUtil.getObjectsIntervals(ss, objectClass, objectListAttribute).stream().map(interval -> (Ros2Object)((Object)((Object)interval.getValue()))).collect(Collectors.toList());
    }

    public static Collection<@NonNull Ros2NodeObject> getNodeObjects(ITmfStateSystem ss) {
        return Ros2ObjectsUtil.getObjects(ss, Ros2NodeObject.class, OBJECT_NODE);
    }

    public static Collection<@NonNull Ros2PublisherObject> getPublisherObjects(ITmfStateSystem ss) {
        return Ros2ObjectsUtil.getObjects(ss, Ros2PublisherObject.class, OBJECT_PUBLISHER);
    }

    public static Collection<@NonNull Ros2SubscriptionObject> getSubscriptionObjects(ITmfStateSystem ss) {
        return Ros2ObjectsUtil.getObjects(ss, Ros2SubscriptionObject.class, OBJECT_SUBSCRIPTION);
    }

    public static Collection<@NonNull Ros2TimerObject> getTimerObjects(ITmfStateSystem ss) {
        return Ros2ObjectsUtil.getObjects(ss, Ros2TimerObject.class, OBJECT_TIMER);
    }
}

