/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.summarytimeline;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.callstack.core.Activator;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.summarytimeline.Otf2SummaryTimelineAnalysis;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IODataPalette;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class Otf2SummaryTimelineDataProvider
extends AbstractTreeCommonXDataProvider<Otf2SummaryTimelineAnalysis, TmfTreeDataModel>
implements IOutputStyleProvider {
    private static final String TOTAL = "total";
    private static final String AREA_STYLE = "area";
    private static final String LINE_STYLE = "line";
    private static final Map<String, OutputElementStyle> STATE_MAP;
    private static final List<Pair<String, String>> COLOR_LIST;
    private static final TmfXYAxisDescription Y_AXIS_DESCRIPTION;
    private static final List<String> SUPPORTED_STYLES;
    public static final String SUFFIX = ".dataprovider";
    private static final AtomicLong sfAtomicId;
    private final BiMap<Long, Integer> fIDToDisplayQuark = HashBiMap.create();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static {
        COLOR_LIST = IODataPalette.getColors();
        Y_AXIS_DESCRIPTION = new TmfXYAxisDescription("Percentage of locations in this type of function", "%", DataType.NUMBER);
        SUPPORTED_STYLES = ImmutableList.of((Object)"SOLID", (Object)"DASH", (Object)"DOT", (Object)"DASHDOT", (Object)"DASHDOTDOT");
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull @NonNull ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)AREA_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"series-type", (Object)AREA_STYLE, (Object)"width", (Object)Float.valueOf(1.0f))));
        builder.put((Object)LINE_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"series-type", (Object)LINE_STYLE, (Object)"width", (Object)Float.valueOf(1.0f))));
        STATE_MAP = builder.build();
        sfAtomicId = new AtomicLong();
    }

    public Otf2SummaryTimelineDataProvider(ITmfTrace trace, Otf2SummaryTimelineAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    public static @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> create(ITmfTrace trace) {
        Otf2SummaryTimelineAnalysis module = (Otf2SummaryTimelineAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, Otf2SummaryTimelineAnalysis.class, (String)Otf2SummaryTimelineAnalysis.getFullAnalysisId());
        return module != null ? new Otf2SummaryTimelineDataProvider(trace, module) : null;
    }

    public String getId() {
        return ((Otf2SummaryTimelineAnalysis)this.getAnalysisModule()).getId() + SUFFIX;
    }

    protected boolean isCacheable() {
        return false;
    }

    protected TmfTreeModel<TmfTreeDataModel> getTree(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        ArrayList<TmfTreeDataModel> entryList = new ArrayList<TmfTreeDataModel>();
        int styleIndex = 0;
        for (Integer quark : ss.getQuarks(new String[]{"*"})) {
            Long id = (Long)this.fIDToDisplayQuark.inverse().computeIfAbsent((Object)quark, q -> sfAtomicId.getAndIncrement());
            entryList.add(new TmfTreeDataModel(id.longValue(), -1L, ss.getAttributeName(quark.intValue())));
            if (ss.getSubAttributes(quark.intValue(), false).isEmpty()) continue;
            for (Integer subQuark : ss.getSubAttributes(quark.intValue(), false)) {
                Long subQuarkId = (Long)this.fIDToDisplayQuark.inverse().computeIfAbsent((Object)subQuark, q -> sfAtomicId.getAndIncrement());
                String seriesStyle = SUPPORTED_STYLES.get(styleIndex / COLOR_LIST.size() % SUPPORTED_STYLES.size());
                Pair<String, String> pair = COLOR_LIST.get(styleIndex % COLOR_LIST.size());
                String styleType = ss.getAttributeName(subQuark.intValue()).equals(TOTAL) ? LINE_STYLE : AREA_STYLE;
                entryList.add(new TmfTreeDataModel(subQuarkId.longValue(), id.longValue(), Collections.singletonList(ss.getAttributeName(subQuark.intValue())), true, new OutputElementStyle(styleType, (Map)ImmutableMap.of((Object)"color", (Object)pair.getFirst(), (Object)"series-style", (Object)seriesStyle, (Object)"style-name", (Object)ss.getAttributeName(subQuark.intValue())))));
                ++styleIndex;
            }
        }
        return new TmfTreeModel(Collections.emptyList(), entryList);
    }

    private static List<Long> getTimes(ITmfStateSystem key, @Nullable List<Long> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<@NonNull Long> times = new ArrayList<Long>();
        for (long t : list) {
            if (key.getStartTime() > t || t > key.getCurrentEndTime()) continue;
            times.add(t);
        }
        Collections.sort(times);
        return times;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable Collection<IYModel> getYSeriesModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        ImmutableList.Builder ySeries = ImmutableList.builder();
        HashMap<Integer, double[]> quarkToValues = new HashMap<Integer, double[]>();
        Collection selectedItems = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (selectedItems == null) {
            selectedItems = this.fIDToDisplayQuark.keySet();
        }
        List<Long> times = Otf2SummaryTimelineDataProvider.getTimes(ss, DataProviderParameterUtils.extractTimeRequested(fetchParameters));
        for (Long l : selectedItems) {
            Integer quark = (Integer)this.fIDToDisplayQuark.get((Object)l);
            if (quark == null) continue;
            quarkToValues.put(quark, new double[times.size()]);
        }
        try {
            for (ITmfStateInterval iTmfStateInterval : ss.query2D(quarkToValues.keySet(), times)) {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                double[] row = (double[])quarkToValues.get(iTmfStateInterval.getAttribute());
                Object value = iTmfStateInterval.getValue();
                if (row == null || !(value instanceof Number)) continue;
                Double dblValue = ((Number)value).doubleValue();
                int i = 0;
                while (i < times.size()) {
                    Long time = times.get(i);
                    if (iTmfStateInterval.getStartTime() <= time && iTmfStateInterval.getEndTime() >= time) {
                        row[i] = 100.0 * dblValue;
                    }
                    ++i;
                }
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            Activator.getInstance().logError(throwable.getMessage(), throwable);
            return null;
        }
        for (Map.Entry entry : quarkToValues.entrySet()) {
            if (!ss.getSubAttributes(((Integer)entry.getKey()).intValue(), false).isEmpty()) continue;
            ySeries.add((Object)new YModel(((Long)this.fIDToDisplayQuark.inverse().getOrDefault(entry.getKey(), (Object)-1L)).longValue(), ss.getAttributeName(((Integer)entry.getKey()).intValue()), (double[])entry.getValue(), Y_AXIS_DESCRIPTION));
        }
        return ySeries.build();
    }

    protected String getTitle() {
        return "Summary Timeline";
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STATE_MAP), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }
}

