/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.otf2.core.trace;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.counters.core.CounterType;
import org.eclipse.tracecompass.analysis.counters.core.aspects.CounterAspect;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.MetricMember;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2ClusterAspect;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2PhysicalNodeAspect;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2ProcessAspect;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2ThreadAspect;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class Otf2CounterAspect
extends CounterAspect {
    private final Set<Pair<Long, Long>> fIds = new HashSet<Pair<Long, Long>>();
    private final MetricMember fMetricMember;

    public Otf2CounterAspect(MetricMember metricMember) {
        super("metricValue", metricMember.getName(), metricMember.getCounterType(), new Class[]{Otf2ClusterAspect.class, Otf2PhysicalNodeAspect.class, Otf2ProcessAspect.class, Otf2ThreadAspect.class});
        this.fMetricMember = metricMember;
    }

    public void addNewIds(Pair<Long, Long> ids) {
        this.fIds.add(ids);
    }

    public @Nullable Number resolve(@NonNull ITmfEvent event) {
        Long metricClassId = (Long)event.getContent().getFieldValue(Long.class, new String[]{"metric"});
        Long index = (Long)event.getContent().getFieldValue(Long.class, new String[]{"index"});
        if (metricClassId == null || index == null || !this.fIds.contains(new Pair((Object)metricClassId, (Object)index))) {
            return null;
        }
        Number counterValue = switch (this.fMetricMember.getCounterType()) {
            case CounterType.DOUBLE -> (Number)event.getContent().getFieldValue(Double.class, new String[]{"metricValue"});
            case CounterType.LONG -> (Number)event.getContent().getFieldValue(Long.class, new String[]{"metricValue"});
            default -> null;
        };
        if (counterValue == null) {
            return null;
        }
        return this.fMetricMember.computeValueWithDefinedUnit(counterValue);
    }

    public String getHelpText() {
        return this.fMetricMember.getDescription();
    }

    public String getName() {
        return String.valueOf(this.fMetricMember.getName()) + " (" + this.fMetricMember.getUnit() + ")";
    }

    public boolean isCumulative() {
        int modeCode = this.fMetricMember.getMode() & 0xF;
        return modeCode < 4 || modeCode > 6;
    }
}

