/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.callstack;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackSeries;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.InstrumentedCallStackAnalysis;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.AbstractOtf2Analysis;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.callstack.Otf2CallStackStateProvider;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2Trace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2CallstackAnalysis
extends InstrumentedCallStackAnalysis {
    private static final String ID_SUFFIX = ".callstack";
    private static final int THREAD_DEPTH = 3;

    public String getId() {
        return AbstractOtf2Analysis.getAnalysisIdFromSuffix(ID_SUFFIX);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CallStackSeries.IThreadIdResolver getCallStackTidResolver() {
        return new CallStackSeries.AttributeValueThreadResolver(3);
    }

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = Objects.requireNonNull(this.getTrace());
        if (trace instanceof Otf2Trace) {
            return new Otf2CallStackStateProvider(trace);
        }
        throw new IllegalStateException("Trace is not an OTF2 trace");
    }

    protected Collection<Integer> getEdgeQuarks() {
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            return Collections.emptyList();
        }
        int edgeQuark = ss.optQuarkAbsolute(new String[]{"Edges"});
        if (edgeQuark == -2) {
            return Collections.emptyList();
        }
        return ss.getSubAttributes(edgeQuark, false);
    }

    protected List<String[]> getPatterns() {
        return ImmutableList.of((Object)new String[]{"Processes", "*"}, (Object)new String[]{"*"}, (Object)new String[]{"*"}, (Object)new String[]{"*"});
    }
}

