/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.wst.jsdt.ui.JSdocContentAccess;

public class ProposalInfo {
    private boolean fJavadocResolved = false;
    private String fJavadoc = null;
    protected IJavaScriptElement fElement;

    public ProposalInfo(IMember member) {
        this.fElement = member;
    }

    protected ProposalInfo() {
        this.fElement = null;
    }

    public IJavaScriptElement getJavaElement() throws JavaScriptModelException {
        return this.fElement;
    }

    public final String getInfo(IProgressMonitor monitor) {
        if (!this.fJavadocResolved) {
            this.fJavadocResolved = true;
            this.fJavadoc = this.computeInfo(monitor);
        }
        return this.fJavadoc;
    }

    private String computeInfo(IProgressMonitor monitor) {
        try {
            IJavaScriptElement javaElement = this.getJavaElement();
            return this.extractJavadoc(javaElement, monitor);
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
        catch (IOException e) {
            JavaScriptPlugin.log(e);
        }
        return null;
    }

    private String extractJavadoc(IJavaScriptElement element, IProgressMonitor monitor) throws JavaScriptModelException, IOException {
        Reader reader;
        if (element != null && (reader = this.getHTMLContentReader(element, monitor)) != null) {
            return ProposalInfo.getString(reader);
        }
        return null;
    }

    private Reader getHTMLContentReader(IJavaScriptElement element, IProgressMonitor monitor) throws JavaScriptModelException {
        String s;
        Reader contentReader = JSdocContentAccess.getHTMLContentReader(element, true, true);
        if (contentReader != null) {
            return contentReader;
        }
        contentReader = JSdocContentAccess.getContentReader(element, true);
        if (contentReader != null) {
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        if (element.getOpenable().getBuffer() == null && (s = element.getAttachedJavadoc(monitor)) != null) {
            return new StringReader(s);
        }
        return null;
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }
}

