/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.summarytimeline;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.AbstractOtf2StateProvider;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.summarytimeline.Otf2SummaryTimelineAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2SummaryTimelineStateProvider
extends AbstractOtf2StateProvider {
    private static int VERSION_NUMBER = 1;
    private static final String API_FUNCTION_PATTERN = "^(?<API>[a-zA-Z0-9]*)_(?<function>.*)";
    private static final String FUNCTION = "function";
    private static final String API = "API";
    private static final String OTHER = "other";
    private static final String MPI = "MPI";
    private static final String PTHREAD = "pthread";
    private static final String TOTAL = "total";
    private final Map<Long, Location> fMapLocation = new HashMap<Long, Location>();
    private long fNumberOfLocations = 0L;

    private static int getQuarkFromRegion(String regionName, ITmfStateSystemBuilder ssb) {
        Pattern functionPattern = Pattern.compile(API_FUNCTION_PATTERN);
        Matcher matcher = functionPattern.matcher(regionName);
        if (!matcher.matches()) {
            int defaultQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{OTHER});
            return defaultQuark;
        }
        String api = matcher.group(API);
        String function = matcher.group(FUNCTION);
        if (api.equals(MPI)) {
            int mpiQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{MPI});
            int functionQuark = ssb.getQuarkRelativeAndAdd(mpiQuark, new String[]{function});
            return functionQuark;
        }
        if (api.equals(PTHREAD)) {
            int pthreadQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{PTHREAD});
            int functionQuark = ssb.getQuarkRelativeAndAdd(pthreadQuark, new String[]{function});
            return functionQuark;
        }
        int applicationQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{OTHER});
        return applicationQuark;
    }

    public Otf2SummaryTimelineStateProvider(ITmfTrace trace) {
        super(trace, Otf2SummaryTimelineAnalysis.getFullAnalysisId());
    }

    public int getVersion() {
        return VERSION_NUMBER;
    }

    @Override
    protected void processGlobalDefinition(ITmfEvent event, String name) {
        switch (name) {
            case "String": {
                this.processStringDefinition(event);
                break;
            }
            case "Region": {
                this.processRegionDefinition(event);
                break;
            }
            case "Location": {
                ITmfEventField content = event.getContent();
                Long locationReference = (Long)content.getFieldValue(Long.class, new String[]{"self"});
                Integer locationType = (Integer)content.getFieldValue(Integer.class, new String[]{"locationType"});
                if (locationReference == null || locationType == null || locationType != 1) {
                    return;
                }
                this.fMapLocation.put(locationReference, new Location());
                ++this.fNumberOfLocations;
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    protected void processOtf2Event(ITmfEvent event, String name, ITmfStateSystemBuilder ssb) {
        Long locationId = Otf2SummaryTimelineStateProvider.getLocationId(event);
        Location location = this.fMapLocation.get(locationId);
        if (location == null) {
            return;
        }
        switch (name) {
            case "Enter": {
                location.enter(event, ssb);
                break;
            }
            case "Leave": {
                location.leave(event, ssb);
                break;
            }
        }
    }

    private class Location {
        private final Stack<Integer> fStatusQuarkStack = new Stack();

        public void enter(ITmfEvent event, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = event.getContent();
            Integer regionId = (Integer)content.getFieldValue(Integer.class, new String[]{"region"});
            if (regionId == null) {
                return;
            }
            long timestamp = event.getTimestamp().toNanos();
            String regionName = Otf2SummaryTimelineStateProvider.this.getRegionNameFromRegionId(regionId);
            int newTypeQuark = Otf2SummaryTimelineStateProvider.getQuarkFromRegion(regionName, ssb);
            if (!this.fStatusQuarkStack.empty()) {
                Integer currentQuark = this.fStatusQuarkStack.peek();
                this.incrementConcernedQuarks(ssb, timestamp, currentQuark, -1.0 / (double)Otf2SummaryTimelineStateProvider.this.fNumberOfLocations);
            }
            this.incrementConcernedQuarks(ssb, timestamp, newTypeQuark, 1.0 / (double)Otf2SummaryTimelineStateProvider.this.fNumberOfLocations);
            this.fStatusQuarkStack.push(newTypeQuark);
        }

        public void leave(ITmfEvent event, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = event.getContent();
            Integer regionId = (Integer)content.getFieldValue(Integer.class, new String[]{"region"});
            if (regionId == null) {
                return;
            }
            long timestamp = event.getTimestamp().toNanos();
            Integer currentTypeQuark = this.fStatusQuarkStack.pop();
            this.incrementConcernedQuarks(ssb, timestamp, currentTypeQuark, -1.0 / (double)Otf2SummaryTimelineStateProvider.this.fNumberOfLocations);
            if (!this.fStatusQuarkStack.empty()) {
                Integer newTypeQuark = this.fStatusQuarkStack.peek();
                this.incrementConcernedQuarks(ssb, timestamp, newTypeQuark, 1.0 / (double)Otf2SummaryTimelineStateProvider.this.fNumberOfLocations);
            }
        }

        private void incrementConcernedQuarks(ITmfStateSystemBuilder ssb, long timestamp, int quark, double increment) {
            StateSystemBuilderUtils.incrementAttributeDouble((ITmfStateSystemBuilder)ssb, (long)timestamp, (int)quark, (double)increment);
            int parentQuark = ssb.getParentAttributeQuark(quark);
            if (parentQuark != -1) {
                int totalQuark = ssb.getQuarkRelativeAndAdd(parentQuark, new String[]{Otf2SummaryTimelineStateProvider.TOTAL});
                StateSystemBuilderUtils.incrementAttributeDouble((ITmfStateSystemBuilder)ssb, (long)timestamp, (int)totalQuark, (double)increment);
            }
        }
    }
}

