/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.closure;

import com.google.javascript.jscomp.parsing.parser.Parser;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.util.ErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.ClosureCompilerASTConverter;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.internal.compiler.closure.LineNumberComputer;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblem;

public class ClosureCompiler {
    private String rawContent;
    private IJavaScriptUnit unit;
    private boolean commentsEnabled;

    private ClosureCompiler() {
    }

    public static ClosureCompiler newInstance() {
        return new ClosureCompiler();
    }

    public ClosureCompiler setSource(String content) {
        this.unit = null;
        this.rawContent = content;
        return this;
    }

    public ClosureCompiler setSource(IJavaScriptUnit content) {
        this.rawContent = null;
        this.unit = content;
        return this;
    }

    public ClosureCompiler toggleComments(boolean enabled) {
        this.commentsEnabled = enabled;
        return this;
    }

    public JavaScriptUnit parse() {
        Parser.Config config = new Parser.Config(Parser.Config.Mode.ES6);
        SourceFile source = this.getSourceFile();
        ErrorCollector errorCollector = new ErrorCollector(source.name);
        Parser parser = new Parser(config, (ErrorReporter)errorCollector, source);
        ProgramTree tree = parser.parseProgram();
        AST ast = AST.newAST(3);
        ast.setDefaultNodeFlag(2);
        ClosureCompilerASTConverter transformer = new ClosureCompilerASTConverter(ast, parser.getComments());
        JavaScriptUnit $ = (JavaScriptUnit)transformer.transform(null, (ParseTree)tree);
        $.setLineEndTable(LineNumberComputer.computeLineTable(source.contents));
        $.setProblems(errorCollector.problems());
        if (this.commentsEnabled) {
            $.setCommentTable(this.buildComments(parser.getComments(), ast));
        }
        ast.setDefaultNodeFlag(0);
        return $;
    }

    private org.eclipse.wst.jsdt.core.dom.Comment[] buildComments(List<Comment> comments, AST ast) {
        ArrayList<org.eclipse.wst.jsdt.core.dom.Comment> domComments = new ArrayList<org.eclipse.wst.jsdt.core.dom.Comment>();
        for (Comment comment : comments) {
            switch (comment.type) {
                case BLOCK: {
                    BlockComment bc = ast.newBlockComment();
                    this.setSourceRange(bc, comment);
                    domComments.add(bc);
                    break;
                }
                case LINE: 
                case SHEBANG: {
                    LineComment lc = ast.newLineComment();
                    this.setSourceRange(lc, comment);
                    domComments.add(lc);
                    break;
                }
                case JSDOC: {
                    JSdoc jd = ast.newJSdoc();
                    jd.setComment(comment.value);
                    this.setSourceRange(jd, comment);
                    domComments.add(jd);
                }
            }
        }
        return domComments.toArray(new org.eclipse.wst.jsdt.core.dom.Comment[domComments.size()]);
    }

    private void setSourceRange(ASTNode node, Comment comment) {
        node.setSourceRange(comment.location.start.offset, comment.location.end.offset - comment.location.start.offset);
    }

    private SourceFile getSourceFile() {
        String content = this.rawContent;
        String filename = "";
        if (this.unit != null) {
            try {
                content = this.unit.getSource();
                filename = this.unit.getDisplayName();
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        }
        return new SourceFile(filename, content);
    }

    private static class ErrorCollector
    extends ErrorReporter {
        private final String fileName;
        private final List<IProblem> problems = new ArrayList<IProblem>();

        public ErrorCollector(String file) {
            this.fileName = file;
        }

        protected void reportError(SourcePosition location, String message) {
            this.addProblem(message, location, 1);
        }

        protected void reportWarning(SourcePosition location, String message) {
            this.addProblem(message, location, 0);
        }

        IProblem[] problems() {
            return this.problems.toArray(new DefaultProblem[this.problems.size()]);
        }

        private void addProblem(String description, SourcePosition location, int severity) {
            DefaultProblem result = new DefaultProblem(this.fileName.toCharArray(), description, 0, null, severity, location.offset, -1, location.line, location.column);
            this.problems.add(result);
        }
    }
}

