/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.communicators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.AbstractOtf2StateProvider;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.communicators.Otf2CommunicatorsAnalysis;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.CollectiveOperationIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.MessageIdentifiers;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2CommunicatorsStateProvider
extends AbstractOtf2StateProvider {
    private static final String COMMUNICATOR = "Communicator ";
    private static final String RANK = "Rank ";
    private static int VERSION_NUMBER = 1;
    private final Map<Long, Location> fMapLocation = new HashMap<Long, Location>();
    private final Map<Integer, Communicator> fMapCommunicator = new HashMap<Integer, Communicator>();
    private final long fLastTimestamp;

    public Otf2CommunicatorsStateProvider(ITmfTrace trace) {
        super(trace, Otf2CommunicatorsAnalysis.getFullAnalysisId());
        this.fLastTimestamp = trace.readEnd().toNanos();
    }

    public int getVersion() {
        return VERSION_NUMBER;
    }

    @Override
    protected void eventHandle(ITmfEvent event) {
        super.eventHandle(event);
        if (this.isLastEvent(event)) {
            ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
            if (ssb == null) {
                return;
            }
            this.processCommunicatorsAttributes(ssb);
        }
    }

    @Override
    protected void processGlobalDefinition(ITmfEvent event, String name) {
        switch (name) {
            case "String": {
                this.processStringDefinition(event);
                break;
            }
            case "Region": {
                this.processRegionDefinition(event);
                break;
            }
            case "Location": {
                ITmfEventField content = event.getContent();
                Long locationReference = (Long)content.getFieldValue(Long.class, new String[]{"locationRef"});
                if (locationReference == null) {
                    return;
                }
                this.fMapLocation.put(locationReference, new Location(locationReference));
                break;
            }
            case "Comm": {
                this.processCommunicatorDefinition(event);
                ITmfEventField content = event.getContent();
                Integer communicatorReference = (Integer)content.getFieldValue(Integer.class, new String[]{"commRef"});
                if (communicatorReference == null) {
                    return;
                }
                this.fMapCommunicator.put(communicatorReference, new Communicator(communicatorReference));
                break;
            }
            case "Group": {
                this.processGroupDefinition(event);
                break;
            }
            case "GroupMember": {
                this.processGroupMemberDefinition(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    protected void processOtf2Event(ITmfEvent event, String name, ITmfStateSystemBuilder ssb) {
        Long locationId = Otf2CommunicatorsStateProvider.getLocationId(event);
        Location location = this.fMapLocation.get(locationId);
        if (location == null) {
            return;
        }
        switch (name) {
            case "Enter": {
                location.enter(event);
                break;
            }
            case "Leave": {
                if (!location.fInCommunication) break;
                location.leaveMpiCommunication(event, ssb);
                break;
            }
            case "MpiRecv": 
            case "MpiSend": 
            case "MpiCollectiveEnd": 
            case "MpiIrecv": 
            case "MpiIsend": {
                ITmfEventField content = event.getContent();
                Integer communicatorId = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
                Communicator communicator = this.fMapCommunicator.get(communicatorId);
                if (communicator == null) {
                    return;
                }
                location.fInCommunication = true;
                Otf2CommunicatorsStateProvider.processMpiCommunication(event, ssb, name, location, communicator);
                break;
            }
        }
    }

    private boolean isLastEvent(ITmfEvent event) {
        return this.fLastTimestamp == event.getTimestamp().toNanos();
    }

    private void processCommunicatorsAttributes(ITmfStateSystemBuilder ssb) {
        for (Map.Entry<Integer, Communicator> communicatorEntry : this.fMapCommunicator.entrySet()) {
            Communicator communicator = communicatorEntry.getValue();
            communicator.updatePendingLocations(ssb);
        }
    }

    private static void processMpiCommunication(ITmfEvent event, ITmfStateSystemBuilder ssb, String name, Location location, Communicator communicator) {
        if (!communicator.isInitialized()) {
            communicator.initialize(ssb);
        }
        switch (name) {
            case "MpiSend": 
            case "MpiIsend": {
                location.mpiSend(event, communicator);
                break;
            }
            case "MpiRecv": {
                location.mpiRecv(event, communicator, true);
                break;
            }
            case "MpiIrecv": {
                location.mpiRecv(event, communicator, false);
                break;
            }
            case "MpiCollectiveEnd": {
                location.mpiCollective(event, communicator);
                break;
            }
        }
    }

    private class Communicator {
        protected final int fId;
        protected boolean fQuarkInitialized;
        protected int fQuark;
        protected List<Long> fLocations;
        protected final List<CollectiveOperationIdentifiers> fCollectiveOperations;
        protected final SortedMap<Long, Long> fTimestampsPendingThreads;

        public Communicator(int id) {
            this.fId = id;
            this.fQuarkInitialized = false;
            this.fLocations = new ArrayList<Long>();
            this.fCollectiveOperations = new ArrayList<CollectiveOperationIdentifiers>();
            this.fQuark = -1;
            this.fTimestampsPendingThreads = new TreeMap<Long, Long>();
        }

        public boolean isInitialized() {
            return this.fQuarkInitialized;
        }

        public void initialize(ITmfStateSystemBuilder ssb) {
            ArrayList locations = Otf2CommunicatorsStateProvider.this.getMembersFromCommunicatorReference(this.fId);
            this.fQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{Otf2CommunicatorsStateProvider.COMMUNICATOR + String.valueOf(this.fId)});
            this.fLocations = locations;
            int i = 0;
            while (i < this.fLocations.size()) {
                ssb.getQuarkRelativeAndAdd(this.fQuark, new String[]{Otf2CommunicatorsStateProvider.RANK + String.valueOf(i)});
                ++i;
            }
            this.fQuarkInitialized = true;
        }

        public void updatePendingLocations(ITmfStateSystemBuilder ssb) {
            if (this.isInitialized()) {
                Long pendingThreads = 0L;
                for (Map.Entry<Long, Long> entry : this.fTimestampsPendingThreads.entrySet()) {
                    Long timestamp = entry.getKey();
                    Long value = entry.getValue();
                    pendingThreads = pendingThreads + value;
                    ssb.modifyAttribute(timestamp.longValue(), (Object)pendingThreads, this.fQuark);
                }
                this.fTimestampsPendingThreads.clear();
            }
        }
    }

    private class Location {
        private final long fId;
        private Communicator fCurrentCommunicator;
        private String fLatestEnteredRegion;
        private long fLatestEnteredTimestamp;
        private boolean fInCommunication;
        private int fRank;
        private final List<MessageIdentifiers> fSentMessages;
        private final Map<Long, Long> fRequestIdBeginTimestamp;

        public Location(long id) {
            this.fId = id;
            this.fCurrentCommunicator = new Communicator(-1);
            this.fLatestEnteredRegion = "UNKNOWN";
            this.fLatestEnteredTimestamp = 0L;
            this.fInCommunication = false;
            this.fRank = -1;
            this.fSentMessages = new ArrayList<MessageIdentifiers>();
            this.fRequestIdBeginTimestamp = new HashMap<Long, Long>();
        }

        public void enter(ITmfEvent event) {
            String regionName;
            ITmfEventField content = event.getContent();
            this.fLatestEnteredTimestamp = event.getTimestamp().toNanos();
            Integer regionId = (Integer)content.getFieldValue(Integer.class, new String[]{"regionRef"});
            if (regionId == null) {
                return;
            }
            this.fLatestEnteredRegion = regionName = Otf2CommunicatorsStateProvider.this.getRegionNameFromRegionId(regionId);
        }

        public void leaveMpiCommunication(ITmfEvent event, ITmfStateSystemBuilder ssb) {
            int communicatorQuark = this.fCurrentCommunicator.fQuark;
            int associatedLocationQuark = ssb.getQuarkRelativeAndAdd(communicatorQuark, new String[]{Otf2CommunicatorsStateProvider.RANK + String.valueOf(this.fRank)});
            ssb.modifyAttribute(this.fLatestEnteredTimestamp, (Object)this.fLatestEnteredRegion, associatedLocationQuark);
            ssb.modifyAttribute(event.getTimestamp().toNanos(), null, associatedLocationQuark);
            this.fInCommunication = false;
        }

        public void mpiSend(ITmfEvent srcEvent, Communicator communicator) {
            ITmfEventField content = srcEvent.getContent();
            Integer srcRank = Otf2CommunicatorsStateProvider.this.getRank(this.fId, communicator.fId);
            Integer destRank = (Integer)content.getFieldValue(Integer.class, new String[]{"receiver"});
            Integer messageTag = (Integer)content.getFieldValue(Integer.class, new String[]{"msgTag"});
            if (destRank == null || messageTag == null || srcRank == -1) {
                return;
            }
            this.fSentMessages.add(new MessageIdentifiers(communicator.fId, srcRank, destRank, messageTag, srcEvent.getTimestamp().toNanos()));
            this.fCurrentCommunicator = communicator;
            this.fRank = srcRank;
        }

        public void mpiRecv(ITmfEvent srcEvent, Communicator communicator, boolean isBlocking) {
            ITmfEventField content = srcEvent.getContent();
            Integer destRank = Otf2CommunicatorsStateProvider.this.getRank(this.fId, communicator.fId);
            Integer srcRank = (Integer)content.getFieldValue(Integer.class, new String[]{"sender"});
            Integer messageTag = (Integer)content.getFieldValue(Integer.class, new String[]{"msgTag"});
            if (srcRank == null || messageTag == null || destRank == -1) {
                return;
            }
            Location srcLocation = Otf2CommunicatorsStateProvider.this.fMapLocation.get(communicator.fLocations.get(srcRank));
            if (srcLocation == null) {
                return;
            }
            MessageIdentifiers message = new MessageIdentifiers(communicator.fId, srcRank, destRank, messageTag);
            int messageIndex = srcLocation.fSentMessages.indexOf(message);
            MessageIdentifiers sentMessage = srcLocation.fSentMessages.remove(messageIndex);
            Long recvBeginTimestamp = this.fLatestEnteredTimestamp;
            if (!isBlocking) {
                Long requestId = (Long)content.getFieldValue(Long.class, new String[]{"requestID"});
                if (requestId == null) {
                    return;
                }
                Long requestBeginTimestamp = this.fRequestIdBeginTimestamp.get(requestId);
                if (requestBeginTimestamp == null) {
                    return;
                }
                recvBeginTimestamp = requestBeginTimestamp;
            }
            Long beginCommunicatorUseTimestamp = Math.min(recvBeginTimestamp, sentMessage.getBeginTimestamp());
            communicator.fTimestampsPendingThreads.put(beginCommunicatorUseTimestamp, 2L);
            communicator.fTimestampsPendingThreads.put(sentMessage.getBeginTimestamp(), -1L);
            communicator.fTimestampsPendingThreads.put(srcEvent.getTimestamp().toNanos(), -1L);
            this.fCurrentCommunicator = communicator;
            this.fRank = destRank;
        }

        private void mpiCollective(ITmfEvent event, Communicator communicator) {
            CollectiveOperationIdentifiers collectiveOperation2;
            ITmfEventField content = event.getContent();
            Integer operationCode = (Integer)content.getFieldValue(Integer.class, new String[]{"collectiveOp"});
            if (operationCode == null) {
                return;
            }
            Integer root = (Integer)content.getFieldValue(Integer.class, new String[]{"root"});
            if (root == null) {
                return;
            }
            this.fCurrentCommunicator = communicator;
            this.fRank = Otf2CommunicatorsStateProvider.this.getRank(this.fId, communicator.fId);
            for (CollectiveOperationIdentifiers collectiveOperation2 : communicator.fCollectiveOperations) {
                if (!collectiveOperation2.isAssociatedOperation(operationCode, root, this.fId)) continue;
                collectiveOperation2.locationCalledOperation(this.fId, this.fLatestEnteredTimestamp);
                communicator.fTimestampsPendingThreads.put(event.getTimestamp().toNanos(), -1L);
                if (collectiveOperation2.isOperationDone()) {
                    communicator.fTimestampsPendingThreads.put(Collections.min(collectiveOperation2.getEnterTimestamps()), Long.valueOf(communicator.fLocations.size()));
                    communicator.fCollectiveOperations.remove(collectiveOperation2);
                }
                return;
            }
            collectiveOperation2 = new CollectiveOperationIdentifiers(operationCode, root, new ArrayList<Long>(communicator.fLocations));
            communicator.fCollectiveOperations.add(collectiveOperation2);
            collectiveOperation2.locationCalledOperation(this.fId, this.fLatestEnteredTimestamp);
            communicator.fTimestampsPendingThreads.put(event.getTimestamp().toNanos(), -1L);
            if (collectiveOperation2.isOperationDone()) {
                communicator.fTimestampsPendingThreads.put(Collections.min(collectiveOperation2.getEnterTimestamps()), Long.valueOf(communicator.fLocations.size()));
                communicator.fCollectiveOperations.remove(collectiveOperation2);
            }
        }
    }
}

