/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.ease.debugging.model.EaseDebugElement;
import org.eclipse.ease.debugging.model.EaseDebugValue;

public class EaseWatchExpressionResult
implements IWatchExpressionResult {
    private final String fExpression;
    private final Object fResult;
    private final Throwable fException;
    private final EaseDebugElement fDebugElement;

    public EaseWatchExpressionResult(String expression, Object result, Throwable exception, EaseDebugElement debugElement) {
        this.fExpression = expression;
        this.fResult = result;
        this.fException = exception;
        this.fDebugElement = debugElement;
    }

    public IValue getValue() {
        return new EaseDebugValue((IDebugElement)this.fDebugElement, this.fResult);
    }

    public boolean hasErrors() {
        return this.fException != null;
    }

    public String[] getErrorMessages() {
        if (this.hasErrors()) {
            return new String[]{this.fException.getMessage() != null ? this.fException.getMessage() : this.fException.getClass().getName()};
        }
        return new String[0];
    }

    public String getExpressionText() {
        return this.fExpression;
    }

    public DebugException getException() {
        return new DebugException((IStatus)new Status(4, "org.eclipse.ease", "Error during wtch expression evaluation", this.fException));
    }
}

