/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.keywords;

import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class ScriptedView {
    public static final String SCRIPT_VARIABLE_VIEW = "view";
    public static final String SCRIPT_VARIABLE_COMPOSITE = "viewComposite";
    private Composite fParent;
    private IScriptEngine fScriptEngine;

    @Inject
    public ScriptedView(final MPart part) {
        IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
        IScript script = repositoryService.getScript((String)part.getProperties().get("script"));
        this.createPartControl((Composite)part.getWidget(), script);
        final EPartService partService = (EPartService)PlatformUI.getWorkbench().getService(EPartService.class);
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                partService.hidePart(part, true);
                ScriptedView.this.fScriptEngine.terminate();
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }

    public void createPartControl(Composite parent, IScript script) {
        this.fParent = parent;
        HashMap<String, ScriptedView> parameters = new HashMap<String, ScriptedView>();
        parameters.put(SCRIPT_VARIABLE_VIEW, this);
        parameters.put(SCRIPT_VARIABLE_COMPOSITE, (ScriptedView)parent);
        this.fScriptEngine = script.run(parameters);
        parent.addDisposeListener(e -> this.fScriptEngine.terminate());
    }

    public Composite getComposite() {
        return this.fParent;
    }
}

