/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.IPathRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Member;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.wst.jsdt.internal.core.search.PatternSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.SubTypeSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.util.HandleFactory;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class IndexBasedHierarchyBuilder
extends HierarchyBuilder
implements SuffixConstants {
    public static final int MAXTICKS = 800;
    protected Map cuToHandle = new HashMap(5);
    protected IJavaScriptSearchScope scope;

    public IndexBasedHierarchyBuilder(TypeHierarchy hierarchy, IJavaScriptSearchScope scope) throws JavaScriptModelException {
        super(hierarchy);
        this.scope = scope;
    }

    @Override
    public void build(boolean computeSubtypes) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles();
            if (computeSubtypes) {
                IType focusType = this.getType();
                boolean focusIsObject = focusType.getElementName().equals(new String(IIndexConstants.OBJECT));
                int amountOfWorkForSubtypes = focusIsObject ? 5 : 80;
                SubProgressMonitor possibleSubtypesMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, amountOfWorkForSubtypes);
                String[] allPossibleSubtypesPaths = ((Member)((Object)focusType)).getOuterMostLocalContext() == null ? this.determinePossibleSubTypesFilePaths((IProgressMonitor)possibleSubtypesMonitor) : CharOperation.NO_STRINGS;
                if (allPossibleSubtypesPaths != null) {
                    SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 100 - amountOfWorkForSubtypes);
                    this.hierarchy.initialize(allPossibleSubtypesPaths.length);
                    this.buildFromPotentialSubtypeFilepaths(allPossibleSubtypesPaths, new HashSet(10), (IProgressMonitor)buildMonitor);
                }
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
        }
        finally {
            manager.flushZipFiles();
        }
    }

    private void buildForProject(JavaProject project, ArrayList potentialSubtypes, IJavaScriptUnit[] workingCopies, HashSet localTypes, IProgressMonitor monitor) throws JavaScriptModelException {
        int openablesLength = potentialSubtypes.size();
        if (openablesLength > 0) {
            Openable[] openables = new Openable[openablesLength];
            potentialSubtypes.toArray(openables);
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int rootsLength = roots.length;
            final HashtableOfObjectToInt indexes = new HashtableOfObjectToInt(openablesLength);
            int i = 0;
            while (i < openablesLength) {
                IJavaScriptElement root = openables[i].getAncestor(3);
                int index = 0;
                while (index < rootsLength) {
                    if (roots[index].equals(root)) break;
                    ++index;
                }
                indexes.put(openables[i], index);
                ++i;
            }
            Arrays.sort(openables, new Comparator(){

                public int compare(Object a, Object b) {
                    int bIndex;
                    int aIndex = indexes.get(a);
                    if (aIndex != (bIndex = indexes.get(b))) {
                        return aIndex - bIndex;
                    }
                    return ((Openable)b).getElementName().compareTo(((Openable)a).getElementName());
                }
            });
            IType focusType = this.getType();
            boolean inProjectOfFocusType = focusType != null && focusType.getJavaScriptProject().equals(project);
            IJavaScriptUnit[] unitsToLookInside = null;
            if (inProjectOfFocusType) {
                IJavaScriptUnit unitToLookInside = focusType.getJavaScriptUnit();
                if (unitToLookInside != null) {
                    int wcLength;
                    int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
                    if (wcLength == 0) {
                        unitsToLookInside = new IJavaScriptUnit[]{unitToLookInside};
                    } else {
                        unitsToLookInside = new IJavaScriptUnit[wcLength + 1];
                        unitsToLookInside[0] = unitToLookInside;
                        System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
                    }
                } else {
                    unitsToLookInside = workingCopies;
                }
            }
            SearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(unitsToLookInside);
            this.nameLookup = searchableEnvironment.nameLookup;
            Map options = project.getOptions(true);
            options.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "");
            this.hierarchyResolver = new HierarchyResolver(searchableEnvironment, options, this, new DefaultProblemFactory());
            if (focusType != null) {
                Member declaringMember = ((Member)((Object)focusType)).getOuterMostLocalContext();
                if (declaringMember == null) {
                    String[] packageName;
                    char[] typeQualifiedName;
                    if (!inProjectOfFocusType && searchableEnvironment.findType(typeQualifiedName = focusType.getTypeQualifiedName('.').toCharArray(), Util.toCharArrays(packageName = ((PackageFragment)focusType.getPackageFragment()).names), this.hierarchyResolver) == null) {
                        return;
                    }
                } else {
                    Openable openable = declaringMember.isBinary() ? (Openable)((Object)declaringMember.getClassFile()) : (Openable)((Object)declaringMember.getJavaScriptUnit());
                    localTypes = new HashSet<String>();
                    localTypes.add(openable.getPath().toString());
                    this.hierarchyResolver.resolve(new Openable[]{openable}, localTypes, monitor);
                    return;
                }
            }
            this.hierarchyResolver.resolve(openables, localTypes, monitor);
        }
    }

    private void buildFromPotentialSubtypeFilepaths(String[] allPotentialSubTypeFilePaths, HashSet localTypes, IProgressMonitor monitor) {
        int wcLength;
        IType focusType = this.getType();
        HashMap<String, IJavaScriptUnit> wcPaths = new HashMap<String, IJavaScriptUnit>();
        IJavaScriptUnit[] workingCopies = this.hierarchy.workingCopies;
        if (workingCopies != null && (wcLength = workingCopies.length) > 0) {
            String[] newPaths = new String[wcLength];
            int i = 0;
            while (i < wcLength) {
                IJavaScriptUnit workingCopy = workingCopies[i];
                String path = workingCopy.getPath().toString();
                wcPaths.put(path, workingCopy);
                newPaths[i] = path;
                ++i;
            }
            int potentialSubtypesLength = allPotentialSubTypeFilePaths.length;
            String[] stringArray = allPotentialSubTypeFilePaths;
            allPotentialSubTypeFilePaths = new String[potentialSubtypesLength + wcLength];
            System.arraycopy(stringArray, 0, allPotentialSubTypeFilePaths, 0, potentialSubtypesLength);
            System.arraycopy(newPaths, 0, allPotentialSubTypeFilePaths, potentialSubtypesLength, wcLength);
        }
        int length = allPotentialSubTypeFilePaths.length;
        Openable focusCU = (Openable)((Object)focusType.getJavaScriptUnit());
        String focusPath = null;
        if (focusCU != null) {
            focusPath = focusCU.getPath().toString();
            if (length > 0) {
                String[] stringArray = allPotentialSubTypeFilePaths;
                allPotentialSubTypeFilePaths = new String[length + 1];
                System.arraycopy(stringArray, 0, allPotentialSubTypeFilePaths, 0, length);
                allPotentialSubTypeFilePaths[length] = focusPath;
            } else {
                allPotentialSubTypeFilePaths = new String[]{focusPath};
            }
            ++length;
        }
        Arrays.sort(allPotentialSubTypeFilePaths);
        ArrayList<IOpenable> potentialSubtypes = new ArrayList<IOpenable>();
        try {
            HandleFactory factory = new HandleFactory();
            IJavaScriptProject currentProject = null;
            if (monitor != null) {
                monitor.beginTask("", length * 2);
            }
            int i = 0;
            while (i < length) {
                block25: {
                    try {
                        Openable handle;
                        String resourcePath = allPotentialSubTypeFilePaths[i];
                        if (i > 0 && resourcePath.equals(allPotentialSubTypeFilePaths[i - 1])) break block25;
                        IJavaScriptUnit workingCopy = (IJavaScriptUnit)wcPaths.get(resourcePath);
                        if (workingCopy != null) {
                            handle = (Openable)((Object)workingCopy);
                        } else {
                            Openable openable = handle = resourcePath.equals(focusPath) ? focusCU : factory.createOpenable(resourcePath, this.scope);
                            if (handle == null) break block25;
                        }
                        IJavaScriptProject project = handle.getJavaScriptProject();
                        if (currentProject == null) {
                            currentProject = project;
                            potentialSubtypes = new ArrayList(5);
                        } else if (!currentProject.equals(project)) {
                            this.buildForProject((JavaProject)currentProject, potentialSubtypes, workingCopies, localTypes, monitor);
                            currentProject = project;
                            potentialSubtypes = new ArrayList(5);
                        }
                        potentialSubtypes.add(handle);
                    }
                    catch (JavaScriptModelException javaScriptModelException) {}
                }
                ++i;
            }
            try {
                if (currentProject == null) {
                    currentProject = focusType.getJavaScriptProject();
                    if (focusType.isBinary()) {
                        potentialSubtypes.add(focusType.getClassFile());
                    } else {
                        potentialSubtypes.add(focusType.getJavaScriptUnit());
                    }
                }
                this.buildForProject((JavaProject)currentProject, potentialSubtypes, workingCopies, localTypes, monitor);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            if (!this.hierarchy.contains(focusType)) {
                this.hierarchy.addRootClass(focusType);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    protected ICompilationUnit createCompilationUnitFromPath(Openable handle, IFile file) {
        ICompilationUnit unit = super.createCompilationUnitFromPath(handle, file);
        this.cuToHandle.put(unit, handle);
        return unit;
    }

    private String[] determinePossibleSubTypesFilePaths(IProgressMonitor monitor) {
        final HashSet paths = new HashSet(10);
        IPathRequestor collector = new IPathRequestor(){

            @Override
            public void acceptPath(String path, boolean containsLocalTypes) {
                paths.add(path);
            }
        };
        try {
            if (monitor != null) {
                monitor.beginTask("", 800);
            }
            IndexBasedHierarchyBuilder.searchAllPossibleSubTypes(this.getType(), this.scope, collector, 3, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        int length = paths.size();
        String[] result = new String[length];
        int count = 0;
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            result[count++] = (String)iter.next();
        }
        return result;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void searchAllPossibleSubTypes(IType type, IJavaScriptSearchScope scope, final IPathRequestor pathRequestor, int waitingPolicy, IProgressMonitor progressMonitor) {
        Object monitor = progressMonitor == null ? new NullProgressMonitor() : progressMonitor;
        final Queue parentTypeNames = new Queue();
        final HashtableOfObject foundSuperNames = new HashtableOfObject(5);
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        IndexQueryRequestor subTypeSearchRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                SuperTypeReferencePattern record = (SuperTypeReferencePattern)indexRecord;
                pathRequestor.acceptPath(documentPath, false);
                char[] typeName = record.typeName;
                if (!foundSuperNames.containsKey(typeName)) {
                    foundSuperNames.put(typeName, typeName);
                    parentTypeNames.add(typeName);
                }
                return true;
            }
        };
        SuperTypeReferencePattern superTypeRefPattern = new SuperTypeReferencePattern(null, 8);
        superTypeRefPattern.setFocus(type);
        JavaSearchParticipant participant = new JavaSearchParticipant();
        SubTypeSearchJob subTypeSearchJob = new SubTypeSearchJob(superTypeRefPattern, participant, scope, subTypeSearchRequestor);
        parentTypeNames.add(type.getElementName().toCharArray());
        NullProgressMonitor cancelMonitor = new NullProgressMonitor((IProgressMonitor)monitor){
            private final /* synthetic */ IProgressMonitor val$monitor;
            {
                this.val$monitor = iProgressMonitor;
            }

            public void setCanceled(boolean value) {
                this.val$monitor.setCanceled(value);
            }

            public boolean isCanceled() {
                return this.val$monitor.isCanceled();
            }
        };
        try {
            block9: {
                int ticks;
                block8: {
                    ticks = 0;
                    if (!true) break block8;
                    if (parentTypeNames.start > parentTypeNames.end) return;
                    if (monitor.isCanceled()) break block9;
                }
                do {
                    char[] currentTypeName;
                    if (CharOperation.equals(currentTypeName = parentTypeNames.retrieve(), IIndexConstants.OBJECT)) {
                        currentTypeName = null;
                    }
                    if (currentTypeName == null) return;
                    char[][] synonyms = SearchEngine.getAllSynonyms(currentTypeName, scope, waitingPolicy, progressMonitor);
                    int i = 0;
                    while (i < synonyms.length) {
                        char[] synonym = synonyms[i];
                        indexManager.performConcurrentJob(new PatternSearchJob(new TypeDeclarationPattern(synonym, 0), participant, scope, new IndexQueryRequestor(){

                            @Override
                            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                                pathRequestor.acceptPath(documentPath, false);
                                return true;
                            }
                        }), waitingPolicy, (IProgressMonitor)cancelMonitor);
                        superTypeRefPattern.superTypeName = synonym;
                        indexManager.performConcurrentJob(subTypeSearchJob, waitingPolicy, (IProgressMonitor)cancelMonitor);
                        if (++ticks <= 800) {
                            monitor.worked(1);
                        }
                        ++i;
                    }
                    if (parentTypeNames.start > parentTypeNames.end) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            subTypeSearchJob.finished();
        }
    }

    public static ArrayList findAllSuperTypes(char[] typeName, IJavaScriptSearchScope scope) {
        final ArrayList superTypes = new ArrayList();
        final ArrayList<char[]> queue = new ArrayList<char[]>();
        ArrayList<char[]> alreadySearched = new ArrayList<char[]>();
        try {
            queue.add(CharOperation.toLowerCase(typeName));
            IProgressMonitor progressMonitor = new IProgressMonitor(){
                boolean isCanceled = false;

                public void beginTask(String name, int totalWork) {
                }

                public void done() {
                }

                public void internalWorked(double work) {
                }

                public boolean isCanceled() {
                    return this.isCanceled;
                }

                public void setCanceled(boolean value) {
                    this.isCanceled = value;
                }

                public void setTaskName(String name) {
                }

                public void subTask(String name) {
                }

                public void worked(int work) {
                }
            };
            IRestrictedAccessTypeRequestor typeRequestor = new IRestrictedAccessTypeRequestor(){

                @Override
                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] superTypeNames, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                    boolean doAdd = true;
                    int i = 0;
                    while (i < superTypes.size()) {
                        if (CharOperation.equals(superTypeNames[0], (char[])superTypes.get(i))) {
                            doAdd = false;
                            break;
                        }
                        ++i;
                    }
                    if (doAdd) {
                        superTypes.add(superTypeNames[0]);
                    }
                    queue.add(superTypeNames[0]);
                }
            };
            try {
                while (!queue.isEmpty()) {
                    char[] nextSearch = (char[])queue.get(0);
                    boolean doSearch = true;
                    if (CharOperation.equals(nextSearch, IIndexConstants.OBJECT)) {
                        doSearch = false;
                    }
                    int i = 0;
                    while (doSearch && i < alreadySearched.size()) {
                        if (CharOperation.equals(nextSearch, (char[])alreadySearched.get(i))) {
                            doSearch = false;
                        }
                        ++i;
                    }
                    if (doSearch) {
                        alreadySearched.add(nextSearch);
                        new BasicSearchEngine().searchAllTypeNames(CharOperation.NO_CHAR, nextSearch, 0, scope, typeRequestor, 3, progressMonitor);
                    }
                    queue.remove(0);
                    doSearch = true;
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return superTypes;
    }

    static class Queue {
        public char[][] names = new char[10][];
        public int start = 0;
        public int end = -1;

        Queue() {
        }

        public void add(char[] name) {
            if (++this.end == this.names.length) {
                this.end -= this.start;
                char[][] cArrayArray = new char[this.end * 2][];
                this.names = cArrayArray;
                System.arraycopy(this.names, this.start, cArrayArray, 0, this.end);
                this.start = 0;
            }
            this.names[this.end] = name;
        }

        public char[] retrieve() {
            if (this.start > this.end) {
                return null;
            }
            char[] name = this.names[this.start++];
            if (this.start > this.end) {
                this.start = 0;
                this.end = -1;
            }
            return name;
        }

        public boolean contains(char[] needle) {
            boolean contains = false;
            if (this.start <= this.end) {
                int i = this.start;
                while (i <= this.end && !contains) {
                    contains = CharOperation.equals(needle, this.names[i]);
                    ++i;
                }
            }
            return contains;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("Queue:\n");
            int i = this.start;
            while (i <= this.end) {
                buffer.append(this.names[i]).append('\n');
                ++i;
            }
            return buffer.toString();
        }
    }
}

