/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.RequestIntervalSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class IOStateSystemSegmentStore
implements ISegmentStore<ISegment> {
    private final ReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private final ITmfStateSystem fStateSystem;
    private final Map<Integer, Disk> fSegmentQuarks;
    Comparator<ITmfStateInterval> cmp = (x, y) -> {
        if (x.getStartTime() < y.getStartTime()) {
            return -1;
        }
        if (x.getEndTime() < y.getEndTime()) {
            return -1;
        }
        return 1;
    };

    public IOStateSystemSegmentStore(ITmfStateSystem ss, Map<Integer, Disk> quarkToDisk) {
        this.fStateSystem = ss;
        this.fSegmentQuarks = quarkToDisk;
    }

    public boolean add(@NonNull ISegment arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(@Nullable Collection<? extends @NonNull ISegment> arg0) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(@Nullable Object arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(@Nullable Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return false;
    }

    public Iterator<@NonNull ISegment> iterator() {
        return new SegmentIterator();
    }

    public boolean remove(@Nullable Object arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(@Nullable Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nullable Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return 0;
    }

    public Object @NonNull [] toArray() {
        throw new UnsupportedOperationException();
    }

    public <T> T @NonNull [] toArray(T @NonNull [] arg0) {
        throw new UnsupportedOperationException();
    }

    public @NonNull Iterable<@NonNull ISegment> getIntersectingElements(long position) {
        return this.getIntersectingElements(position, position);
    }

    public @NonNull Iterable<@NonNull ISegment> getIntersectingElements(long start, long end) {
        long endTime;
        long startTime = Math.max(start, this.fStateSystem.getStartTime());
        if (startTime > (endTime = Math.min(end, this.fStateSystem.getCurrentEndTime()))) {
            return Collections.emptySet();
        }
        ArrayList<@NonNull ISegment> segments = new ArrayList<ISegment>();
        try {
            for (ITmfStateInterval interval : this.fStateSystem.query2D(this.fSegmentQuarks.keySet(), startTime, endTime)) {
                RequestIntervalSegment segment = RequestIntervalSegment.create(interval, this.fSegmentQuarks.get(interval.getAttribute()));
                if (segment == null) continue;
                segments.add((ISegment)segment);
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return segments;
    }

    public void dispose() {
    }

    private class SegmentIterator
    implements Iterator<ISegment> {
        private final long fEndTime;
        private final @Nullable Iterator<ITmfStateInterval> fIterator;
        private @Nullable ISegment fSegment;

        public SegmentIterator() {
            this.fEndTime = IOStateSystemSegmentStore.this.fStateSystem.getCurrentEndTime();
            long startTime = IOStateSystemSegmentStore.this.fStateSystem.getStartTime();
            Iterator iterator = null;
            try {
                Iterable query2d = IOStateSystemSegmentStore.this.fStateSystem.query2D(IOStateSystemSegmentStore.this.fSegmentQuarks.keySet(), startTime, this.fEndTime);
                iterator = query2d.iterator();
            }
            catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
                iterator = null;
            }
            this.fIterator = iterator;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Object nextSegment;
            Iterator<ITmfStateInterval> iterator;
            block7: {
                IOStateSystemSegmentStore.this.fLock.writeLock().lock();
                try {
                    iterator = this.fIterator;
                    if (iterator == null) {
                        IOStateSystemSegmentStore.this.fLock.writeLock().unlock();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    IOStateSystemSegmentStore.this.fLock.writeLock().unlock();
                    throw throwable;
                }
                {
                    nextSegment = this.fSegment;
                    if (nextSegment == null) break block7;
                    IOStateSystemSegmentStore.this.fLock.writeLock().unlock();
                    return true;
                }
            }
            while (true) {
                if (!iterator.hasNext() || nextSegment != null) {
                    this.fSegment = nextSegment;
                }
                ITmfStateInterval next = iterator.next();
                nextSegment = RequestIntervalSegment.create(next, IOStateSystemSegmentStore.this.fSegmentQuarks.get(next.getAttribute()));
            }
            boolean bl = this.fSegment != null;
            IOStateSystemSegmentStore.this.fLock.writeLock().unlock();
            return bl;
        }

        @Override
        public @NonNull ISegment next() {
            IOStateSystemSegmentStore.this.fLock.writeLock().lock();
            try {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more segments");
                }
                ISegment segment = Objects.requireNonNull(this.fSegment, "Segment should not be null");
                this.fSegment = null;
                ISegment iSegment = segment;
                return iSegment;
            }
            finally {
                IOStateSystemSegmentStore.this.fLock.writeLock().unlock();
            }
        }
    }
}

