/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IFileDialog;
import org.eclipse.swt.internal.ole.win32.IShellItem;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    String directoryPath;

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        this.directoryPath = null;
        long[] ppv = new long[1];
        if (COM.CoCreateInstance(COM.CLSID_FileOpenDialog, 0L, 1, COM.IID_IFileOpenDialog, ppv) == 0) {
            IFileDialog fileDialog = new IFileDialog(ppv[0]);
            int[] options = new int[1];
            if (fileDialog.GetOptions(options) == 0) {
                options[0] = options[0] | 0x68;
                fileDialog.SetOptions(options[0]);
            }
            if (this.title == null) {
                this.title = "";
            }
            if (this.title.length() > 0) {
                char[] buffer = new char[this.title.length() + 1];
                this.title.getChars(0, this.title.length(), buffer, 0);
                fileDialog.SetTitle(buffer);
            }
            if (this.filterPath != null && this.filterPath.length() > 0) {
                String path = this.filterPath.replace('/', '\\');
                char[] buffer = new char[path.length() + 1];
                path.getChars(0, path.length(), buffer, 0);
                if (COM.SHCreateItemFromParsingName(buffer, 0L, COM.IID_IShellItem, ppv) == 0) {
                    IShellItem psi = new IShellItem(ppv[0]);
                    fileDialog.ClearClientData();
                    fileDialog.SetDefaultFolder(psi);
                    psi.Release();
                }
            }
            Display display = this.parent.getDisplay();
            long hwndOwner = this.parent.handle;
            display.externalEventLoop = true;
            if (fileDialog.Show(hwndOwner) == 0 && fileDialog.GetResult(ppv) == 0) {
                IShellItem psi = new IShellItem(ppv[0]);
                if (psi.GetDisplayName(-2147123200, ppv) == 0) {
                    long wstr = ppv[0];
                    int length = OS.wcslen(wstr);
                    char[] buffer = new char[length];
                    OS.MoveMemory(buffer, wstr, length * 2);
                    OS.CoTaskMemFree(wstr);
                    this.directoryPath = new String(buffer);
                }
                psi.Release();
            }
            display.externalEventLoop = false;
            fileDialog.Release();
        }
        return this.directoryPath;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

