/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalUnaryTypeID
extends CPPDependentEvaluation {
    private final int fOperator;
    private final IType fOrigType;
    private IType fType;

    public EvalUnaryTypeID(int operator, IType type, IASTNode pointOfDefinition) {
        this(operator, type, EvalUnaryTypeID.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalUnaryTypeID(int operator, IType type, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOperator = operator;
        this.fOrigType = type;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public IType getArgument() {
        return this.fOrigType;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fOperator == 3) {
            return CPPTemplates.isDependentType(this.fOrigType);
        }
        return false;
    }

    @Override
    public boolean isValueDependent() {
        switch (this.fOperator) {
            case 22: {
                return true;
            }
            case 0: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return CPPTemplates.isDependentType(this.fOrigType);
            }
            case 1: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isConstantExpression() {
        return true;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalUnaryTypeID)) {
            return false;
        }
        EvalUnaryTypeID o = (EvalUnaryTypeID)other;
        return this.fOperator == o.fOperator && this.fOrigType.isSameType(o.fOrigType);
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            this.fType = this.computeType();
        }
        return this.fType;
    }

    private IType computeType() {
        switch (this.fOperator) {
            case 0: 
            case 2: 
            case 22: {
                IType result = (IType)CPPVisitor.get_SIZE_T().clone();
                if (SemanticUtil.getSimplifiedType(result) instanceof CPPBasicType) {
                    result = CPPVisitor.associateTypeWithValue(result, this.getValue());
                }
                return result;
            }
            case 1: {
                return CPPVisitor.get_type_info();
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return CPPBasicType.BOOLEAN;
            }
            case 3: {
                if (this.isTypeDependent()) {
                    return new TypeOfDependentExpression(this);
                }
                return this.fOrigType;
            }
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IValue getValue() {
        if (this.isValueDependent()) {
            return DependentValue.create(this);
        }
        return ValueFactory.evaluateUnaryTypeIdExpression(this.fOperator, this.fOrigType);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.fOperator == 1 ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)16);
        buffer.putByte((byte)this.fOperator);
        buffer.marshalType(this.fOrigType);
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        IType arg = buffer.unmarshalType();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalUnaryTypeID(op, arg, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        if (this.fOperator == 22) {
            return this.instantiateSizeofParameterPack(context);
        }
        return this.instantiateBySubstitution(context);
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.determinePackSize(this.fOrigType, tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return CPPTemplates.isDependentType(this.fOrigType);
    }

    private ICPPEvaluation instantiateBySubstitution(InstantiationContext context) {
        IType type = CPPTemplates.instantiateType(this.fOrigType, context);
        if (type == this.fOrigType) {
            return this;
        }
        return new EvalUnaryTypeID(this.fOperator, type, this.getTemplateDefinition());
    }

    private ICPPEvaluation instantiateSizeofParameterPack(InstantiationContext context) {
        ICPPTemplateParameter pack;
        if (this.fOrigType instanceof ICPPTemplateParameter && (pack = (ICPPTemplateParameter)((Object)this.fOrigType)).isParameterPack()) {
            ICPPTemplateArgument[] args = context.getPackExpansion(pack);
            if (args == null) {
                return this;
            }
            int concreteArgCount = 0;
            int packExpansionCount = 0;
            ICPPTemplateArgument[] iCPPTemplateArgumentArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
                if (arg.isPackExpansion()) {
                    ++packExpansionCount;
                } else {
                    ++concreteArgCount;
                }
                ++n2;
            }
            if (packExpansionCount > 0) {
                EvalUnaryTypeID packEval = null;
                ICPPTemplateArgument[] iCPPTemplateArgumentArray2 = args;
                int n3 = args.length;
                n = 0;
                while (n < n3) {
                    ICPPParameterPackType parameterPackType;
                    IType type;
                    ICPPTemplateArgument arg = iCPPTemplateArgumentArray2[n];
                    if (arg.isPackExpansion() && arg.getTypeValue() instanceof ICPPParameterPackType && (type = (parameterPackType = (ICPPParameterPackType)arg.getTypeValue()).getType()) instanceof ICPPTemplateParameter) {
                        packEval = new EvalUnaryTypeID(this.fOperator, type, this.getTemplateDefinition());
                    }
                    ++n;
                }
                if (packEval == null) {
                    return this.instantiateBySubstitution(context);
                }
                EvalBinary multiPackCountEval = new EvalBinary(1, packEval, (ICPPEvaluation)new EvalFixed(this.getType(), this.getValueCategory(), IntegralValue.create(packExpansionCount)), pack);
                return new EvalBinary(4, (ICPPEvaluation)multiPackCountEval, (ICPPEvaluation)new EvalFixed(this.getType(), this.getValueCategory(), IntegralValue.create(concreteArgCount)), pack);
            }
            return new EvalFixed(this.getType(), this.getValueCategory(), IntegralValue.create(concreteArgCount));
        }
        return EvalFixed.INCOMPLETE;
    }

    @Override
    public boolean isNoexcept() {
        return true;
    }
}

