/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.TidAnalysisModule;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualEnvironmentModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis.Messages;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis.VirtualEnvironment;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis.VirtualEnvironmentBuilder;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis.VirtualMachineModelStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class VirtualMachineModelAnalysis
extends TmfStateSystemAnalysisModule {
    public static final String GUEST_VMS = "Guests";
    public static final String CPUS = "CPUs";
    public static final String PROCESS = "Process Id";
    public static final String HYPERVISOR = "Hypervisor";
    public static final String ID = "org.eclipse.tracecompass.incubator.virtual.machine.analysis.core.model.analysis";
    private @Nullable IVirtualEnvironmentModel fVirtualEnvironment = null;

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = this.getTrace();
        if (!(trace instanceof TmfExperiment)) {
            throw new IllegalStateException();
        }
        return new VirtualMachineModelStateProvider((TmfExperiment)trace, this);
    }

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    public String getHelpText() {
        return Messages.getMessage(Messages.VirtualMachineModelAnalysis_Help);
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        HashSet<IAnalysisModule> modules = new HashSet<IAnalysisModule>();
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptySet();
        }
        TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, TidAnalysisModule.class).forEach(modules::add);
        return modules;
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        if (signal.getTrace() == this.getTrace()) {
            this.dispose();
        }
    }

    public synchronized IVirtualEnvironmentModel getVirtualEnvironmentModel() {
        IVirtualEnvironmentModel ve = this.fVirtualEnvironment;
        if (ve == null) {
            ITmfStateSystem stateSystem = this.getStateSystem();
            if (stateSystem == null) {
                throw new NullPointerException("State System null: must call #waitForInitialization() before calling this method");
            }
            ve = stateSystem.waitUntilBuilt(0L) ? new VirtualEnvironment(stateSystem) : new VirtualEnvironmentBuilder((ITmfStateSystemBuilder)stateSystem, this);
            this.fVirtualEnvironment = ve;
        }
        return ve;
    }
}

