/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.lcore.analysis;

import org.eclipse.tracecompass.incubator.internal.dpdk.core.analysis.IDpdkEventHandler;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.lcore.analysis.DpdkLogicalCoreEventLayout;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.lcore.analysis.LogicalCore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DpdkServiceEventHandler
implements IDpdkEventHandler {
    private DpdkLogicalCoreEventLayout fLayout;

    DpdkServiceEventHandler(DpdkLogicalCoreEventLayout layout) {
        this.fLayout = layout;
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) {
        long ts = event.getTimestamp().getValue();
        Integer serviceId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldId()});
        String eventName = event.getName();
        if (serviceId == null) {
            return;
        }
        if (eventName.equals(this.fLayout.eventServiceComponentRegister())) {
            String serviceName = (String)event.getContent().getFieldValue(String.class, new String[]{this.fLayout.fieldServiceName()});
            if (serviceName != null) {
                LogicalCore.setServiceName(ssb, serviceName, serviceId, ts);
                LogicalCore.setServiceStatus(ssb, LogicalCore.ServiceStatus.REGISTERED, serviceId, ts);
            }
        } else if (eventName.equals(this.fLayout.eventServiceMapLcore())) {
            Integer enabled;
            Integer lcoreId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldLcoreId()});
            if (lcoreId != null) {
                LogicalCore.setServiceLcore(ssb, lcoreId, serviceId, ts);
            }
            if ((enabled = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldEnabled()})) != null && enabled == 0) {
                LogicalCore.setServiceStatus(ssb, LogicalCore.ServiceStatus.DISABLED, serviceId, ts);
            } else {
                LogicalCore.setServiceStatus(ssb, LogicalCore.ServiceStatus.ENABLED, serviceId, ts);
            }
        } else if (eventName.equals(this.fLayout.eventServiceRunBegin())) {
            Integer lcoreId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldLcoreId()});
            if (lcoreId != null) {
                LogicalCore.setServiceLcore(ssb, lcoreId, serviceId, ts);
            }
            LogicalCore.setServiceStatus(ssb, LogicalCore.ServiceStatus.RUNNING, serviceId, ts);
        } else if (eventName.equals(this.fLayout.eventServiceRunEnd())) {
            Integer lcoreId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldLcoreId()});
            if (lcoreId != null) {
                LogicalCore.setServiceLcore(ssb, lcoreId, serviceId, ts);
            }
            LogicalCore.setServiceStatus(ssb, LogicalCore.ServiceStatus.PENDING, serviceId, ts);
        } else if (eventName.equals(this.fLayout.eventServiceRunStateSet())) {
            Integer runState = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldRunState()});
            LogicalCore.setServiceStatus(ssb, runState != null && runState == 1 ? LogicalCore.ServiceStatus.ENABLED : LogicalCore.ServiceStatus.DISABLED, serviceId, ts);
        }
    }
}

