/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows;

import java.util.Map;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsNodeMap;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsSystemTreeNode;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.IFlowsNode;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.LocationGroup;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

class FlowsLocationGroup
extends LocationGroup
implements IFlowsNode {
    private int fInputQuark = -1;
    private int fOutputQuark = -1;

    public FlowsLocationGroup(ITmfEvent event) {
        super(event);
    }

    public void initializeQuarks(ITmfStateSystemBuilder ssb, FlowsNodeMap<Long, FlowsSystemTreeNode> systemTreeNodeMap, Map<Integer, String> stringIdMap) {
        long parentId = this.getParentId();
        String fullName = this.getFullName(stringIdMap);
        int parentInputQuark = systemTreeNodeMap.getNodeQuark(parentId, "In");
        int parentOutputQuark = systemTreeNodeMap.getNodeQuark(parentId, "Out");
        if (parentInputQuark != -1 && parentOutputQuark != -1) {
            this.fInputQuark = ssb.getQuarkRelativeAndAdd(parentInputQuark, new String[]{fullName});
            this.fOutputQuark = ssb.getQuarkRelativeAndAdd(parentOutputQuark, new String[]{fullName});
        }
    }

    @Override
    public int getInputQuark() {
        return this.fInputQuark;
    }

    @Override
    public int getOutputQuark() {
        return this.fOutputQuark;
    }
}

