/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public final class FusedVMInformationProvider {
    private FusedVMInformationProvider() {
    }

    public static Collection<String> getMachinesTraced(ITmfStateSystem ssq) {
        LinkedList<String> list = new LinkedList<String>();
        List machinesQuarks = ssq.getQuarks(new String[]{"Hosts", "*"});
        for (Integer machineQuark : machinesQuarks) {
            String machineName = ssq.getAttributeName(machineQuark.intValue());
            list.add(machineName);
        }
        return list;
    }

    public static int getNbCPUs(ITmfStateSystem ssq, String hostId) {
        List vCpuquarks = ssq.getQuarks(new String[]{"Hosts", hostId, "CPUs", "*"});
        return vCpuquarks.size();
    }

    public static List<String> getMachineContainers(ITmfStateSystem ssq, String hostId) {
        LinkedList<String> containers = new LinkedList<String>();
        List containersQuark = ssq.getQuarks(new String[]{"Hosts", hostId, "Containers", "*"});
        for (Integer containerQuark : containersQuark) {
            containers.add(ssq.getAttributeName(containerQuark.intValue()));
        }
        return containers;
    }

    public static Collection<Integer> getMachineContainersQuarks(ITmfStateSystem ssq, String hostId) {
        return ssq.getQuarks(new String[]{"Hosts", hostId, "Containers", "*"});
    }

    public static int getContainerQuark(ITmfStateSystem ssq, String hostId, String containerID) {
        return ssq.optQuarkAbsolute(new String[]{"Hosts", hostId, "Containers", containerID});
    }

    public static int getNodeThreadsAndAdd(ITmfStateSystemBuilder ssq) {
        return ssq.getQuarkAbsoluteAndAdd(new String[]{"Threads"});
    }

    public static int getNodeThreads(ITmfStateSystem ssq) {
        try {
            return ssq.getQuarkAbsolute(new String[]{"Threads"});
        }
        catch (AttributeNotFoundException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static int getTypeMachine(ITmfStateSystem ssq, String hostId) {
        int quark;
        block3: {
            try {
                quark = ssq.optQuarkAbsolute(new String[]{"Hosts", hostId});
                if (quark != -2) break block3;
                return -1;
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                return -1;
            }
        }
        return ssq.querySingleState(ssq.getStartTime(), quark).getStateValue().unboxInt();
    }

    public static int getNodeNsInum(ITmfStateSystem ssq, long time, String machineName, int threadID) throws AttributeNotFoundException, StateSystemDisposedException {
        int quark = ssq.getQuarkRelative(FusedVMInformationProvider.getNodeThreads(ssq), new String[]{machineName, Integer.toString(threadID), "ns_max_level"});
        ITmfStateInterval interval = ssq.querySingleState(time, quark);
        quark = ssq.getQuarkRelative(FusedVMInformationProvider.getNodeThreads(ssq), new String[]{machineName, Integer.toString(threadID)});
        int nsMaxLevel = interval.getStateValue().unboxInt();
        int i = 1;
        while (i < nsMaxLevel) {
            quark = ssq.getQuarkRelative(quark, new String[]{"VTID"});
            ++i;
        }
        return ssq.getQuarkRelative(quark, new String[]{"ns_inum"});
    }

    public static Long getParentContainer(ITmfStateSystem ssq, int containerQuark) {
        long parentContainerID = -1L;
        try {
            int parentContainerIDQuark = ssq.optQuarkRelative(containerQuark, new String[]{"Parent"});
            if (parentContainerIDQuark != -2) {
                parentContainerID = ssq.querySingleState(ssq.getStartTime(), parentContainerIDQuark).getStateValue().unboxLong();
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return parentContainerID;
    }

    public static List<String> getAllMachines(ITmfStateSystem ssq, int physicalCpu, long time) {
        ArrayList<String> machines = new ArrayList<String>();
        try {
            List states = ssq.queryFullState(time);
            int quarkCurrentThread = ssq.optQuarkAbsolute(new String[]{"CPUs", String.valueOf(physicalCpu), "Current_thread"});
            if (quarkCurrentThread == -2) {
                return machines;
            }
            int tid = ((ITmfStateInterval)states.get(quarkCurrentThread)).getStateValue().unboxInt();
            if (tid < 0) {
                return machines;
            }
            int quarkCurrentMachine = ssq.optQuarkAbsolute(new String[]{"CPUs", String.valueOf(physicalCpu), "Machine_name"});
            if (quarkCurrentMachine == -2) {
                return machines;
            }
            ITmfStateValue stateValue = ((ITmfStateInterval)states.get(quarkCurrentMachine)).getStateValue();
            if (stateValue.isNull()) {
                return machines;
            }
            machines.add(stateValue.unboxStr());
            machines.addAll(FusedVMInformationProvider.getContainersOf(ssq, stateValue.unboxStr(), tid, states));
            int quarkCpuState = ssq.optQuarkAbsolute(new String[]{"CPUs", String.valueOf(physicalCpu), "Condition"});
            int quarkVirtualCpu = ssq.optQuarkAbsolute(new String[]{"CPUs", String.valueOf(physicalCpu), "Virtual_cpu"});
            if (quarkCpuState == -2 || quarkVirtualCpu == -2) {
                return machines;
            }
            int vmCondition = ((ITmfStateInterval)states.get(quarkCpuState)).getStateValue().unboxInt();
            if (vmCondition == 0) {
                machines.addAll(0, FusedVMInformationProvider.getParentMachines(ssq, stateValue.unboxStr(), ((ITmfStateInterval)states.get(quarkVirtualCpu)).getStateValue().unboxInt(), states));
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return machines;
    }

    private static Collection<String> getParentMachines(ITmfStateSystem ssq, String hostId, int vcpu, List<ITmfStateInterval> states) {
        ArrayList<String> machines = new ArrayList<String>();
        int machineQuark = ssq.optQuarkAbsolute(new String[]{"Hosts", hostId});
        if (machineQuark == -2) {
            return machines;
        }
        int quarkParent = ssq.optQuarkRelative(machineQuark, new String[]{"Parent"});
        int quarkVCpu = ssq.optQuarkRelative(machineQuark, new String[]{"CPUs", String.valueOf(vcpu)});
        if (quarkParent == -2 || quarkVCpu == -2) {
            return machines;
        }
        ITmfStateValue parentValue = states.get(quarkParent).getStateValue();
        if (parentValue.isNull()) {
            return machines;
        }
        machines.add(parentValue.unboxStr());
        ITmfStateValue vcpuValue = states.get(quarkVCpu).getStateValue();
        if (vcpuValue.isNull()) {
            return machines;
        }
        machines.addAll(FusedVMInformationProvider.getContainersOf(ssq, parentValue.unboxStr(), vcpuValue.unboxInt(), states));
        return machines;
    }

    private static List<String> getContainersOf(ITmfStateSystem ssq, String machine, int tid, List<ITmfStateInterval> states) {
        ArrayList<String> containers = new ArrayList<String>();
        int threadQuark = ssq.optQuarkAbsolute(new String[]{"Threads", machine, String.valueOf(tid)});
        if (threadQuark == -2) {
            return containers;
        }
        int quarkMaxLv = ssq.optQuarkRelative(threadQuark, new String[]{"ns_max_level"});
        if (quarkMaxLv == -2) {
            return containers;
        }
        int maxLv = states.get(quarkMaxLv).getStateValue().unboxInt();
        int i = 1;
        while (i < maxLv) {
            threadQuark = ssq.optQuarkRelative(threadQuark, new String[]{"VTID"});
            int inumQuark = ssq.optQuarkRelative(threadQuark, new String[]{"ns_inum"});
            if (threadQuark == -2 || inumQuark == -2) break;
            ITmfStateValue inumValue = states.get(inumQuark).getStateValue();
            if (!inumValue.isNull()) {
                containers.add(String.valueOf(inumValue.unboxLong()));
            }
            ++i;
        }
        return containers;
    }

    public static String getParentMachineHostId(ITmfStateSystem ssq, String hostId) {
        String parentHostId = "";
        try {
            int parenthostQuark = ssq.optQuarkAbsolute(new String[]{"Hosts", hostId, "Parent"});
            if (parenthostQuark == -2) {
                return parentHostId;
            }
            ITmfStateValue stateValue = ssq.querySingleState(ssq.getStartTime(), parenthostQuark).getStateValue();
            if (!stateValue.isNull()) {
                parentHostId = stateValue.unboxStr();
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return parentHostId;
    }

    public static Collection<String> getPhysicalCpusUsedByMachine(ITmfStateSystem ssq, String hostId) {
        LinkedList<String> pcpus = new LinkedList<String>();
        List pCpuquarks = new LinkedList();
        int type = FusedVMInformationProvider.getTypeMachine(ssq, hostId);
        if (type < 0) {
            return pcpus;
        }
        if ((type & 2) == 2) {
            pCpuquarks = ssq.getQuarks(new String[]{"Hosts", hostId, "pCPUs", "*"});
        } else if (type == 1) {
            pCpuquarks = ssq.getQuarks(new String[]{"Hosts", hostId, "CPUs", "*"});
        }
        for (Integer quark : pCpuquarks) {
            pcpus.add(ssq.getAttributeName(quark.intValue()));
        }
        return pcpus;
    }

    public static Collection<String> getCpusUsedByMachine(ITmfStateSystem ssq, String hostId) {
        LinkedList<String> cpus = new LinkedList<String>();
        List cpuQuarks = new LinkedList();
        int type = FusedVMInformationProvider.getTypeMachine(ssq, hostId);
        if (type < 0) {
            return cpus;
        }
        cpuQuarks = ssq.getQuarks(new String[]{"Hosts", hostId, "CPUs", "*"});
        for (Integer quark : cpuQuarks) {
            cpus.add(ssq.getAttributeName(quark.intValue()));
        }
        return cpus;
    }

    public static List<String> getPCpusUsedByContainer(ITmfStateSystem ssq, int quark) {
        LinkedList<String> pcpus = new LinkedList<String>();
        List pCpusQuarks = ssq.getQuarks(quark, new String[]{"pCPUs", "*"});
        Iterator iterator = pCpusQuarks.iterator();
        while (iterator.hasNext()) {
            int pCpuqQuark = (Integer)iterator.next();
            pcpus.add(ssq.getAttributeName(pCpuqQuark));
        }
        return pcpus;
    }

    public static String formatTime(long time) {
        return FusedVMInformationProvider.formatTimeAbs(time);
    }

    private static String formatNs(long srcTime) {
        StringBuffer str = new StringBuffer();
        long ns = Math.abs(srcTime % 1000000000L);
        String nanos = Long.toString(ns);
        str.append("000000000".substring(nanos.length()));
        str.append(nanos);
        return str.substring(0, 9);
    }

    private static String formatTimeAbs(long time) {
        StringBuffer str = new StringBuffer();
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        String stime = timeFormat.format(new Date(time / 1000000L));
        str.append(stime);
        str.append('.');
        str.append(FusedVMInformationProvider.formatNs(time));
        return String.valueOf(str);
    }

    public static @Nullable String buildThreadAttributeName(int threadId, @Nullable Integer cpuId) {
        if (threadId == 0) {
            if (cpuId == null) {
                return null;
            }
            return "0_" + String.valueOf(cpuId);
        }
        return String.valueOf(threadId);
    }

    public static String getMachineName(ITmfStateSystem ssq, String machineHost) {
        int machineNameQuark = ssq.optQuarkAbsolute(new String[]{"Hosts", machineHost, "Machine_name"});
        if (machineNameQuark == -2) {
            return machineHost;
        }
        try {
            return ssq.querySingleState(ssq.getStartTime(), machineNameQuark).getStateValue().unboxStr();
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            return machineHost;
        }
    }
}

