/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.uftrace.core.trace;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.incubator.analysis.core.aspects.ProcessNameAspect;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.DatEvent;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.DatParser;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.InfoParser;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.MapEntry;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.MapParser;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.SymParser;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.TaskParser;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.UfContext;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.UfEventType;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProviderFactory;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceKnownSize;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public class Uftrace
extends TmfTrace
implements ITmfPropertiesProvider,
ITmfTraceKnownSize,
ITmfTraceWithPreDefinedEvents {
    private Collection<DatParser> fDats = new ArrayList<DatParser>();
    private Map<Long, MapParser> fMap = new HashMap<Long, MapParser>();
    private Map<String, SymParser> fSyms = new HashMap<String, SymParser>();
    private TaskParser fTasks;
    private TmfLongLocation fCurrentLoc = new TmfLongLocation(0L);
    private InfoParser fInfo;
    private long fSize;
    private final ISymbolProvider fSymbolProvider = new UfTraceSymbolProvider();
    private final @NonNull TidAspect fTidAspect = new TidAspect();
    private final @NonNull PidAspect fPidAspect = new PidAspect();
    private final @NonNull ExecAspect fExecAspect = new ExecAspect();
    private @Nullable String fHostId = null;

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return List.of(TmfBaseAspects.getTimestampAspect(), TmfBaseAspects.getEventTypeAspect(), new ITmfEventAspect<Integer>(){

            public String getName() {
                return "depth";
            }

            public String getHelpText() {
                return "";
            }

            public @Nullable Integer resolve(ITmfEvent event) {
                Object fieldValue = event.getContent().getValue();
                if (fieldValue instanceof DatEvent) {
                    return ((DatEvent)fieldValue).getDepth();
                }
                return null;
            }
        }, new ITmfEventAspect<String>(){

            public String getName() {
                return "Address";
            }

            public String getHelpText() {
                return "";
            }

            public @Nullable String resolve(ITmfEvent event) {
                DatEvent datEvent;
                TmfResolvedSymbol symbol;
                if (event.getContent().getValue() instanceof DatEvent && (symbol = Uftrace.this.fSymbolProvider.getSymbol((datEvent = (DatEvent)event.getContent().getValue()).getTid(), 0L, datEvent.getAddress())) != null) {
                    return symbol.getSymbolName();
                }
                return null;
            }
        }, this.getTidAspect(), this.getPidAspect(), this.getExecAspect());
    }

    public IStatus validate(IProject project, String path) {
        File dir = new File(path);
        int confidence = 0;
        if (dir.isDirectory()) {
            confidence += 5;
            List<File> data = Arrays.asList(dir.listFiles());
            boolean hasDat = false;
            boolean hasMap = false;
            boolean hasSym = false;
            for (File file : data) {
                String extension = FilenameUtils.getExtension((String)file.getName());
                if (extension.equals("dat")) {
                    try {
                        if (file.getName().startsWith("perf-cpu")) continue;
                        DatParser dp = new DatParser(file);
                        if (dp.iterator().hasNext()) {
                            dp.iterator().next();
                            confidence += 4;
                            hasDat = true;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        return new Status(4, "org.eclipse.tracecompass.incubator.uftrace.core", "dat parsing error", (Throwable)e);
                    }
                }
                if (extension.equals("map")) {
                    try {
                        if (MapParser.create(file) != null) {
                            confidence += 4;
                        }
                        hasMap = true;
                    }
                    catch (IOException e) {
                        return new Status(4, "org.eclipse.tracecompass.incubator.uftrace.core", "map parsing error", (Throwable)e);
                    }
                }
                if (!extension.equals("sym")) continue;
                hasSym = true;
                confidence += 3;
            }
            if (hasMap && hasDat && hasSym && confidence > 10) {
                return new TraceValidationStatus(confidence, Activator.class.getCanonicalName());
            }
        }
        return new Status(4, "org.eclipse.tracecompass.incubator.uftrace.core", "Most probably not a UFTrace");
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        File dir = new File(path);
        if (!dir.isDirectory()) {
            throw new TmfTraceException("trace is not a directory");
        }
        super.initTrace(resource, path, type);
        long utcOffset = 0L;
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            String name = child.getName();
            try {
                List<String> fileLines;
                if (name.endsWith(".dat")) {
                    if (!name.startsWith("perf-cpu")) {
                        this.fSize += child.length();
                        this.fDats.add(new DatParser(child, 0L, utcOffset));
                    }
                } else if (name.endsWith(".map")) {
                    MapParser create = MapParser.create(child);
                    if (create != null) {
                        this.fMap.put(create.getSessionId(), create);
                    }
                } else if (name.endsWith(".sym")) {
                    this.fSyms.put(name.substring(0, name.length() - 4), SymParser.parse(child));
                } else if (name.equals("task.txt")) {
                    this.fTasks = new TaskParser(child);
                } else if (name.equals("info")) {
                    this.fInfo = InfoParser.parse(child);
                    String offset = this.fInfo.getData().getOrDefault("utc_offset", "0");
                    if (!offset.equals("0")) {
                        utcOffset = Long.parseLong(offset) * 1000000000L;
                        for (DatParser dat : this.fDats) {
                            dat.setUtcOffset(utcOffset);
                        }
                    }
                } else if (name.equals("hostid") && !(fileLines = Files.readAllLines(child.toPath())).isEmpty()) {
                    this.fHostId = fileLines.get(0);
                }
            }
            catch (IOException e) {
                throw new TmfTraceException(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
    }

    public ITmfLocation getCurrentLocation() {
        return this.fCurrentLoc;
    }

    public double getLocationRatio(ITmfLocation location) {
        return (Long)location.getLocationInfo() / this.fSize;
    }

    /*
     * Unable to fully structure code
     */
    public ITmfContext seekEvent(ITmfLocation location) {
        block3: {
            context = new UfContext(this.fDats, (ITmfTrace)this);
            if (location == null) {
                return context;
            }
            if (!(location instanceof TmfLongLocation)) break block3;
            longLocation = (TmfLongLocation)location;
            if (longLocation.getLocationInfo() != 0L) ** GOTO lbl12
            return context;
            while ((next = context.getNext()) != null) {
                this.updateAttributes((ITmfContext)context, next);
                if (context.getLocation() == null) {
                    return context;
                }
lbl12:
                // 3 sources

                if (context.getLocation() != null && Long.compare(longLocation.getLocationInfo(), Objects.requireNonNull(context.getLocation()).getLocationInfo()) >= 0) continue;
            }
        }
        return context;
    }

    public ITmfContext seekEvent(double ratio) {
        return this.seekEvent((ITmfLocation)new TmfLongLocation((long)(ratio * (double)this.fSize)));
    }

    public ITmfEvent parseEvent(@Nullable ITmfContext ctx) {
        UfContext ufContext;
        ITmfEvent tmfEvent;
        ITmfContext context = ctx;
        if (context == null) {
            context = this.seekEvent(0L);
        }
        if (ctx instanceof UfContext && (tmfEvent = (ufContext = (UfContext)ctx).getNext()) != null) {
            this.fCurrentLoc = new TmfLongLocation(this.fCurrentLoc.getLocationInfo() + 16L);
            ctx.setLocation((ITmfLocation)this.fCurrentLoc);
            this.updateAttributes(context, tmfEvent);
            return tmfEvent;
        }
        return null;
    }

    public Set<@NonNull ? extends ITmfEventType> getContainedEventTypes() {
        return UfEventType.TYPES;
    }

    public int size() {
        return (int)(this.fSize / 1024L);
    }

    public int progress() {
        return (int)(this.fCurrentLoc.getLocationInfo() / 1024L);
    }

    public @NonNull String getHostId() {
        if (this.fHostId != null) {
            return this.fHostId;
        }
        return super.getHostId();
    }

    public ISymbolProvider getSymbolProvider() {
        return this.fSymbolProvider;
    }

    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        if (this.fInfo == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<@NonNull String, @NonNull String> properties = new LinkedHashMap<String, String>();
        properties.put("version", String.valueOf(this.fInfo.getVersion()));
        properties.put("address length", String.valueOf(this.fInfo.getAddressSize()));
        properties.put("endianness", String.valueOf(this.fInfo.getByteOrder()));
        properties.put("maximum depth", String.valueOf(this.fInfo.getMaxDepth()));
        properties.put("feature bit mask", Long.toBinaryString(this.fInfo.getFeatures()));
        String hostId = this.fHostId;
        if (hostId != null) {
            properties.put("host ID", hostId);
        }
        properties.putAll(this.fInfo.getData());
        return properties;
    }

    public TaskParser getTasks() {
        return this.fTasks;
    }

    public @NonNull ExecAspect getExecAspect() {
        return this.fExecAspect;
    }

    public @NonNull PidAspect getPidAspect() {
        return this.fPidAspect;
    }

    public @NonNull TidAspect getTidAspect() {
        return this.fTidAspect;
    }

    public final class ExecAspect
    extends ProcessNameAspect {
        public @Nullable String resolve(@NonNull ITmfEvent event) {
            if (event.getContent().getValue() instanceof DatEvent) {
                DatEvent datEvent = (DatEvent)event.getContent().getValue();
                int tid = datEvent.getTid();
                return Uftrace.this.fTasks.getExecName(tid);
            }
            return null;
        }
    }

    public final class PidAspect
    extends LinuxPidAspect {
        public @Nullable Integer resolve(ITmfEvent event) {
            if (event.getContent().getValue() instanceof DatEvent) {
                DatEvent datEvent = (DatEvent)event.getContent().getValue();
                int tid = datEvent.getTid();
                return Uftrace.this.fTasks.getPid(tid);
            }
            return null;
        }
    }

    public final class TidAspect
    extends LinuxTidAspect {
        public @Nullable Integer resolve(ITmfEvent event) {
            if (event.getContent().getValue() instanceof DatEvent) {
                DatEvent datEvent = (DatEvent)event.getContent().getValue();
                return datEvent.getTid();
            }
            return null;
        }
    }

    private class UfTraceSymbolProvider
    implements ISymbolProvider {
        private UfTraceSymbolProvider() {
        }

        public TmfResolvedSymbol getSymbol(int tid, long timestamp, long address) {
            SymParser.Symbol value;
            String execName = Uftrace.this.fTasks.getExecName(tid);
            if (execName == null) {
                return new TmfResolvedSymbol(address, "0x" + Long.toHexString(address));
            }
            Long session = Uftrace.this.fTasks.getSessName(tid);
            if (session == null) {
                return new TmfResolvedSymbol(address, "0x" + Long.toHexString(address));
            }
            MapParser mapParser = Uftrace.this.fMap.get(session);
            if (mapParser == null) {
                return new TmfResolvedSymbol(address, "0x" + Long.toHexString(address));
            }
            Map.Entry<Long, MapEntry> key = mapParser.getData().floorEntry(address);
            if (key == null) {
                return new TmfResolvedSymbol(address, "0x" + Long.toHexString(address));
            }
            long offset = address - key.getValue().getAddrLow();
            String pathName = key.getValue().getPathName();
            String substring = pathName.substring(pathName.lastIndexOf(File.separator) + 1);
            SymParser sym = Uftrace.this.fSyms.get(substring);
            if (sym == null) {
                return new TmfResolvedSymbol(address, pathName + ":0x" + Long.toHexString(address));
            }
            Map.Entry<Long, SymParser.Symbol> floorEntry = sym.getMap().floorEntry(offset);
            if (floorEntry != null && (value = floorEntry.getValue()) != null) {
                String name = String.valueOf(value.getName());
                return new TmfResolvedSymbol(address, name);
            }
            return new TmfResolvedSymbol(address, "0x" + Long.toHexString(address));
        }

        public @NonNull ITmfTrace getTrace() {
            return (ITmfTrace)this;
        }

        public void loadConfiguration(@Nullable IProgressMonitor monitor) {
        }

        public @Nullable TmfResolvedSymbol getSymbol(long address) {
            return this.getSymbol((Integer)Iterables.getFirst(Uftrace.this.fTasks.getTids(), (Object)-1), 0L, address);
        }
    }

    public static class UfTraceSymbolProviderAllegedFactory
    implements ISymbolProviderFactory {
        public @Nullable ISymbolProvider createProvider(@NonNull ITmfTrace trace) {
            if (trace instanceof Uftrace) {
                return ((Uftrace)trace).getSymbolProvider();
            }
            return null;
        }
    }
}

