/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.inandout.core.analysis;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.InstrumentedCallStackAnalysis;
import org.eclipse.tracecompass.incubator.internal.inandout.core.Activator;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.InAndOutAnalysisStateProvider;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.SegmentSpecifier;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class InAndOutAnalysisModule
extends InstrumentedCallStackAnalysis {
    public static final String ID = "org.eclipse.tracecompass.incubator.inandout.analysis";
    public static final String JSON = ".config.json";
    public static final SegmentSpecifier REFERENCE = new SegmentSpecifier("latency", "(\\S*)_entry", "(\\S*)_exit", "(\\S*)_entry", "(\\S*)_exit", "CPU");

    public @NonNull String getId() {
        return ID;
    }

    public boolean canExecute(@NonNull ITmfTrace trace) {
        File config = InAndOutAnalysisModule.getConfig(trace);
        return config.exists() && super.canExecute(trace);
    }

    private static File getConfig(@NonNull ITmfTrace trace) {
        String folder = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        File config = new File(folder + File.separator + "org.eclipse.tracecompass.incubator.inandout.analysis.config.json");
        if (!config.exists()) {
            ArrayList<@NonNull SegmentSpecifier> specifiers = new ArrayList<SegmentSpecifier>();
            specifiers.add(new SegmentSpecifier(REFERENCE));
            InAndOutAnalysisModule.write(config, specifiers);
        }
        return config;
    }

    protected @NonNull ITmfStateProvider createStateProvider() {
        ITmfTrace trace = Objects.requireNonNull(this.getTrace(), "Trace should not be null at this point");
        File configFile = InAndOutAnalysisModule.getConfig(trace);
        List<@NonNull SegmentSpecifier> list = InAndOutAnalysisModule.read(configFile);
        return new InAndOutAnalysisStateProvider(trace, list);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static List<@NonNull SegmentSpecifier> read(File file) {
        Type listType = new TypeToken<ArrayList<SegmentSpecifier>>(){}.getType();
        @NonNull List specifiers = Collections.emptyList();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader reader = new FileReader(file);){
                @NonNull List list = (List)new Gson().fromJson((Reader)reader, listType);
                if (list != null) {
                    specifiers = list;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
        return specifiers;
    }

    public static void write(File file, List<@NonNull SegmentSpecifier> specifiers) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter writer = new FileWriter(file);){
                ((Writer)writer).append(new Gson().toJson(specifiers));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }
}

