/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.trace;

import java.util.Map;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class SystemTreeNode {
    private static final String WHITESPACE = " ";
    private final long fId;
    private final long fParentId;
    private final long fNameId;
    private final long fClassNameId;

    public SystemTreeNode(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Long id = (Long)content.getFieldValue(Long.class, new String[]{"self"});
        this.fId = id == null ? 0xFFFFFFFFL : id;
        Long parentId = (Long)content.getFieldValue(Long.class, new String[]{"systemTreeParent"});
        this.fParentId = parentId == null ? 0xFFFFFFFFL : parentId;
        Long nameId = (Long)content.getFieldValue(Long.class, new String[]{"name"});
        this.fNameId = nameId == null ? 0xFFFFFFFFL : nameId;
        Long classNameId = (Long)content.getFieldValue(Long.class, new String[]{"className"});
        this.fClassNameId = classNameId == null ? 0xFFFFFFFFL : classNameId;
    }

    public String getFullName(Map<Integer, String> stringIdMap) {
        String name = stringIdMap.get((int)this.fNameId);
        String className = stringIdMap.get((int)this.fClassNameId);
        return className + WHITESPACE + name;
    }

    public long getId() {
        return this.fId;
    }

    public long getParentId() {
        return this.fParentId;
    }

    public boolean isRootNode() {
        return this.getParentId() == 0xFFFFFFFFL;
    }
}

