/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.dialogs.AddBookmarkDialog;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.viewers.IImageSave;
import org.eclipse.tracecompass.tmf.ui.views.ResetUtil;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ITimeGraphLegendProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphBookmarkListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphMarkerListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTreeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphViewerFilterListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphBookmarkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ShowFilterDialogAction;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TimeGraphLegend;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.IMarkerAxisListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeDataProviderCyclesConverter;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphMarkerAxis;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphScale;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphTooltipHandler;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.PlatformUI;

public class TimeGraphViewer
extends Viewer
implements ITimeDataProvider,
IMarkerAxisListener,
SelectionListener,
IImageSave {
    public static final int ALL_LEVELS = -1;
    private static final int DEFAULT_NAME_WIDTH = 200;
    private static final int MIN_NAME_WIDTH = 3;
    private static final int MAX_NAME_WIDTH = 1000;
    private static final int DEFAULT_HEIGHT = 22;
    private static final String HIDE_ARROWS_KEY = "hide.arrows";
    private static final String HIDE_GRIDLINES_HORIZONTAL_KEY = "hide.gridlines.horizontal";
    private static final String HIDE_GRIDLINES_VERTICAL_KEY = "hide.gridlines.vertical";
    private static final long DEFAULT_FREQUENCY = 1000000000L;
    private static final int H_SCROLLBAR_MAX = 0x7FFFFFFE;
    private static final ImageDescriptor ADD_BOOKMARK = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/add_bookmark.gif");
    private static final ImageDescriptor NEXT_BOOKMARK = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_bookmark.gif");
    private static final ImageDescriptor PREVIOUS_BOOKMARK = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_bookmark.gif");
    private static final ImageDescriptor REMOVE_BOOKMARK = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/remove_bookmark.gif");
    private long fMinTimeInterval;
    private ITimeGraphEntry fSelectedEntry;
    private long fBeginTime = -1L;
    private long fEndTime = -1L;
    private long fTime0 = -1L;
    private long fTime1 = -1L;
    private long fSelectionBegin = -1L;
    private long fSelectionEnd = -1L;
    private long fTime0Bound = -1L;
    private long fTime1Bound = -1L;
    private long fTime0ExtSynch = -1L;
    private long fTime1ExtSynch = -1L;
    private boolean fTimeRangeFixed;
    private int fNameWidthPref = 200;
    private int fMinNameWidth = 3;
    private int fNameWidth;
    private int[] fWeights;
    private TimeGraphControl fTimeGraphCtrl;
    private Tree fTree;
    private TimeGraphScale fTimeScaleCtrl;
    private TimeGraphMarkerAxis fMarkerAxisCtrl;
    private Slider fHorizontalScrollBar;
    private Slider fVerticalScrollBar;
    private @NonNull TimeGraphColorScheme fColorScheme = new TimeGraphColorScheme();
    private Object fInputElement;
    private ITimeGraphContentProvider fTimeGraphContentProvider;
    private ITimeGraphPresentationProvider fTimeGraphProvider;
    private ITableLabelProvider fLabelProvider;
    private @NonNull ITimeDataProvider fTimeDataProvider = this;
    private TimeGraphTooltipHandler fToolTipHandler;
    private List<ITimeGraphSelectionListener> fSelectionListeners = new ArrayList<ITimeGraphSelectionListener>();
    private List<ITimeGraphTimeListener> fTimeListeners = new ArrayList<ITimeGraphTimeListener>();
    private List<ITimeGraphRangeListener> fRangeListeners = new ArrayList<ITimeGraphRangeListener>();
    private List<ITimeGraphBookmarkListener> fBookmarkListeners = new ArrayList<ITimeGraphBookmarkListener>();
    private List<ITimeGraphMarkerListener> fMarkerListeners = new ArrayList<ITimeGraphMarkerListener>();
    private Utils.TimeFormat fTimeFormat = Utils.TimeFormat.RELATIVE;
    private long fClockFrequency = 1000000000L;
    private int fBorderWidth = 0;
    private int fTimeScaleHeight = 22;
    private Action fResetScaleAction;
    private Action fShowLegendAction;
    private Action fNextEventAction;
    private Action fPrevEventAction;
    private Action fNextItemAction;
    private Action fPreviousItemAction;
    private Action fZoomInAction;
    private Action fZoomOutAction;
    private Action fHideArrowsAction;
    private Action fFollowArrowFwdAction;
    private Action fFollowArrowBwdAction;
    private ShowFilterDialogAction fShowFilterDialogAction;
    private Action fToggleBookmarkAction;
    private Action fNextMarkerAction;
    private Action fPreviousMarkerAction;
    private MenuManager fMarkersMenu;
    private MenuManager fGridlinesMenu;
    private final List<IMarkerEvent> fBookmarks = new ArrayList<IMarkerEvent>();
    private final List<String> fMarkerCategories = new ArrayList<String>();
    private final Set<String> fHiddenMarkerCategories = new HashSet<String>();
    private final Set<String> fSkippedMarkerCategories = new HashSet<String>();
    private final List<IMarkerEvent> fMarkers = new ArrayList<IMarkerEvent>();
    private ListenerNotifier fListenerNotifier;
    private Composite fTimeAlignedComposite;
    private Composite fFirstRowFiller;
    private Composite fLastRowLeftFiller;
    private Composite fLastRowRightFiller;
    private ITimeGraphLegendProvider fLegendProvider;
    private Action fHorizontalAction;
    private Action fVerticalAction;

    public TimeGraphViewer(Composite parent, int style) {
        this.createDataViewer(parent, style);
        this.fTimeGraphContentProvider = new TimeGraphContentProvider();
    }

    public void setTimeGraphContentProvider(ITimeGraphContentProvider timeGraphContentProvider) {
        this.fTimeGraphContentProvider = timeGraphContentProvider;
    }

    public ITimeGraphContentProvider getTimeGraphContentProvider() {
        return this.fTimeGraphContentProvider;
    }

    public void setTimeGraphProvider(ITimeGraphPresentationProvider timeGraphProvider) {
        this.fTimeGraphProvider = timeGraphProvider;
        this.fTimeGraphCtrl.setTimeGraphProvider(timeGraphProvider);
        this.fToolTipHandler = new TimeGraphTooltipHandler(this.fTimeGraphProvider, this.fTimeDataProvider);
        this.fToolTipHandler.activateHoverHelp((Control)this.fTimeGraphCtrl);
    }

    public ITimeGraphPresentationProvider getTimeGraphProvider() {
        return this.fTimeGraphProvider;
    }

    public void setTimeGraphLabelProvider(ITableLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
        if (this.fTimeGraphCtrl != null) {
            this.fTimeGraphCtrl.setLabelProvider(labelProvider);
        }
    }

    public void setFilterColumns(String[] columnNames) {
        this.getShowFilterDialogAction().getFilterDialog().setColumnNames(columnNames);
    }

    public void setFilterContentProvider(ITreeContentProvider contentProvider) {
        this.getShowFilterDialogAction().getFilterDialog().setContentProvider(contentProvider);
    }

    public void setFilterLabelProvider(ITableLabelProvider labelProvider) {
        this.getShowFilterDialogAction().getFilterDialog().setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setInput(Object inputElement) {
        Object oldInput = this.fInputElement;
        this.fTimeGraphContentProvider.inputChanged(this, oldInput, inputElement);
        this.fInputElement = inputElement;
        ITimeGraphEntry[] input = this.fTimeGraphContentProvider.getElements(inputElement);
        this.fListenerNotifier = null;
        if (this.fTimeGraphCtrl != null) {
            this.setTimeRange(input);
            this.setTopIndex(0);
            this.fSelectionBegin = -1L;
            this.fSelectionEnd = -1L;
            this.updateMarkerActions();
            this.fSelectedEntry = null;
            this.refreshAllData(input);
        }
    }

    public Object getInput() {
        return this.fInputElement;
    }

    public void setLinks(List<ILinkEvent> links) {
        if (this.fTimeGraphCtrl != null) {
            this.fTimeGraphCtrl.refreshArrows(links);
        }
    }

    public void refresh() {
        ITimeGraphEntry[] input = this.fTimeGraphContentProvider.getElements(this.fInputElement);
        this.setTimeRange(input);
        this.refreshAllData(input);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.resizeControls();
    }

    protected String getViewTypeStr() {
        return "viewoption.threads";
    }

    int getMarginWidth() {
        return 0;
    }

    int getMarginHeight() {
        return 0;
    }

    void loadOptions() {
        this.fMinTimeInterval = 1L;
        this.fSelectionBegin = -1L;
        this.fSelectionEnd = -1L;
        this.fNameWidth = Utils.loadIntOption(this.getPreferenceString("namewidth"), this.fNameWidthPref, this.fMinNameWidth, 1000);
    }

    void saveOptions() {
        Utils.saveIntOption(this.getPreferenceString("namewidth"), this.fNameWidth);
    }

    protected Control createDataViewer(Composite parent, int style) {
        this.loadOptions();
        this.fTimeAlignedComposite = new Composite(parent, style){

            public void redraw() {
                TimeGraphViewer.this.fTree.redraw();
                TimeGraphViewer.this.fTimeScaleCtrl.redraw();
                TimeGraphViewer.this.fTimeGraphCtrl.redraw();
                TimeGraphViewer.this.fMarkerAxisCtrl.redraw();
                super.redraw();
            }
        };
        this.fTimeAlignedComposite.addDisposeListener(e -> {
            if (this.fMarkersMenu != null) {
                this.fMarkersMenu.dispose();
            }
            if (this.fGridlinesMenu != null) {
                this.fGridlinesMenu.dispose();
            }
        });
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = this.fBorderWidth;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.fTimeAlignedComposite.setLayout((Layout)gl);
        this.fTree = new Tree(this.fTimeAlignedComposite, 16);
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = this.fNameWidth;
        this.fTree.setLayoutData((Object)gd);
        this.fTree.setHeaderVisible(true);
        TreeColumn column = new TreeColumn(this.fTree, 16384);
        column.setResizable(false);
        this.fTree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int headerHeight = TimeGraphViewer.this.fTree.getHeaderHeight();
                if (headerHeight > 0) {
                    TimeGraphViewer.this.fTree.removePaintListener((PaintListener)this);
                    TimeGraphViewer.this.setHeaderHeight(headerHeight);
                    TimeGraphViewer.this.setHeaderHeight(headerHeight + 1);
                }
            }
        });
        this.fTimeScaleCtrl = new TimeGraphScale(this.fTimeAlignedComposite, this.fColorScheme);
        this.fTimeScaleCtrl.setTimeProvider(this.fTimeDataProvider);
        this.fTimeScaleCtrl.setLayoutData(new GridData(4, -1, true, false));
        this.fTimeScaleCtrl.setHeight(this.fTimeScaleHeight);
        this.fTimeScaleCtrl.addMouseWheelListener(e -> {
            if (e.count == 0) {
                return;
            }
            if ((e.stateMask & 0x40000) != 0) {
                this.fTimeGraphCtrl.zoom(e.count > 0);
            } else {
                this.fTimeGraphCtrl.horizontalScroll(e.count > 0);
            }
        });
        this.fFirstRowFiller = new Composite(this.fTimeAlignedComposite, 0);
        this.fFirstRowFiller.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.fFirstRowFiller.setLayout((Layout)new FillLayout());
        this.fTimeGraphCtrl = this.createTimeGraphControl(this.fTimeAlignedComposite, this.fColorScheme);
        this.fTimeGraphCtrl.setTimeProvider(this);
        this.fTimeGraphCtrl.setLabelProvider(this.fLabelProvider);
        this.fTimeGraphCtrl.setTree(this.fTree);
        this.fTimeGraphCtrl.setTimeGraphScale(this.fTimeScaleCtrl);
        this.fTimeGraphCtrl.addSelectionListener(this);
        this.fTimeGraphCtrl.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.fTimeGraphCtrl.addMouseWheelListener(e -> {
            if (e.count == 0) {
                return;
            }
            Point ctrlParentCoords = this.fTimeAlignedComposite.toControl(this.fTimeGraphCtrl.toDisplay(e.x, e.y));
            Point scrollBarParentCoords = this.fTimeAlignedComposite.toControl(this.fTimeGraphCtrl.toDisplay(e.x, e.y));
            if (this.fTimeGraphCtrl.getBounds().contains(ctrlParentCoords)) {
                this.adjustVerticalScrollBar();
            } else if (this.fTimeScaleCtrl.getBounds().contains(ctrlParentCoords) || this.fMarkerAxisCtrl.getBounds().contains(ctrlParentCoords) || this.fHorizontalScrollBar.getBounds().contains(scrollBarParentCoords)) {
                if ((e.stateMask & 0x40000) != 0) {
                    this.fTimeGraphCtrl.zoom(e.count > 0);
                } else {
                    this.fTimeGraphCtrl.horizontalScroll(e.count > 0);
                }
            } else {
                this.setTopIndex(this.getTopIndex() - e.count);
            }
        });
        this.fTimeGraphCtrl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 46) {
                    boolean extend;
                    boolean bl = extend = (e.stateMask & 0x20000) != 0;
                    if (extend) {
                        TimeGraphViewer.this.extendToNextMarker();
                    } else {
                        TimeGraphViewer.this.selectNextMarker();
                    }
                } else if (e.keyCode == 44) {
                    boolean extend;
                    boolean bl = extend = (e.stateMask & 0x20000) != 0;
                    if (extend) {
                        TimeGraphViewer.this.extendToPrevMarker();
                    } else {
                        TimeGraphViewer.this.selectPrevMarker();
                    }
                } else if (e.keyCode == 103 && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
                    if (TimeGraphViewer.this.fHorizontalAction == null) {
                        TimeGraphViewer.this.getGridlinesMenu();
                    }
                    boolean hChecked = TimeGraphViewer.this.fHorizontalAction.isChecked();
                    boolean vChecked = TimeGraphViewer.this.fVerticalAction.isChecked();
                    boolean nextH = !vChecked;
                    boolean nextV = hChecked;
                    if (nextV != vChecked) {
                        TimeGraphViewer.this.fVerticalAction.setChecked(nextV);
                        TimeGraphViewer.this.fVerticalAction.runWithEvent(null);
                    }
                    if (nextH != hChecked) {
                        TimeGraphViewer.this.fHorizontalAction.setChecked(nextH);
                        TimeGraphViewer.this.fHorizontalAction.runWithEvent(null);
                    }
                }
                TimeGraphViewer.this.adjustVerticalScrollBar();
            }
        });
        this.fVerticalScrollBar = new Slider(this.fTimeAlignedComposite, 524800);
        this.fVerticalScrollBar.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.fVerticalScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeGraphViewer.this.setTopIndex(TimeGraphViewer.this.fVerticalScrollBar.getSelection());
            }
        });
        this.fMarkerAxisCtrl = this.createTimeGraphMarkerAxis(this.fTimeAlignedComposite, this.fColorScheme, this);
        this.fMarkerAxisCtrl.setLayoutData(new GridData(4, -1, true, false, 3, 1));
        this.fMarkerAxisCtrl.addMarkerAxisListener(this);
        this.fMarkerAxisCtrl.addMouseWheelListener(e -> {
            if (e.count == 0) {
                return;
            }
            if ((e.stateMask & 0x40000) != 0) {
                this.fTimeGraphCtrl.zoom(e.count > 0);
            } else {
                this.fTimeGraphCtrl.horizontalScroll(e.count > 0);
            }
        });
        this.fLastRowLeftFiller = new Composite(this.fTimeAlignedComposite, 0);
        this.fLastRowLeftFiller.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.fLastRowLeftFiller.setLayout((Layout)new FillLayout());
        this.fHorizontalScrollBar = new Slider(this.fTimeAlignedComposite, 524544);
        GridData layoutData = new GridData(4, 128, false, false);
        layoutData.widthHint = 0;
        this.fHorizontalScrollBar.setLayoutData((Object)layoutData);
        this.fHorizontalScrollBar.addListener(37, event -> {
            event.doit = false;
            if (event.count == 0) {
                return;
            }
            if ((event.stateMask & 0x40000) != 0) {
                this.fTimeGraphCtrl.zoom(event.count > 0);
            } else {
                this.fTimeGraphCtrl.horizontalScroll(event.count > 0);
            }
        });
        this.fHorizontalScrollBar.addListener(13, event -> {
            int start = this.fHorizontalScrollBar.getSelection();
            long time0 = this.getTime0();
            long time1 = this.getTime1();
            long timeMin = this.getMinTime();
            long timeMax = this.getMaxTime();
            long delta = timeMax - timeMin;
            long range = time1 - time0;
            time0 = timeMin + Math.round((double)delta * ((double)start / 2.147483646E9));
            time1 = time0 + range;
            this.setStartFinishTimeNotify(time0, time1);
        });
        this.fLastRowRightFiller = new Composite(this.fTimeAlignedComposite, 0);
        this.fLastRowRightFiller.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fLastRowRightFiller.setLayout((Layout)new FillLayout());
        this.fTimeGraphCtrl.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TimeGraphViewer.this.resizeControls();
            }
        });
        this.resizeControls();
        this.fTimeAlignedComposite.update();
        this.adjustHorizontalScrollBar();
        this.adjustVerticalScrollBar();
        this.fTimeAlignedComposite.addDisposeListener(e -> {
            this.saveOptions();
            this.fColorScheme.dispose();
        });
        return this.fTimeAlignedComposite;
    }

    public void dispose() {
        this.fTimeAlignedComposite.dispose();
    }

    protected TimeGraphControl createTimeGraphControl(Composite parent, TimeGraphColorScheme colors) {
        return new TimeGraphControl(parent, colors);
    }

    protected TimeGraphMarkerAxis createTimeGraphMarkerAxis(Composite parent, @NonNull TimeGraphColorScheme colorScheme, @NonNull ITimeDataProvider timeProvider) {
        return new TimeGraphMarkerAxis(parent, colorScheme, timeProvider);
    }

    public void resizeControls() {
        int width;
        Rectangle r = this.fTimeAlignedComposite.getClientArea();
        if (r.isEmpty()) {
            return;
        }
        if (this.fWeights != null) {
            this.setWeights(this.fWeights);
            this.fWeights = null;
        }
        if (this.fNameWidth > (width = r.width) - this.fMinNameWidth) {
            this.fNameWidth = width - this.fMinNameWidth;
        }
        if (this.fNameWidth < this.fMinNameWidth) {
            this.fNameWidth = this.fMinNameWidth;
        }
        GridData gd = (GridData)this.fTree.getLayoutData();
        gd.widthHint = this.fNameWidth;
        if (this.fTree.getColumnCount() == 1) {
            this.fTree.getColumn(0).setWidth(this.fNameWidth);
        }
        this.adjustHorizontalScrollBar();
        this.adjustVerticalScrollBar();
    }

    public void setTimeRange(ITimeGraphEntry[] entries) {
        this.fTime0Bound = this.fBeginTime != -1L ? this.fBeginTime : this.fEndTime;
        long l = this.fTime1Bound = this.fEndTime != -1L ? this.fEndTime : this.fBeginTime;
        if (this.fBeginTime != -1L && this.fEndTime != -1L) {
            return;
        }
        if (entries == null || entries.length == 0) {
            return;
        }
        if (this.fTime0Bound == -1L) {
            this.fTime0Bound = Long.MAX_VALUE;
        }
        if (this.fTime1Bound == -1L) {
            this.fTime1Bound = Long.MIN_VALUE;
        }
        ITimeGraphEntry[] iTimeGraphEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ITimeGraphEntry entry = iTimeGraphEntryArray[n2];
            this.setTimeRange(entry);
            ++n2;
        }
        if (this.fTime0Bound > this.fTime1Bound) {
            this.fTime0Bound = -1L;
            this.fTime1Bound = -1L;
        }
    }

    private void setTimeRange(ITimeGraphEntry entry) {
        if (this.fBeginTime == -1L && entry.hasTimeEvents() && entry.getStartTime() != -1L) {
            this.fTime0Bound = Math.min(entry.getStartTime(), this.fTime0Bound);
        }
        if (this.fEndTime == -1L && entry.hasTimeEvents() && entry.getEndTime() != -1L) {
            this.fTime1Bound = Math.max(entry.getEndTime(), this.fTime1Bound);
        }
        if (entry.hasChildren()) {
            for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                this.setTimeRange(iTimeGraphEntry);
            }
        }
    }

    public void setTimeBounds(long beginTime, long endTime) {
        this.fBeginTime = beginTime;
        this.fEndTime = endTime;
        this.fTime0Bound = this.fBeginTime != -1L ? this.fBeginTime : this.fEndTime;
        long l = this.fTime1Bound = this.fEndTime != -1L ? this.fEndTime : this.fBeginTime;
        if (this.fTime0Bound > this.fTime1Bound) {
            this.fBeginTime = endTime;
            this.fEndTime = beginTime;
            this.fTime0Bound = this.fBeginTime;
            this.fTime1Bound = this.fEndTime;
        }
        this.adjustHorizontalScrollBar();
    }

    public void setTimeBounds() {
        if (!this.fTimeRangeFixed) {
            this.fTime0 = this.fTime0Bound;
            this.fTime1 = this.fTime1Bound;
        }
        this.fTime0 = Math.max(this.fTime0Bound, Math.min(this.fTime0, this.fTime1Bound));
        this.fTime1 = Math.max(this.fTime0Bound, Math.min(this.fTime1, this.fTime1Bound));
        if (this.fTime1 - this.fTime0 < this.fMinTimeInterval) {
            this.fTime1 = Math.min(this.fTime1Bound, this.fTime0 + this.fMinTimeInterval);
        }
    }

    private void refreshAllData(ITimeGraphEntry[] traces) {
        this.setTimeBounds();
        if (this.fSelectionBegin < this.fBeginTime) {
            this.fSelectionBegin = this.fBeginTime;
        } else if (this.fSelectionBegin > this.fEndTime) {
            this.fSelectionBegin = this.fEndTime;
        }
        if (this.fSelectionEnd < this.fBeginTime) {
            this.fSelectionEnd = this.fBeginTime;
        } else if (this.fSelectionEnd > this.fEndTime) {
            this.fSelectionEnd = this.fEndTime;
        }
        this.fTimeGraphCtrl.refreshData(traces);
        this.fTimeScaleCtrl.redraw();
        this.fMarkerAxisCtrl.redraw();
        this.updateMarkerActions();
        this.adjustVerticalScrollBar();
    }

    public void setFocus() {
        if (this.fTimeGraphCtrl != null) {
            this.fTimeGraphCtrl.setFocus();
        }
    }

    public boolean isInFocus() {
        return this.fTimeGraphCtrl.isInFocus();
    }

    public ITimeGraphEntry getSelection() {
        return this.fTimeGraphCtrl.getSelectedTrace();
    }

    public int getSelectionIndex() {
        return this.fTimeGraphCtrl.getSelectedIndex();
    }

    @Override
    public long getTime0() {
        return this.fTime0;
    }

    @Override
    public long getTime1() {
        return this.fTime1;
    }

    @Override
    public long getMinTimeInterval() {
        return this.fMinTimeInterval;
    }

    public void setWeights(int[] weights) {
        if (weights.length != 2) {
            return;
        }
        int width = this.fTimeAlignedComposite.getSize().x;
        if (width == 0) {
            this.fWeights = Arrays.copyOf(weights, weights.length);
            return;
        }
        this.setNameSpace(width * weights[0] / (weights[0] + weights[1]));
    }

    @Override
    public int getNameSpace() {
        return this.fNameWidth;
    }

    @Override
    public void setNameSpace(int width) {
        this.fNameWidth = width;
        int w = this.fTimeGraphCtrl.getClientArea().width;
        if (this.fNameWidth > w - 3) {
            this.fNameWidth = w - 3;
        }
        if (this.fNameWidth < 3) {
            this.fNameWidth = 3;
        }
        GridData gd = (GridData)this.fTree.getLayoutData();
        gd.widthHint = this.fNameWidth;
        if (this.fTree.getColumnCount() == 1) {
            this.fTree.getColumn(0).setWidth(this.fNameWidth);
        }
        GridData gd1 = (GridData)this.fLastRowLeftFiller.getLayoutData();
        gd1.widthHint = this.fNameWidth;
        this.fTimeAlignedComposite.layout();
        this.fTree.redraw();
        this.fTimeGraphCtrl.redraw();
        this.fTimeScaleCtrl.redraw();
        this.fMarkerAxisCtrl.redraw();
    }

    @Override
    public int getTimeSpace() {
        int w = this.fTimeGraphCtrl.getClientArea().width;
        return w - this.fNameWidth;
    }

    @Override
    public long getBeginTime() {
        return this.fBeginTime;
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    @Override
    public long getMaxTime() {
        return this.fTime1Bound;
    }

    @Override
    public long getMinTime() {
        return this.fTime0Bound;
    }

    @Override
    public long getSelectionBegin() {
        return this.fSelectionBegin;
    }

    @Override
    public long getSelectionEnd() {
        return this.fSelectionEnd;
    }

    @Override
    public void setStartFinishTimeNotify(long time0, long time1) {
        this.setStartFinishTimeInt(time0, time1);
        this.notifyRangeListeners();
    }

    @Override
    public void notifyStartFinishTime() {
        this.notifyRangeListeners();
    }

    @Override
    public void setStartFinishTime(long time0, long time1) {
        if (this.fListenerNotifier != null && this.fListenerNotifier.hasTimeRangeUpdated()) {
            return;
        }
        this.setStartFinishTimeInt(time0, time1);
        this.updateExtSynchValues();
    }

    private void setStartFinishTimeInt(long time0, long time1) {
        this.fTime0 = time0;
        if (this.fTime0 < this.fTime0Bound) {
            this.fTime0 = this.fTime0Bound;
        }
        if (this.fTime0 > this.fTime1Bound) {
            this.fTime0 = this.fTime1Bound;
        }
        this.fTime1 = time1;
        if (this.fTime1 < this.fTime0Bound) {
            this.fTime1 = this.fTime0Bound;
        }
        if (this.fTime1 > this.fTime1Bound) {
            this.fTime1 = this.fTime1Bound;
        }
        if (this.fTime1 - this.fTime0 < this.fMinTimeInterval) {
            this.fTime1 = Math.min(this.fTime1Bound, this.fTime0 + this.fMinTimeInterval);
        }
        this.fTimeRangeFixed = true;
        this.adjustHorizontalScrollBar();
        this.fTimeGraphCtrl.redraw();
        this.fTimeScaleCtrl.redraw();
        this.fMarkerAxisCtrl.redraw();
    }

    @Override
    public void resetStartFinishTime() {
        this.setStartFinishTimeNotify(this.fTime0Bound, this.fTime1Bound);
        this.fTimeRangeFixed = false;
    }

    @Override
    public void resetStartFinishTime(boolean notify) {
        if (notify) {
            this.setStartFinishTimeNotify(this.fTime0Bound, this.fTime1Bound);
        } else {
            this.setStartFinishTime(this.fTime0Bound, this.fTime1Bound);
        }
        this.fTimeRangeFixed = false;
    }

    @Override
    public void setSelectedTimeNotify(long time, boolean ensureVisible) {
        this.setSelectedTimeInt(time, ensureVisible, true);
    }

    @Override
    public void setSelectedTime(long time, boolean ensureVisible) {
        if (this.fListenerNotifier != null && this.fListenerNotifier.hasTimeSelected()) {
            return;
        }
        this.setSelectedTimeInt(time, ensureVisible, false);
    }

    private void setSelectedTimeInt(long time, boolean ensureVisible, boolean doNotify) {
        this.setSelectionRangeInt(time, time, ensureVisible, doNotify);
    }

    @Override
    public void setSelectionRangeNotify(long beginTime, long endTime, boolean ensureVisible) {
        this.setSelectionRangeInt(beginTime, endTime, ensureVisible, true);
    }

    @Override
    public void setSelectionRange(long beginTime, long endTime, boolean ensureVisible) {
        if (this.fListenerNotifier != null && this.fListenerNotifier.hasTimeSelected()) {
            return;
        }
        this.setSelectionRangeInt(beginTime, endTime, ensureVisible, false);
    }

    private void setSelectionRangeInt(long beginTime, long endTime, boolean ensureVisible, boolean doNotify) {
        boolean changed;
        long time0 = this.fTime0;
        long time1 = this.fTime1;
        long selectionBegin = this.fSelectionBegin;
        long selectionEnd = this.fSelectionEnd;
        this.fSelectionBegin = Math.max(this.fTime0Bound, Math.min(this.fTime1Bound, beginTime));
        this.fSelectionEnd = Math.max(this.fTime0Bound, Math.min(this.fTime1Bound, endTime));
        boolean bl = changed = selectionBegin != this.fSelectionBegin || selectionEnd != this.fSelectionEnd;
        if (ensureVisible) {
            this.ensureVisible(selectionBegin != this.fSelectionBegin ? this.fSelectionBegin : this.fSelectionEnd);
        }
        this.fTimeGraphCtrl.redraw();
        this.fTimeScaleCtrl.redraw();
        this.fMarkerAxisCtrl.redraw();
        this.updateMarkerActions();
        if (time0 != this.fTime0 || time1 != this.fTime1) {
            this.notifyRangeListeners();
        }
        if (doNotify && changed) {
            this.notifyTimeListeners();
        }
    }

    private void ensureVisible(long time) {
        long timeMid = (this.fTime1 - this.fTime0) / 2L;
        if (time < this.fTime0) {
            long dt = this.fTime0 - time + timeMid;
            this.fTime0 -= dt;
            this.fTime1 -= dt;
        } else if (time > this.fTime1) {
            long dt = time - this.fTime1 + timeMid;
            this.fTime0 += dt;
            this.fTime1 += dt;
        }
        if (this.fTime0 < this.fTime0Bound) {
            this.fTime1 = Math.min(this.fTime1Bound, this.fTime1 + (this.fTime0Bound - this.fTime0));
            this.fTime0 = this.fTime0Bound;
        } else if (this.fTime1 > this.fTime1Bound) {
            this.fTime0 = Math.max(this.fTime0Bound, this.fTime0 - (this.fTime1 - this.fTime1Bound));
            this.fTime1 = this.fTime1Bound;
        }
        if (this.fTime1 - this.fTime0 < this.fMinTimeInterval) {
            this.fTime1 = Math.min(this.fTime1Bound, this.fTime0 + this.fMinTimeInterval);
        }
        this.adjustHorizontalScrollBar();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.fSelectedEntry != this.getSelection()) {
            this.fSelectedEntry = this.getSelection();
            this.notifySelectionListeners();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.fSelectedEntry != this.getSelection()) {
            this.fSelectedEntry = this.getSelection();
            this.notifySelectionListeners();
        }
    }

    public void selectNextEvent(boolean extend) {
        this.fTimeGraphCtrl.selectNextEvent(extend);
        this.adjustVerticalScrollBar();
    }

    public void selectPrevEvent(boolean extend) {
        this.fTimeGraphCtrl.selectPrevEvent(extend);
        this.adjustVerticalScrollBar();
    }

    public void selectNextItem() {
        this.fTimeGraphCtrl.selectNextTrace();
        this.adjustVerticalScrollBar();
    }

    public void selectPrevItem() {
        this.fTimeGraphCtrl.selectPrevTrace();
        this.adjustVerticalScrollBar();
    }

    public void setLegendProvider(ITimeGraphLegendProvider legendProvider) {
        this.fLegendProvider = legendProvider;
    }

    public void showLegend() {
        Control tgControl = this.getControl();
        if (tgControl == null || tgControl.isDisposed()) {
            return;
        }
        ITimeGraphLegendProvider legendProvider = this.fLegendProvider;
        if (legendProvider == null) {
            TimeGraphLegend.open(tgControl.getShell(), this.getTimeGraphProvider());
        } else {
            legendProvider.showLegend(tgControl.getShell(), this.getTimeGraphProvider());
        }
    }

    public void zoomIn() {
        this.fTimeGraphCtrl.zoomIn();
    }

    public void zoomOut() {
        this.fTimeGraphCtrl.zoomOut();
    }

    private String getPreferenceString(String string) {
        return this.getViewTypeStr() + "." + string;
    }

    public void addSelectionListener(ITimeGraphSelectionListener listener) {
        this.fSelectionListeners.add(listener);
    }

    public void removeSelectionListener(ITimeGraphSelectionListener listener) {
        this.fSelectionListeners.remove(listener);
    }

    private void notifySelectionListeners() {
        if (this.fListenerNotifier == null) {
            this.fListenerNotifier = new ListenerNotifier();
            this.fListenerNotifier.start();
        }
        this.fListenerNotifier.selectionChanged();
    }

    private void fireSelectionChanged(ITimeGraphEntry selection) {
        TimeGraphSelectionEvent event = new TimeGraphSelectionEvent(this, selection);
        for (ITimeGraphSelectionListener listener : this.fSelectionListeners) {
            listener.selectionChanged(event);
        }
        StructuredSelection structuredSelection = selection == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)selection);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)structuredSelection));
    }

    public void addTimeListener(ITimeGraphTimeListener listener) {
        this.fTimeListeners.add(listener);
    }

    public void removeTimeListener(ITimeGraphTimeListener listener) {
        this.fTimeListeners.remove(listener);
    }

    private void notifyTimeListeners() {
        if (this.fListenerNotifier == null) {
            this.fListenerNotifier = new ListenerNotifier();
            this.fListenerNotifier.start();
        }
        this.fListenerNotifier.timeSelected();
    }

    private void fireTimeSelected(long startTime, long endTime) {
        TimeGraphTimeEvent event = new TimeGraphTimeEvent(this, startTime, endTime);
        for (ITimeGraphTimeListener listener : this.fTimeListeners) {
            listener.timeSelected(event);
        }
    }

    public void addRangeListener(ITimeGraphRangeListener listener) {
        this.fRangeListeners.add(listener);
    }

    public void removeRangeListener(ITimeGraphRangeListener listener) {
        this.fRangeListeners.remove(listener);
    }

    private void notifyRangeListeners() {
        if (this.fListenerNotifier == null) {
            this.fListenerNotifier = new ListenerNotifier();
            this.fListenerNotifier.start();
        }
        this.fListenerNotifier.timeRangeUpdated();
    }

    private void fireTimeRangeUpdated(long startTime, long endTime) {
        if (startTime != this.fTime0ExtSynch || endTime != this.fTime1ExtSynch) {
            TimeGraphRangeUpdateEvent event = new TimeGraphRangeUpdateEvent(this, startTime, endTime);
            for (ITimeGraphRangeListener listener : this.fRangeListeners) {
                listener.timeRangeUpdated(event);
            }
            this.updateExtSynchValues();
        }
    }

    public void addBookmarkListener(ITimeGraphBookmarkListener listener) {
        this.fBookmarkListeners.add(listener);
    }

    public void removeBookmarkListener(ITimeGraphBookmarkListener listener) {
        this.fBookmarkListeners.remove(listener);
    }

    private void fireBookmarkAdded(IMarkerEvent bookmark) {
        TimeGraphBookmarkEvent event = new TimeGraphBookmarkEvent(this, bookmark);
        for (ITimeGraphBookmarkListener listener : this.fBookmarkListeners) {
            listener.bookmarkAdded(event);
        }
    }

    private void fireBookmarkRemoved(IMarkerEvent bookmark) {
        TimeGraphBookmarkEvent event = new TimeGraphBookmarkEvent(this, bookmark);
        for (ITimeGraphBookmarkListener listener : this.fBookmarkListeners) {
            listener.bookmarkRemoved(event);
        }
    }

    public void setBookmarks(List<IMarkerEvent> bookmarks) {
        this.fBookmarks.clear();
        if (bookmarks != null) {
            this.fBookmarks.addAll(bookmarks);
        }
        this.updateMarkerList();
        this.updateMarkerActions();
    }

    public List<IMarkerEvent> getBookmarks() {
        return Collections.unmodifiableList(this.fBookmarks);
    }

    public void setMarkerCategories(List<String> categories) {
        this.fMarkerCategories.clear();
        if (categories != null) {
            this.fMarkerCategories.addAll(categories);
        }
        this.fMarkerCategories.add(IMarkerEvent.BOOKMARKS);
        this.fMarkerAxisCtrl.setMarkerCategories(this.fMarkerCategories);
    }

    @Override
    public void setMarkerCategoryVisible(String category, boolean visible) {
        boolean changed = false;
        changed = visible ? this.fHiddenMarkerCategories.remove(category) : this.fHiddenMarkerCategories.add(category);
        if (changed) {
            this.updateMarkerList();
            this.updateMarkerActions();
            this.getControl().redraw();
            this.fireMarkerCategoriesChanged();
        }
    }

    public boolean isMarkerCategoryVisible(String category) {
        return !this.fHiddenMarkerCategories.contains(category);
    }

    public void setMarkers(List<IMarkerEvent> markers) {
        this.fMarkers.clear();
        if (markers != null) {
            this.fMarkers.addAll(markers);
        }
        this.updateMarkerList();
        this.updateMarkerActions();
    }

    public List<IMarkerEvent> getMarkers() {
        return Collections.unmodifiableList(this.fMarkers);
    }

    public void addMarkerListener(ITimeGraphMarkerListener listener) {
        this.fMarkerListeners.add(listener);
    }

    public void removeMarkerListener(ITimeGraphMarkerListener listener) {
        this.fMarkerListeners.remove(listener);
    }

    private void fireMarkerCategoriesChanged() {
        for (ITimeGraphMarkerListener listener : this.fMarkerListeners) {
            listener.markerCategoriesChanged();
        }
    }

    public void setSelectedEvent(ITimeEvent event, Object source) {
        if (event == null || source == this) {
            return;
        }
        this.fSelectedEntry = event.getEntry();
        this.fTimeGraphCtrl.selectItem(this.fSelectedEntry, false);
        this.setSelectedTimeInt(event.getTime(), true, true);
        this.adjustVerticalScrollBar();
    }

    public void setSelectedTraceTime(ITimeGraphEntry trace, long time, Object source) {
        if (trace == null || source == this) {
            return;
        }
        this.fSelectedEntry = trace;
        this.fTimeGraphCtrl.selectItem(trace, false);
        this.setSelectedTimeInt(time, true, true);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        ITimeGraphEntry entry;
        if (this.fListenerNotifier != null && this.fListenerNotifier.hasSelectionChanged()) {
            return;
        }
        Object element = selection;
        if (selection instanceof IStructuredSelection) {
            element = ((IStructuredSelection)selection).getFirstElement();
        }
        if (!(element instanceof ITimeGraphEntry)) {
            return;
        }
        this.fSelectedEntry = entry = (ITimeGraphEntry)element;
        this.fTimeGraphCtrl.selectItem(entry, false, reveal);
        this.adjustVerticalScrollBar();
    }

    public void setSelectVisTimeWindow(long time0, long time1, Object source) {
        if (source == this) {
            return;
        }
        this.setStartFinishTimeInt(time0, time1);
        this.updateExtSynchValues();
    }

    private void updateExtSynchValues() {
        this.fTime0ExtSynch = this.fTime0;
        this.fTime1ExtSynch = this.fTime1;
    }

    @Override
    public Utils.TimeFormat getTimeFormat() {
        return this.fTimeFormat;
    }

    public void setTimeFormat(Utils.TimeFormat tf) {
        this.fTimeFormat = tf;
        this.fTimeDataProvider = tf == Utils.TimeFormat.CYCLES ? new TimeDataProviderCyclesConverter(this, this.fClockFrequency) : this;
        this.fTimeScaleCtrl.setTimeProvider(this.fTimeDataProvider);
        if (this.fToolTipHandler != null) {
            this.fToolTipHandler.setTimeProvider(this.fTimeDataProvider);
        }
    }

    public void setClockFrequency(long clockFrequency) {
        this.fClockFrequency = clockFrequency;
        if (this.fTimeFormat == Utils.TimeFormat.CYCLES) {
            this.fTimeDataProvider = new TimeDataProviderCyclesConverter(this, this.fClockFrequency);
            this.fTimeScaleCtrl.setTimeProvider(this.fTimeDataProvider);
            if (this.fToolTipHandler != null) {
                this.fToolTipHandler.setTimeProvider(this.fTimeDataProvider);
            }
        }
    }

    public int getBorderWidth() {
        return this.fBorderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        if (borderWidth > -1) {
            this.fBorderWidth = borderWidth;
            GridLayout gl = (GridLayout)this.fTimeAlignedComposite.getLayout();
            gl.marginHeight = borderWidth;
        }
    }

    public int getHeaderHeight() {
        return this.fTimeScaleHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        if (headerHeight > -1) {
            this.fTimeScaleHeight = headerHeight;
            this.fTimeScaleCtrl.setHeight(headerHeight);
        }
    }

    public int getItemHeight() {
        if (this.fTimeGraphCtrl != null) {
            return this.fTimeGraphCtrl.getItemHeight();
        }
        return 0;
    }

    public void setItemHeight(int rowHeight) {
        if (this.fTimeGraphCtrl != null) {
            this.fTimeGraphCtrl.setItemHeight(rowHeight);
        }
    }

    public void setMinimumItemWidth(int width) {
        if (this.fTimeGraphCtrl != null) {
            this.fTimeGraphCtrl.setMinimumItemWidth(width);
        }
    }

    public void setNameWidthPref(int width) {
        this.fNameWidthPref = width;
        if (width == 0) {
            this.fMinNameWidth = 0;
            this.fNameWidth = 0;
        }
    }

    public int getNameWidthPref(int width) {
        return this.fNameWidthPref;
    }

    public void setLabelsVisible(boolean visible) {
        this.fTimeGraphCtrl.setLabelsVisible(visible);
    }

    @Override
    public Control getControl() {
        return this.fTimeAlignedComposite;
    }

    public TimeGraphControl getTimeGraphControl() {
        return this.fTimeGraphCtrl;
    }

    public Tree getTree() {
        return this.fTree;
    }

    public void setColumns(String[] columnNames) {
        this.fTimeGraphCtrl.setColumns(columnNames);
    }

    public TimeGraphScale getTimeGraphScale() {
        return this.fTimeScaleCtrl;
    }

    public void setTimeGraphScaleVisible(boolean visible) {
        TimeGraphViewer.setControlVisible((Control)this.fTree, visible);
        TimeGraphViewer.setControlVisible((Control)this.fTimeScaleCtrl, visible);
        TimeGraphViewer.setControlVisible((Control)this.fFirstRowFiller, visible);
        this.fTimeAlignedComposite.requestLayout();
    }

    public void setMarkerAxisControlVisible(boolean visible) {
        TimeGraphViewer.setControlVisible((Control)this.fMarkerAxisCtrl, visible);
        this.fTimeAlignedComposite.requestLayout();
    }

    public void setHorizontalScrollBarVisible(boolean visible) {
        TimeGraphViewer.setControlVisible((Control)this.fLastRowLeftFiller, visible);
        TimeGraphViewer.setControlVisible((Control)this.fHorizontalScrollBar, visible);
        TimeGraphViewer.setControlVisible((Control)this.fLastRowRightFiller, visible);
        this.fTimeAlignedComposite.requestLayout();
    }

    private static void setControlVisible(Control control, boolean visible) {
        GridData gridData = (GridData)control.getLayoutData();
        gridData.exclude = !visible;
        control.setVisible(visible);
    }

    public Composite getTimeAlignedComposite() {
        return this.fTimeAlignedComposite;
    }

    public int getXForTime(long time) {
        return this.fTimeGraphCtrl.getXForTime(time);
    }

    public long getTimeAtX(int x) {
        return this.fTimeGraphCtrl.getTimeAtX(x);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fTimeGraphCtrl;
    }

    public void waitCursor(boolean waitInd) {
        this.fTimeGraphCtrl.waitCursor(waitInd);
    }

    public Slider getHorizontalBar() {
        return this.fHorizontalScrollBar;
    }

    public Slider getVerticalBar() {
        return this.fVerticalScrollBar;
    }

    public void setTopIndex(int index) {
        this.fTimeGraphCtrl.setTopIndex(index);
        this.adjustVerticalScrollBar();
    }

    public int getTopIndex() {
        return this.fTimeGraphCtrl.getTopIndex();
    }

    public void setAutoExpandLevel(int level) {
        this.fTimeGraphCtrl.setAutoExpandLevel(level);
    }

    public int getAutoExpandLevel() {
        return this.fTimeGraphCtrl.getAutoExpandLevel();
    }

    public boolean getExpandedState(ITimeGraphEntry entry) {
        return this.fTimeGraphCtrl.getExpandedState(entry);
    }

    public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
        this.fTimeGraphCtrl.setExpandedState(entry, expanded);
        this.adjustVerticalScrollBar();
    }

    public void setExpandedState(Iterable<ITimeGraphEntry> entries, boolean expanded) {
        this.fTimeGraphCtrl.setExpandedState(entries, expanded);
        this.adjustVerticalScrollBar();
    }

    public void collapseAll() {
        this.fTimeGraphCtrl.collapseAll();
        this.adjustVerticalScrollBar();
    }

    public void expandAll() {
        this.fTimeGraphCtrl.expandAll();
        this.adjustVerticalScrollBar();
    }

    public void selectAndReveal(@NonNull ITimeGraphEntry entry) {
        ITimeGraphEntry parent = entry.getParent();
        if (parent != null) {
            this.fTimeGraphCtrl.setExpandedState(parent, true);
        }
        this.fSelectedEntry = entry;
        this.fTimeGraphCtrl.selectItem(entry, false);
        this.adjustVerticalScrollBar();
    }

    public int getExpandedElementCount() {
        return this.fTimeGraphCtrl.getExpandedElementCount();
    }

    public ITimeGraphEntry[] getExpandedElements() {
        return this.fTimeGraphCtrl.getExpandedElements();
    }

    public @NonNull Set<@NonNull ITimeGraphEntry> getAllCollapsedElements() {
        ITimeGraphEntry[] elements;
        @NonNull HashSet<@NonNull ITimeGraphEntry> collapsedEntries = new HashSet<ITimeGraphEntry>();
        ITimeGraphEntry[] iTimeGraphEntryArray = elements = this.fTimeGraphContentProvider.getElements(this.getInput());
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ITimeGraphEntry entry = iTimeGraphEntryArray[n2];
            if (entry != null) {
                this.getAllCollapsedElements(entry, collapsedEntries);
            }
            ++n2;
        }
        return collapsedEntries;
    }

    private void getAllCollapsedElements(@NonNull ITimeGraphEntry entry, @NonNull Set<@NonNull ITimeGraphEntry> collapsedEntries) {
        if (entry.hasChildren() && !this.fTimeGraphCtrl.getExpandedState(entry)) {
            collapsedEntries.add(entry);
        }
        for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
            this.getAllCollapsedElements(iTimeGraphEntry, collapsedEntries);
        }
    }

    public void addTreeListener(ITimeGraphTreeListener listener) {
        this.fTimeGraphCtrl.addTreeListener(listener);
    }

    public void removeTreeListener(ITimeGraphTreeListener listener) {
        this.fTimeGraphCtrl.removeTreeListener(listener);
    }

    public void addViewerFilterListener(ITimeGraphViewerFilterListener listener) {
        this.fTimeGraphCtrl.addViewerFilterListener(listener);
    }

    public void removeViewerFilterListener(ITimeGraphViewerFilterListener listener) {
        this.fTimeGraphCtrl.removeViewerFilterListener(listener);
    }

    public Action getResetScaleAction() {
        if (this.fResetScaleAction == null) {
            this.fResetScaleAction = ResetUtil.createResetAction(this);
        }
        return this.fResetScaleAction;
    }

    public Action getShowLegendAction() {
        if (this.fShowLegendAction == null) {
            this.fShowLegendAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.showLegend();
                }
            };
            this.fShowLegendAction.setText(Messages.TmfTimeGraphViewer_LegendActionNameText);
            this.fShowLegendAction.setToolTipText(Messages.TmfTimeGraphViewer_LegendActionToolTipText);
            this.fShowLegendAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/show_legend.gif"));
        }
        return this.fShowLegendAction;
    }

    public Action getNextEventAction() {
        if (this.fNextEventAction == null) {
            this.fNextEventAction = new Action(){

                public void runWithEvent(Event event) {
                    boolean extend = (event.stateMask & 0x20000) != 0;
                    TimeGraphViewer.this.selectNextEvent(extend);
                }
            };
            this.fNextEventAction.setText(Messages.TmfTimeGraphViewer_NextStateChangeActionNameText);
            this.fNextEventAction.setToolTipText(Messages.TmfTimeGraphViewer_NextStateChangeActionToolTipText);
            this.fNextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_event.gif"));
        }
        return this.fNextEventAction;
    }

    public Action getPreviousEventAction() {
        if (this.fPrevEventAction == null) {
            this.fPrevEventAction = new Action(){

                public void runWithEvent(Event event) {
                    boolean extend = (event.stateMask & 0x20000) != 0;
                    TimeGraphViewer.this.selectPrevEvent(extend);
                }
            };
            this.fPrevEventAction.setText(Messages.TmfTimeGraphViewer_PreviousStateChangeActionNameText);
            this.fPrevEventAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousStateChangeActionToolTipText);
            this.fPrevEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_event.gif"));
        }
        return this.fPrevEventAction;
    }

    public Action getNextItemAction() {
        if (this.fNextItemAction == null) {
            this.fNextItemAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.selectNextItem();
                }
            };
            this.fNextItemAction.setText(Messages.TmfTimeGraphViewer_NextItemActionNameText);
            this.fNextItemAction.setToolTipText(Messages.TmfTimeGraphViewer_NextItemActionToolTipText);
            this.fNextItemAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_menu.gif"));
        }
        return this.fNextItemAction;
    }

    public Action getPreviousItemAction() {
        if (this.fPreviousItemAction == null) {
            this.fPreviousItemAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.selectPrevItem();
                }
            };
            this.fPreviousItemAction.setText(Messages.TmfTimeGraphViewer_PreviousItemActionNameText);
            this.fPreviousItemAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousItemActionToolTipText);
            this.fPreviousItemAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_menu.gif"));
        }
        return this.fPreviousItemAction;
    }

    public Action getZoomInAction() {
        if (this.fZoomInAction == null) {
            this.fZoomInAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.zoomIn();
                }
            };
            this.fZoomInAction.setText(Messages.TmfTimeGraphViewer_ZoomInActionNameText);
            this.fZoomInAction.setToolTipText(Messages.TmfTimeGraphViewer_ZoomInActionToolTipText);
            this.fZoomInAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomin_nav.gif"));
        }
        return this.fZoomInAction;
    }

    public Action getZoomOutAction() {
        if (this.fZoomOutAction == null) {
            this.fZoomOutAction = new Action(){

                public void run() {
                    TimeGraphViewer.this.zoomOut();
                }
            };
            this.fZoomOutAction.setText(Messages.TmfTimeGraphViewer_ZoomOutActionNameText);
            this.fZoomOutAction.setToolTipText(Messages.TmfTimeGraphViewer_ZoomOutActionToolTipText);
            this.fZoomOutAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/zoomout_nav.gif"));
        }
        return this.fZoomOutAction;
    }

    public Action getHideArrowsAction(final IDialogSettings dialogSettings) {
        if (this.fHideArrowsAction == null) {
            this.fHideArrowsAction = new Action(Messages.TmfTimeGraphViewer_HideArrowsActionNameText, 2){

                public void run() {
                    boolean hideArrows = TimeGraphViewer.this.fHideArrowsAction.isChecked();
                    TimeGraphViewer.this.fTimeGraphCtrl.hideArrows(hideArrows);
                    TimeGraphViewer.this.refresh();
                    if (dialogSettings != null) {
                        dialogSettings.put(TimeGraphViewer.HIDE_ARROWS_KEY, hideArrows);
                    }
                    if (TimeGraphViewer.this.fFollowArrowFwdAction != null) {
                        TimeGraphViewer.this.fFollowArrowFwdAction.setEnabled(!hideArrows);
                    }
                    if (TimeGraphViewer.this.fFollowArrowBwdAction != null) {
                        TimeGraphViewer.this.fFollowArrowBwdAction.setEnabled(!hideArrows);
                    }
                }
            };
            this.fHideArrowsAction.setToolTipText(Messages.TmfTimeGraphViewer_HideArrowsActionToolTipText);
            this.fHideArrowsAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/hide_arrows.gif"));
            if (dialogSettings != null) {
                boolean hideArrows = dialogSettings.getBoolean(HIDE_ARROWS_KEY);
                this.fTimeGraphCtrl.hideArrows(hideArrows);
                this.fHideArrowsAction.setChecked(hideArrows);
                if (this.fFollowArrowFwdAction != null) {
                    this.fFollowArrowFwdAction.setEnabled(!hideArrows);
                }
                if (this.fFollowArrowBwdAction != null) {
                    this.fFollowArrowBwdAction.setEnabled(!hideArrows);
                }
            }
        }
        return this.fHideArrowsAction;
    }

    public Action getFollowArrowFwdAction() {
        if (this.fFollowArrowFwdAction == null) {
            this.fFollowArrowFwdAction = new Action(){

                public void runWithEvent(Event event) {
                    boolean extend = (event.stateMask & 0x20000) != 0;
                    TimeGraphViewer.this.fTimeGraphCtrl.followArrowFwd(extend);
                    TimeGraphViewer.this.adjustVerticalScrollBar();
                }
            };
            this.fFollowArrowFwdAction.setText(Messages.TmfTimeGraphViewer_FollowArrowForwardActionNameText);
            this.fFollowArrowFwdAction.setToolTipText(Messages.TmfTimeGraphViewer_FollowArrowForwardActionToolTipText);
            this.fFollowArrowFwdAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/follow_arrow_fwd.gif"));
            if (this.fHideArrowsAction != null) {
                this.fFollowArrowFwdAction.setEnabled(!this.fHideArrowsAction.isChecked());
            }
        }
        return this.fFollowArrowFwdAction;
    }

    public Action getFollowArrowBwdAction() {
        if (this.fFollowArrowBwdAction == null) {
            this.fFollowArrowBwdAction = new Action(){

                public void runWithEvent(Event event) {
                    boolean extend = (event.stateMask & 0x20000) != 0;
                    TimeGraphViewer.this.fTimeGraphCtrl.followArrowBwd(extend);
                    TimeGraphViewer.this.adjustVerticalScrollBar();
                }
            };
            this.fFollowArrowBwdAction.setText(Messages.TmfTimeGraphViewer_FollowArrowBackwardActionNameText);
            this.fFollowArrowBwdAction.setToolTipText(Messages.TmfTimeGraphViewer_FollowArrowBackwardActionToolTipText);
            this.fFollowArrowBwdAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/follow_arrow_bwd.gif"));
            if (this.fHideArrowsAction != null) {
                this.fFollowArrowBwdAction.setEnabled(!this.fHideArrowsAction.isChecked());
            }
        }
        return this.fFollowArrowBwdAction;
    }

    public ShowFilterDialogAction getShowFilterDialogAction() {
        if (this.fShowFilterDialogAction == null) {
            this.fShowFilterDialogAction = new ShowFilterDialogAction(this);
        }
        return this.fShowFilterDialogAction;
    }

    public Action getToggleBookmarkAction() {
        if (this.fToggleBookmarkAction == null) {
            this.fToggleBookmarkAction = new Action(){

                public void runWithEvent(Event event) {
                    IMarkerEvent selectedBookmark = TimeGraphViewer.this.getBookmarkAtSelection();
                    if (selectedBookmark == null) {
                        long time = Math.min(TimeGraphViewer.this.fSelectionBegin, TimeGraphViewer.this.fSelectionEnd);
                        long duration = Math.max(TimeGraphViewer.this.fSelectionBegin, TimeGraphViewer.this.fSelectionEnd) - time;
                        AddBookmarkDialog dialog = new AddBookmarkDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null);
                        if (dialog.open() == 0) {
                            String label = dialog.getValue();
                            RGBA rgba = dialog.getColorValue();
                            boolean foreground = dialog.getForeground();
                            MarkerEvent bookmark = new MarkerEvent(null, time, duration, IMarkerEvent.BOOKMARKS, rgba, label, foreground);
                            TimeGraphViewer.this.fBookmarks.add(bookmark);
                            TimeGraphViewer.this.updateMarkerList();
                            TimeGraphViewer.this.updateMarkerActions();
                            TimeGraphViewer.this.getControl().redraw();
                            TimeGraphViewer.this.fireBookmarkAdded(bookmark);
                        }
                    } else {
                        TimeGraphViewer.this.fBookmarks.remove(selectedBookmark);
                        TimeGraphViewer.this.updateMarkerList();
                        TimeGraphViewer.this.updateMarkerActions();
                        TimeGraphViewer.this.getControl().redraw();
                        TimeGraphViewer.this.fireBookmarkRemoved(selectedBookmark);
                    }
                }
            };
            this.fToggleBookmarkAction.setText(Messages.TmfTimeGraphViewer_BookmarkActionAddText);
            this.fToggleBookmarkAction.setToolTipText(Messages.TmfTimeGraphViewer_BookmarkActionAddText);
            this.fToggleBookmarkAction.setImageDescriptor(ADD_BOOKMARK);
        }
        return this.fToggleBookmarkAction;
    }

    public Action getNextMarkerAction() {
        if (this.fNextMarkerAction == null) {
            this.fNextMarkerAction = new Action(Messages.TmfTimeGraphViewer_NextMarkerActionText, 4){

                public void runWithEvent(Event event) {
                    boolean extend;
                    boolean bl = extend = (event.stateMask & 0x20000) != 0;
                    if (extend) {
                        TimeGraphViewer.this.extendToNextMarker();
                    } else {
                        TimeGraphViewer.this.selectNextMarker();
                    }
                }
            };
            this.fNextMarkerAction.setToolTipText(Messages.TmfTimeGraphViewer_NextMarkerActionText);
            this.fNextMarkerAction.setImageDescriptor(NEXT_BOOKMARK);
            this.fNextMarkerAction.setMenuCreator(new IMenuCreator(){
                Menu menu = null;

                public void dispose() {
                    if (this.menu != null) {
                        this.menu.dispose();
                        this.menu = null;
                    }
                }

                public Menu getMenu(Control parent) {
                    if (this.menu != null) {
                        this.menu.dispose();
                    }
                    this.menu = new Menu(parent);
                    for (String category : TimeGraphViewer.this.fMarkerCategories) {
                        Action action = new Action(category, 2){

                            public void runWithEvent(Event event) {
                                if (this.isChecked()) {
                                    (this).TimeGraphViewer.this.fSkippedMarkerCategories.remove(this.getText());
                                } else {
                                    (this).TimeGraphViewer.this.fSkippedMarkerCategories.add(this.getText());
                                }
                                TimeGraphViewer.this.updateMarkerActions();
                            }
                        };
                        action.setEnabled(!TimeGraphViewer.this.fHiddenMarkerCategories.contains(category));
                        action.setChecked(action.isEnabled() && !TimeGraphViewer.this.fSkippedMarkerCategories.contains(category));
                        new ActionContributionItem((IAction)action).fill(this.menu, -1);
                    }
                    return this.menu;
                }

                public Menu getMenu(Menu parent) {
                    return null;
                }
            });
        }
        return this.fNextMarkerAction;
    }

    public Action getPreviousMarkerAction() {
        if (this.fPreviousMarkerAction == null) {
            this.fPreviousMarkerAction = new Action(){

                public void runWithEvent(Event event) {
                    boolean extend;
                    boolean bl = extend = (event.stateMask & 0x20000) != 0;
                    if (extend) {
                        TimeGraphViewer.this.extendToPrevMarker();
                    } else {
                        TimeGraphViewer.this.selectPrevMarker();
                    }
                }
            };
            this.fPreviousMarkerAction.setText(Messages.TmfTimeGraphViewer_PreviousMarkerActionText);
            this.fPreviousMarkerAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousMarkerActionText);
            this.fPreviousMarkerAction.setImageDescriptor(PREVIOUS_BOOKMARK);
        }
        return this.fPreviousMarkerAction;
    }

    public MenuManager getMarkersMenu() {
        if (this.fMarkersMenu == null) {
            this.fMarkersMenu = new MenuManager(Messages.TmfTimeGraphViewer_ShowMarkersMenuText);
            this.fMarkersMenu.setRemoveAllWhenShown(true);
            this.fMarkersMenu.addMenuListener(manager -> {
                for (String category : this.fMarkerCategories) {
                    Action action = new Action(category, 2){

                        public void runWithEvent(Event event) {
                            TimeGraphViewer.this.setMarkerCategoryVisible(this.getText(), this.isChecked());
                        }
                    };
                    action.setChecked(!this.fHiddenMarkerCategories.contains(category));
                    manager.add((IAction)action);
                }
            });
        }
        return this.fMarkersMenu;
    }

    public MenuManager getGridlinesMenu() {
        if (this.fGridlinesMenu == null) {
            final IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TimeGraphControl.class.getName());
            this.fGridlinesMenu = new MenuManager(Messages.TmfTimeGraphViewer_ShowGridlinesMenuText);
            this.fHorizontalAction = new Action(Messages.TmfTimeGraphViewer_ShowGridlinesHorizontalActionText, 2){

                public void run() {
                    boolean showHorizontal = this.isChecked();
                    TimeGraphViewer.this.fTimeGraphCtrl.setMidLinesVisible(showHorizontal);
                    settings.put(TimeGraphViewer.HIDE_GRIDLINES_HORIZONTAL_KEY, !showHorizontal);
                }
            };
            this.fHorizontalAction.setChecked(!settings.getBoolean(HIDE_GRIDLINES_HORIZONTAL_KEY));
            this.fTimeGraphCtrl.setMidLinesVisible(this.fHorizontalAction.isChecked());
            this.fGridlinesMenu.add((IAction)this.fHorizontalAction);
            this.fVerticalAction = new Action(Messages.TmfTimeGraphViewer_ShowGridlinesVerticalActionText, 2){

                public void run() {
                    boolean showVertical = this.isChecked();
                    TimeGraphViewer.this.fTimeGraphCtrl.setGridLinesVisible(showVertical);
                    settings.put(TimeGraphViewer.HIDE_GRIDLINES_VERTICAL_KEY, !showVertical);
                }
            };
            this.fVerticalAction.setChecked(!settings.getBoolean(HIDE_GRIDLINES_VERTICAL_KEY));
            this.fTimeGraphCtrl.setGridLinesVisible(this.fVerticalAction.isChecked());
            this.fGridlinesMenu.add((IAction)this.fVerticalAction);
        }
        return this.fGridlinesMenu;
    }

    private void selectNextMarker() {
        List<IMarkerEvent> markers = this.getTimeGraphControl().getMarkers();
        if (markers == null) {
            return;
        }
        for (IMarkerEvent marker : markers) {
            long time = Math.min(this.fSelectionBegin, this.fSelectionEnd);
            long duration = Math.max(this.fSelectionBegin, this.fSelectionEnd) - time;
            if (marker.getTime() <= time && (marker.getTime() != time || marker.getDuration() <= duration) || this.fSkippedMarkerCategories.contains(marker.getCategory())) continue;
            this.setSelectionRangeNotify(marker.getTime(), marker.getTime() + marker.getDuration(), false);
            this.ensureVisible(marker.getTime());
            this.notifyRangeListeners();
            this.fTimeGraphCtrl.updateStatusLine();
            return;
        }
    }

    private void selectPrevMarker() {
        List<IMarkerEvent> markers = this.getTimeGraphControl().getMarkers();
        if (markers == null) {
            return;
        }
        long time = Math.min(this.fSelectionBegin, this.fSelectionEnd);
        long duration = Math.max(this.fSelectionBegin, this.fSelectionEnd) - time;
        int i = markers.size() - 1;
        while (i >= 0) {
            IMarkerEvent marker = markers.get(i);
            if ((marker.getTime() < time || marker.getTime() == time && marker.getDuration() < duration) && !this.fSkippedMarkerCategories.contains(marker.getCategory())) {
                this.setSelectionRangeNotify(marker.getTime(), marker.getTime() + marker.getDuration(), false);
                this.ensureVisible(marker.getTime());
                this.notifyRangeListeners();
                this.fTimeGraphCtrl.updateStatusLine();
                return;
            }
            --i;
        }
    }

    private void extendToNextMarker() {
        List<IMarkerEvent> markers = this.getTimeGraphControl().getMarkers();
        if (markers == null) {
            return;
        }
        ITimeEvent nextMarker = null;
        for (IMarkerEvent marker : markers) {
            if (marker.getTime() + marker.getDuration() <= this.fSelectionEnd || this.fSkippedMarkerCategories.contains(marker.getCategory()) || nextMarker != null && marker.getTime() + marker.getDuration() >= nextMarker.getTime() + nextMarker.getDuration()) continue;
            nextMarker = marker;
        }
        if (nextMarker != null) {
            this.setSelectionRangeNotify(this.fSelectionBegin, nextMarker.getTime() + nextMarker.getDuration(), true);
            this.fTimeGraphCtrl.updateStatusLine();
        }
    }

    private void extendToPrevMarker() {
        List<IMarkerEvent> markers = this.getTimeGraphControl().getMarkers();
        if (markers == null) {
            return;
        }
        int i = markers.size() - 1;
        while (i >= 0) {
            IMarkerEvent marker = markers.get(i);
            if (marker.getTime() < this.fSelectionEnd && !this.fSkippedMarkerCategories.contains(marker.getCategory())) {
                this.setSelectionRangeNotify(this.fSelectionBegin, marker.getTime(), true);
                this.fTimeGraphCtrl.updateStatusLine();
                return;
            }
            --i;
        }
    }

    private IMarkerEvent getBookmarkAtSelection() {
        long time = Math.min(this.fSelectionBegin, this.fSelectionEnd);
        long duration = Math.max(this.fSelectionBegin, this.fSelectionEnd) - time;
        for (IMarkerEvent bookmark : this.fBookmarks) {
            if (bookmark.getTime() != time || bookmark.getDuration() != duration) continue;
            return bookmark;
        }
        return null;
    }

    private void updateMarkerActions() {
        List<IMarkerEvent> markers;
        boolean enabled;
        boolean bl = enabled = this.fTime0Bound != -1L || this.fTime1Bound != -1L;
        if (this.fToggleBookmarkAction != null) {
            if (this.getBookmarkAtSelection() != null) {
                this.fToggleBookmarkAction.setText(Messages.TmfTimeGraphViewer_BookmarkActionRemoveText);
                this.fToggleBookmarkAction.setToolTipText(Messages.TmfTimeGraphViewer_BookmarkActionRemoveText);
                this.fToggleBookmarkAction.setImageDescriptor(REMOVE_BOOKMARK);
            } else {
                this.fToggleBookmarkAction.setText(Messages.TmfTimeGraphViewer_BookmarkActionAddText);
                this.fToggleBookmarkAction.setToolTipText(Messages.TmfTimeGraphViewer_BookmarkActionAddText);
                this.fToggleBookmarkAction.setImageDescriptor(ADD_BOOKMARK);
            }
            this.fToggleBookmarkAction.setEnabled(enabled);
        }
        if ((markers = this.getTimeGraphControl().getMarkers()) == null) {
            markers = Collections.emptyList();
        }
        if (this.fPreviousMarkerAction != null) {
            this.fPreviousMarkerAction.setEnabled(enabled && !markers.isEmpty());
        }
        if (this.fNextMarkerAction != null) {
            this.fNextMarkerAction.setEnabled(enabled && !markers.isEmpty());
        }
    }

    private void updateMarkerList() {
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        for (IMarkerEvent marker : this.fMarkers) {
            if (this.fHiddenMarkerCategories.contains(marker.getCategory())) continue;
            markers.add(marker);
        }
        if (!this.fHiddenMarkerCategories.contains(IMarkerEvent.BOOKMARKS)) {
            markers.addAll(this.fBookmarks);
        }
        Collections.sort(markers, new MarkerComparator());
        this.fTimeGraphCtrl.setMarkers(markers);
        this.fMarkerAxisCtrl.setMarkers(markers);
    }

    private void adjustHorizontalScrollBar() {
        long time0 = this.getTime0();
        long time1 = this.getTime1();
        long timeMin = this.getMinTime();
        long timeMax = this.getMaxTime();
        long delta = timeMax - timeMin;
        int timePos = 0;
        int thumb = 0x7FFFFFFE;
        if (delta != 0L) {
            thumb = Math.max(1, (int)(2.147483646E9 * ((double)(time1 - time0) / (double)delta)));
            timePos = (int)(2.147483646E9 * ((double)(time0 - timeMin) / (double)delta));
        }
        this.fHorizontalScrollBar.setValues(timePos, 0, 0x7FFFFFFE, thumb, Math.max(1, thumb / 4), Math.max(2, thumb));
    }

    private void adjustVerticalScrollBar() {
        int expandedElementCount;
        int countPerPage;
        int topIndex = this.fTimeGraphCtrl.getTopIndex();
        if (topIndex + (countPerPage = this.fTimeGraphCtrl.countPerPage()) > (expandedElementCount = this.fTimeGraphCtrl.getExpandedElementCount())) {
            this.fTimeGraphCtrl.setTopIndex(Math.max(0, expandedElementCount - countPerPage));
        }
        int selection = this.fTimeGraphCtrl.getTopIndex();
        int min = 0;
        int max = Math.max(1, expandedElementCount - 1);
        int thumb = Math.min(max, Math.max(1, countPerPage - 1));
        int increment = 1;
        int pageIncrement = Math.max(1, countPerPage);
        this.fVerticalScrollBar.setValues(selection, min, max, thumb, increment, pageIncrement);
    }

    public void addTimeGraphEntryMenuListener(MenuDetectListener listener) {
        this.fTimeGraphCtrl.addTimeGraphEntryMenuListener(listener);
    }

    public void removeTimeGraphEntryMenuListener(MenuDetectListener listener) {
        this.fTimeGraphCtrl.removeTimeGraphEntryMenuListener(listener);
    }

    public void addTimeEventMenuListener(MenuDetectListener listener) {
        this.fTimeGraphCtrl.addTimeEventMenuListener(listener);
    }

    public void removeTimeEventMenuListener(MenuDetectListener listener) {
        this.fTimeGraphCtrl.removeTimeEventMenuListener(listener);
    }

    public void addFilter(@NonNull ViewerFilter filter) {
        this.fTimeGraphCtrl.addFilter(filter);
        this.refresh();
    }

    public void changeFilter(@NonNull ViewerFilter filter) {
        this.fTimeGraphCtrl.changeFilter(filter);
        this.refresh();
    }

    public void removeFilter(@NonNull ViewerFilter filter) {
        this.fTimeGraphCtrl.removeFilter(filter);
        this.refresh();
    }

    public @NonNull ViewerFilter[] getFilters() {
        return this.fTimeGraphCtrl.getFilters();
    }

    public void setFilters(@NonNull ViewerFilter[] filters) {
        this.fTimeGraphCtrl.setFilters(filters);
        this.refresh();
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        return this.fTimeGraphCtrl.getTimeViewAlignmentInfo();
    }

    public int getAvailableWidth(int requestedOffset) {
        int totalWidth = this.fTimeAlignedComposite.getSize().x;
        return Math.min(totalWidth, Math.max(0, totalWidth - requestedOffset - this.fVerticalScrollBar.getSize().x));
    }

    public void performAlign(int offset, int width) {
        this.fTimeGraphCtrl.performAlign(offset);
        int alignmentWidth = width;
        int size = this.fTimeAlignedComposite.getSize().x;
        GridLayout layout = (GridLayout)this.fTimeAlignedComposite.getLayout();
        int marginSize = size - alignmentWidth - offset - this.fVerticalScrollBar.getSize().x;
        layout.marginRight = Math.max(0, marginSize);
        this.fTimeAlignedComposite.layout();
    }

    public void setTimeEventFilterApplied(boolean isFilterApplied) {
        this.getTimeGraphControl().setFilterActive(isFilterApplied);
    }

    public boolean isTimeEventFilterActive() {
        return this.getTimeGraphControl().isFilterActive();
    }

    public void setSavedFilterStatus(boolean hasSavedFilter) {
        this.getTimeGraphControl().setSavedFilterStatus(hasSavedFilter);
    }

    public boolean hasSavedFilters() {
        return this.getTimeGraphControl().hasSavedFilters();
    }

    public void setHideEmptyRowsFilterActive(boolean isHideEmptyRowsFilterActive) {
        this.getTimeGraphControl().setHideEmptyRowsFilterActive(isHideEmptyRowsFilterActive);
    }

    private class ListenerNotifier
    extends Thread {
        private static final long DELAY = 400L;
        private static final long POLLING_INTERVAL = 10L;
        private long fLastUpdateTime = Long.MAX_VALUE;
        private boolean fSelectionChanged = false;
        private boolean fTimeRangeUpdated = false;
        private boolean fTimeSelected = false;

        private ListenerNotifier() {
        }

        @Override
        public void run() {
            while (System.currentTimeMillis() - this.fLastUpdateTime < 400L) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    return;
                }
            }
            Display.getDefault().asyncExec(() -> {
                if (TimeGraphViewer.this.fListenerNotifier != this) {
                    return;
                }
                TimeGraphViewer.this.fListenerNotifier = null;
                if (this.isInterrupted() || TimeGraphViewer.this.fTimeAlignedComposite.isDisposed()) {
                    return;
                }
                if (this.fSelectionChanged) {
                    TimeGraphViewer.this.fireSelectionChanged(TimeGraphViewer.this.fSelectedEntry);
                }
                if (this.fTimeRangeUpdated) {
                    TimeGraphViewer.this.fireTimeRangeUpdated(TimeGraphViewer.this.fTime0, TimeGraphViewer.this.fTime1);
                }
                if (this.fTimeSelected) {
                    TimeGraphViewer.this.fireTimeSelected(TimeGraphViewer.this.fSelectionBegin, TimeGraphViewer.this.fSelectionEnd);
                }
            });
        }

        public void selectionChanged() {
            this.fSelectionChanged = true;
            this.fLastUpdateTime = System.currentTimeMillis();
        }

        public void timeRangeUpdated() {
            this.fTimeRangeUpdated = true;
            this.fLastUpdateTime = System.currentTimeMillis();
        }

        public void timeSelected() {
            this.fTimeSelected = true;
            this.fLastUpdateTime = System.currentTimeMillis();
        }

        public boolean hasSelectionChanged() {
            return this.fSelectionChanged;
        }

        public boolean hasTimeRangeUpdated() {
            return this.fTimeRangeUpdated;
        }

        public boolean hasTimeSelected() {
            return this.fTimeSelected;
        }
    }

    private static final class MarkerComparator
    implements Comparator<IMarkerEvent> {
        private MarkerComparator() {
        }

        @Override
        public int compare(IMarkerEvent o1, IMarkerEvent o2) {
            int res = Long.compare(o1.getTime(), o2.getTime());
            if (res != 0) {
                return res;
            }
            return Long.compare(o1.getDuration(), o2.getDuration());
        }
    }
}

