/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.scripting.core.callstack;

import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTreeGroupBy;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.WeightedTreeUtils;
import org.eclipse.tracecompass.incubator.internal.scripting.core.data.provider.ScriptingDataProviderManager;
import org.eclipse.tracecompass.internal.analysis.profiling.core.flamegraph.FlameGraphDataProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.AllGroupDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CallStackScriptingModule {
    @WrapToScript
    public <N, E> IWeightedTreeSet<N, ?, WeightedTree<N>> groupTreesBy(IWeightedTreeProvider<N, E, WeightedTree<N>> provider, int level) {
        IWeightedTreeSet treeSet = provider.getTreeSet();
        IWeightedTreeGroupDescriptor groupDescriptor = CallStackScriptingModule.getGroupDescriptor(provider, level);
        if (groupDescriptor != null) {
            return WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)groupDescriptor, (IWeightedTreeSet)treeSet, provider);
        }
        return treeSet;
    }

    private static <N> @Nullable IWeightedTreeGroupDescriptor getGroupDescriptor(IWeightedTreeProvider<N, ?, WeightedTree<N>> provider, int level) {
        IWeightedTreeGroupDescriptor groupDescriptor = provider.getGroupDescriptor();
        if (level == 0) {
            return AllGroupDescriptor.getInstance();
        }
        int i = 1;
        while (groupDescriptor != null && i < level) {
            groupDescriptor = groupDescriptor.getNextGroup();
            ++i;
        }
        return groupDescriptor;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @WrapToScript
    public <N> @Nullable DifferentialWeightedTreeProvider<N> diffTreeSets(IWeightedTreeProvider<N, ?, WeightedTree<N>> provider, IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> first, IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> second, @ScriptParameter(defaultValue="-1") int minSignificantValue, @ScriptParameter(defaultValue="-1") int maxSignificantValue) {
        @NonNull DifferentialWeightedTreeProvider diffTrees = WeightedTreeUtils.diffTreeSets(provider, first, second);
        if (diffTrees != null && minSignificantValue >= 0) {
            diffTrees.setHeatThresholds(minSignificantValue, maxSignificantValue);
        }
        return diffTrees;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @WrapToScript
    public <N, E, T extends WeightedTree<N>> FlameGraphDataProvider<N, E, T> getFlameGraphDataProvider(ITmfTrace trace, IWeightedTreeProvider<N, E, T> provider, String id) {
        @NonNull @NonNull FlameGraphDataProvider dataProvider = new FlameGraphDataProvider(trace, provider, "org.eclipse.tracecompass.incubator.scripting.dataprovider:" + id);
        ScriptingDataProviderManager.getInstance().registerDataProvider(trace, (ITmfTreeDataProvider<? extends ITmfTreeDataModel>)dataProvider);
        return dataProvider;
    }
}

