/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.views.flamechart;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.FlameChartEntryModel;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.FlameViewPalette;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.flamechart.FlameChartView;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class FlameChartPresentationProvider
extends TimeGraphPresentationProvider {
    private FlameViewPalette fFlameViewPalette = FlameViewPalette.getInstance();
    private Integer fMinimumBarWidth;

    @Deprecated
    public void setCallStackView(FlameChartView view) {
    }

    public String getStateTypeName(ITimeGraphEntry entry) {
        ITimeGraphEntryModel model;
        if (entry instanceof TimeGraphEntry && (model = ((TimeGraphEntry)entry).getModel()) instanceof FlameChartEntryModel) {
            return ((FlameChartEntryModel)model).getEntryType().name();
        }
        return null;
    }

    public StateItem[] getStateTable() {
        return this.fFlameViewPalette.getStateTable();
    }

    public int getStateTableIndex(ITimeEvent event) {
        ITimeGraphEntryModel model;
        TimeGraphEntry entry = (TimeGraphEntry)event.getEntry();
        if (entry != null && (model = entry.getModel()) instanceof FlameChartEntryModel && ((FlameChartEntryModel)model).getEntryType().equals((Object)FlameChartEntryModel.EntryType.KERNEL)) {
            return this.fFlameViewPalette.getControlFlowIndex(event);
        }
        if (event instanceof NamedTimeEvent) {
            return FlameViewPalette.getIndexForValue(((NamedTimeEvent)event).getValue());
        }
        if (event instanceof TimeLinkEvent) {
            return FlameViewPalette.getIndexForValue(((TimeLinkEvent)event).getValue());
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return FlameViewPalette.MULTIPLE_STATE_INDEX;
    }

    public String getEventName(ITimeEvent event) {
        if (event instanceof NamedTimeEvent) {
            return ((NamedTimeEvent)event).getLabel();
        }
        return "";
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (!(event instanceof NamedTimeEvent)) {
            return;
        }
        if (this.fMinimumBarWidth == null) {
            this.fMinimumBarWidth = gc.getFontMetrics().getAverageCharWidth() + gc.stringExtent((String)"\u2026").x;
        }
        if (bounds.width <= this.fMinimumBarWidth) {
            return;
        }
        String label = ((NamedTimeEvent)event).getLabel();
        gc.setForeground(gc.getDevice().getSystemColor(1));
        Utils.drawText((GC)gc, (String)label, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        LinkedHashMap<String, String> retMap = super.getEventHoverToolTipInfo(event, hoverTime);
        if (retMap == null) {
            retMap = new LinkedHashMap<String, String>(1);
        }
        if (!(event instanceof TimeEvent && ((TimeEvent)event).hasValue() && event.getEntry() instanceof TimeGraphEntry)) {
            return retMap;
        }
        TimeGraphEntry entry = (TimeGraphEntry)event.getEntry();
        ITimeGraphDataProvider dataProvider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)entry);
        @NonNull @NonNull @NonNull TmfModelResponse response = dataProvider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(hoverTime, hoverTime, 1, Collections.singletonList(entry.getModel().getId()))), null);
        @NonNull @NonNull Map map = (Map)response.getModel();
        if (map != null) {
            retMap.putAll(map);
        }
        return retMap;
    }

    public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        if (event instanceof TimeLinkEvent) {
            return ImmutableMap.of((Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(0.1f));
        }
        return Collections.emptyMap();
    }
}

