/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.StateValues;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Request;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class DiskWriteModel
extends Disk {
    private final Map<Long, Pair<Request, Integer>> fDriverQueue = new HashMap<Long, Pair<Request, Integer>>();
    private final Map<Long, Pair<Request, Integer>> fWaitingQueue = new HashMap<Long, Pair<Request, Integer>>();
    private final ITmfStateSystemBuilder fSs;
    private final TmfAttributePool fWaitingQueueAttrib;
    private final TmfAttributePool fDriverQueueAttrib;

    public DiskWriteModel(Integer dev, ITmfStateSystemBuilder ss) {
        super(dev, (ITmfStateSystem)ss, ss.getQuarkAbsoluteAndAdd(new String[]{"Disks", String.valueOf(dev)}));
        this.fSs = ss;
        int diskQuark = this.getQuark();
        this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"sectors_written"});
        this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"sectors_read"});
        int wqQuark = this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"Waiting_queue"});
        this.fWaitingQueueAttrib = new TmfAttributePool(this.fSs, Integer.valueOf(wqQuark), TmfAttributePool.QueueType.PRIORITY);
        this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"waitingqueue_length"});
        int dqQuark = this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"Driver_queue"});
        this.fDriverQueueAttrib = new TmfAttributePool(this.fSs, Integer.valueOf(dqQuark), TmfAttributePool.QueueType.PRIORITY);
        this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"driverqueue_length"});
    }

    @Override
    public void setDiskName(String diskname) {
        super.setDiskName(diskname);
        try {
            this.fSs.modifyAttribute(this.fSs.getCurrentEndTime(), (Object)diskname, this.getQuark());
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Cannot set the diskname for disk " + diskname, e);
        }
    }

    public @Nullable Request getWaitingRequest(Long sector) {
        Pair<Request, Integer> reqQuark = this.fWaitingQueue.get(sector);
        if (reqQuark == null) {
            return null;
        }
        return (Request)reqQuark.getFirst();
    }

    private int removeWaitingRequest(long ts, Long sector) {
        Pair<Request, Integer> reqQuark = this.fWaitingQueue.remove(sector);
        if (reqQuark == null) {
            return -2;
        }
        int slotQuark = (Integer)reqQuark.getSecond();
        this.fWaitingQueueAttrib.recycle(slotQuark, ts);
        return slotQuark;
    }

    public int addWaitingRequest(long ts, Request request) {
        int slotQuark = this.insertInWaitingQueue(ts, request);
        this.updateQueuesLength(ts);
        return slotQuark;
    }

    private int insertInWaitingQueue(long ts, Request request) {
        ITmfStateValue statusState = request.getType() == IoOperationType.READ ? StateValues.READING_REQUEST_VALUE : StateValues.WRITING_REQUEST_VALUE;
        int slotQuark = this.fWaitingQueueAttrib.getAvailable();
        try {
            this.fSs.modifyAttribute(ts, statusState.unboxValue(), slotQuark);
            int currentRequestQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Current_request"});
            this.fSs.modifyAttribute(ts, (Object)request.getSector(), currentRequestQuark);
            int requestSizeQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Request_size"});
            this.fSs.modifyAttribute(ts, (Object)request.getNrSector(), requestSizeQuark);
            int mergedInQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"merged_in"});
            this.fSs.modifyAttribute(ts, null, mergedInQuark);
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error inserting request", e);
        }
        this.fWaitingQueue.put(request.getSector(), (Pair<Request, Integer>)new Pair((Object)request, (Object)slotQuark));
        return slotQuark;
    }

    public int updateWaitingRequest(long ts, Request request, Long initialSector) {
        Pair<Request, Integer> reqQuark = this.fWaitingQueue.get(initialSector);
        if (reqQuark == null) {
            return this.addWaitingRequest(ts, request);
        }
        if (!initialSector.equals(request.getSector())) {
            this.fWaitingQueue.remove(initialSector);
            this.fWaitingQueue.put(request.getSector(), reqQuark);
        }
        int slotQuark = (Integer)reqQuark.getSecond();
        try {
            int currentRequestQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Current_request"});
            this.fSs.modifyAttribute(ts, (Object)request.getSector(), currentRequestQuark);
            int requestSizeQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Request_size"});
            this.fSs.modifyAttribute(ts, (Object)request.getNrSector(), requestSizeQuark);
            int mergedInQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"merged_in"});
            this.fSs.modifyAttribute(ts, null, mergedInQuark);
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error inserting request", e);
        }
        this.updateQueuesLength(ts);
        return slotQuark;
    }

    public int getWaitingQueueSize() {
        return this.fWaitingQueue.size();
    }

    public @Nullable Request getDriverRequest(Long sector) {
        Pair<Request, Integer> reqQuark = this.fDriverQueue.get(sector);
        if (reqQuark == null) {
            return null;
        }
        return (Request)reqQuark.getFirst();
    }

    private void removeDriverRequest(long ts, Long sector) {
        Pair<Request, Integer> reqQuark = this.fDriverQueue.remove(sector);
        if (reqQuark == null) {
            return;
        }
        this.fDriverQueueAttrib.recycle(((Integer)reqQuark.getSecond()).intValue(), ts);
    }

    public int issueRequest(long ts, Request request) {
        Integer issuedFromValue = null;
        int fromQuark = this.removeWaitingRequest(ts, request.getSector());
        if (fromQuark != -2) {
            issuedFromValue = Integer.parseInt(this.fSs.getAttributeName(fromQuark));
        }
        ITmfStateValue statusState = request.getType() == IoOperationType.READ ? StateValues.READING_REQUEST_VALUE : StateValues.WRITING_REQUEST_VALUE;
        int slotQuark = this.fDriverQueueAttrib.getAvailable();
        try {
            this.fSs.modifyAttribute(ts, statusState.unboxValue(), slotQuark);
            int currentRequestQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Current_request"});
            this.fSs.modifyAttribute(ts, (Object)request.getSector(), currentRequestQuark);
            int requestSizeQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Request_size"});
            this.fSs.modifyAttribute(ts, (Object)request.getNrSector(), requestSizeQuark);
            int issuedFromQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"issued_from"});
            this.fSs.modifyAttribute(ts, (Object)issuedFromValue, issuedFromQuark);
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error issuing request", e);
        }
        this.fDriverQueue.put(request.getSector(), (Pair<Request, Integer>)new Pair((Object)request, (Object)slotQuark));
        this.updateQueuesLength(ts);
        return slotQuark;
    }

    public void completeRequest(long ts, Request request) {
        try {
            switch (request.getType()) {
                case READ: {
                    int readQuark = this.fSs.getQuarkRelativeAndAdd(this.getQuark(), new String[]{"sectors_read"});
                    StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)this.fSs, (long)ts, (int)readQuark, (int)request.getNrSector());
                    break;
                }
                case WRITE: {
                    int writtenQuark = this.fSs.getQuarkRelativeAndAdd(this.getQuark(), new String[]{"sectors_written"});
                    StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)this.fSs, (long)ts, (int)writtenQuark, (int)request.getNrSector());
                    break;
                }
                default: {
                    throw new IllegalStateException("Complete request: the request cannot be other than READ or WRITE:" + (Object)((Object)request.getType()));
                }
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException e) {
            Activator.getDefault().logError("Error completing request", e);
        }
        this.removeDriverRequest(ts, request.getSector());
        this.updateQueuesLength(ts);
    }

    public void mergeRequests(long ts, Request baseRequest, Request mergedRequest) {
        int mergedQuark = this.removeWaitingRequest(ts, mergedRequest.getSector());
        Long baseSector = baseRequest.getSector();
        baseRequest.mergeRequest(mergedRequest);
        int baseQuark = this.updateWaitingRequest(ts, baseRequest, baseSector);
        if (mergedQuark != -2) {
            try {
                int issuedFromQuark = this.fSs.getQuarkRelativeAndAdd(mergedQuark, new String[]{"merged_in"});
                this.fSs.modifyAttribute(ts, (Object)Integer.parseInt(this.fSs.getAttributeName(baseQuark)), issuedFromQuark);
            }
            catch (StateValueTypeException e) {
                Activator.getDefault().logError("Error adding the merged request information", e);
            }
        }
        this.updateQueuesLength(ts);
    }

    public int getDriverQueueSize() {
        return this.fDriverQueue.size();
    }

    private void updateQueuesLength(long ts) {
        try {
            int fDriverQueueLength = this.fSs.getQuarkRelativeAndAdd(this.getQuark(), new String[]{"driverqueue_length"});
            this.fSs.modifyAttribute(ts, (Object)this.getDriverQueueSize(), fDriverQueueLength);
            int fWaitinQueueLength = this.fSs.getQuarkRelativeAndAdd(this.getQuark(), new String[]{"waitingqueue_length"});
            this.fSs.modifyAttribute(ts, (Object)this.getWaitingQueueSize(), fWaitinQueueLength);
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error updating queues lengths", e);
        }
    }
}

