/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventsTable;
import org.osgi.framework.Bundle;

public final class TmfTraceTypeUIUtils {
    public static final String TMF_TRACE_TYPE_UI_ID = "org.eclipse.linuxtools.tmf.ui.tracetypeui";
    public static final String TYPE_ELEM = "type";
    public static final String EXPERIMENT_ELEM = "experiment";
    public static final String DEFAULT_EDITOR_ELEM = "defaultEditor";
    public static final String EVENTS_TABLE_TYPE_ELEM = "eventsTableType";
    public static final String EVENT_TABLE_COLUMNS = "eventTableColumns";
    public static final String PERSPECTIVE_ELEM = "perspective";
    public static final String ID_ATTR = "id";
    public static final String TRACETYPE_ATTR = "tracetype";
    public static final String ICON_ATTR = "icon";
    public static final String CLASS_ATTR = "class";
    public static final String USE_TRACE_ASPECTS_ATTR = "useTraceAspects";

    private TmfTraceTypeUIUtils() {
    }

    private static TraceTypeHelper getTraceTypeToSet(List<TraceTypeHelper> candidates, Shell shell) {
        final HashMap<String, String> names = new HashMap<String, String>();
        Shell shellToShow = new Shell(shell);
        shellToShow.setText(Messages.TmfTraceType_SelectTraceType);
        final String[] candidatesToSet = new String[1];
        for (TraceTypeHelper candidate : candidates) {
            Button b = new Button((Composite)shellToShow, 16);
            String displayName = String.valueOf(candidate.getCategoryName()) + ':' + candidate.getName();
            b.setText(displayName);
            names.put(displayName, candidate.getTraceTypeId());
            b.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Button source = (Button)e.getSource();
                    candidatesToSet[0] = (String)names.get(source.getText());
                    source.getParent().dispose();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        shellToShow.setLayout((Layout)new RowLayout(512));
        shellToShow.pack();
        shellToShow.open();
        Display display = shellToShow.getDisplay();
        while (!shellToShow.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return TmfTraceType.getTraceType((String)candidatesToSet[0]);
    }

    public static @Nullable TraceTypeHelper selectTraceType(String path, Shell shell, String traceTypeHint) throws TmfTraceImportException {
        List candidates = TmfTraceType.selectTraceType((String)path, (String)traceTypeHint);
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1 || shell == null) {
            return (TraceTypeHelper)candidates.get(0);
        }
        return TmfTraceTypeUIUtils.getTraceTypeToSet(candidates, shell);
    }

    public static IStatus setTraceType(IResource resource, TraceTypeHelper traceType) throws CoreException {
        return TmfTraceTypeUIUtils.setTraceType(resource, traceType, true);
    }

    public static IStatus setTraceType(IResource resource, TraceTypeHelper traceType, boolean refresh) throws CoreException {
        String traceTypeId = traceType.getTraceTypeId();
        resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceTypeId);
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject(resource.getProject(), true);
        if (tmfProject == null) {
            return Status.CANCEL_STATUS;
        }
        TmfTraceFolder tracesFolder = tmfProject.getTracesFolder();
        TmfExperimentFolder experimentsFolder = tmfProject.getExperimentsFolder();
        if (tracesFolder != null && tracesFolder.getPath().isPrefixOf(resource.getFullPath())) {
            String elementPath = resource.getFullPath().makeRelativeTo(tracesFolder.getPath()).toString();
            TmfTraceTypeUIUtils.refreshTraceElement(tracesFolder.getTraces(), elementPath);
        }
        if ((tracesFolder == null || experimentsFolder != null) && experimentsFolder != null) {
            if (resource.getParent().equals((Object)experimentsFolder.getResource())) {
                for (TmfExperimentElement experimentElement : experimentsFolder.getExperiments()) {
                    if (!resource.equals((Object)experimentElement.getResource())) continue;
                    experimentElement.refreshTraceType();
                    break;
                }
            } else {
                for (TmfExperimentElement experimentElement : experimentsFolder.getExperiments()) {
                    if (!experimentElement.getPath().isPrefixOf(resource.getFullPath())) continue;
                    String elementPath = resource.getFullPath().makeRelativeTo(experimentElement.getPath()).toString();
                    TmfTraceTypeUIUtils.refreshTraceElement(experimentElement.getTraces(), elementPath);
                    break;
                }
            }
        }
        if (refresh) {
            tmfProject.refresh();
        }
        return Status.OK_STATUS;
    }

    private static void refreshTraceElement(List<TmfTraceElement> traceElements, String elementPath) {
        for (TmfTraceElement traceElement : traceElements) {
            if (!traceElement.getElementPath().equals(elementPath)) continue;
            traceElement.refreshTraceType();
            break;
        }
    }

    public static IConfigurationElement[] getTypeUIElements(TmfTraceType.TraceElementType elType) {
        String elementName = TYPE_ELEM;
        if (elType == TmfTraceType.TraceElementType.EXPERIMENT) {
            elementName = EXPERIMENT_ELEM;
        }
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_UI_ID);
        LinkedList<IConfigurationElement> typeElements = new LinkedList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(elementName)) {
                typeElements.add(element);
            }
            ++n2;
        }
        return typeElements.toArray(new IConfigurationElement[typeElements.size()]);
    }

    public static @Nullable IConfigurationElement getTraceUIAttributes(String traceType, TmfTraceType.TraceElementType elType) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = TmfTraceTypeUIUtils.getTypeUIElements(elType);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (traceType.equals(ce.getAttribute(TRACETYPE_ATTR))) {
                return ce;
            }
            ++n2;
        }
        return null;
    }

    public static @Nullable TmfEventsTable getEventTable(ITmfTrace trace, Composite parent, int cacheSize) {
        String traceType = TmfTraceTypeUIUtils.getTraceType(trace);
        if (traceType == null) {
            return null;
        }
        TmfTraceType.TraceElementType elType = trace instanceof TmfExperiment ? TmfTraceType.TraceElementType.EXPERIMENT : TmfTraceType.TraceElementType.TRACE;
        IConfigurationElement[] iConfigurationElementArray = TmfTraceTypeUIUtils.getTypeUIElements(elType);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getAttribute(TRACETYPE_ATTR).equals(traceType)) {
                IConfigurationElement[] eventsTableTypeCE = ce.getChildren(EVENTS_TABLE_TYPE_ELEM);
                if (eventsTableTypeCE.length != 1) break;
                String eventsTableType = eventsTableTypeCE[0].getAttribute(CLASS_ATTR);
                boolean useTraceAspects = Boolean.parseBoolean(eventsTableTypeCE[0].getAttribute(USE_TRACE_ASPECTS_ATTR));
                if (eventsTableType == null || eventsTableType.isEmpty()) break;
                try {
                    Bundle bundle = Platform.getBundle((String)ce.getContributor().getName());
                    Class c = bundle.loadClass(eventsTableType);
                    Class[] constructorArgs = null;
                    Object[] args = null;
                    if (useTraceAspects) {
                        args = new Object[]{parent, cacheSize, trace.getEventAspects()};
                        constructorArgs = new Class[]{Composite.class, Integer.TYPE, Iterable.class};
                    } else {
                        args = new Object[]{parent, cacheSize};
                        constructorArgs = new Class[]{Composite.class, Integer.TYPE};
                    }
                    Constructor constructor = c.getConstructor(constructorArgs);
                    return (TmfEventsTable)constructor.newInstance(args);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    public static @Nullable String getPerspectiveId(ITmfTrace trace) {
        String traceType = TmfTraceTypeUIUtils.getTraceType(trace);
        if (traceType == null) {
            return null;
        }
        TmfTraceType.TraceElementType elType = trace instanceof TmfExperiment ? TmfTraceType.TraceElementType.EXPERIMENT : TmfTraceType.TraceElementType.TRACE;
        IConfigurationElement[] iConfigurationElementArray = TmfTraceTypeUIUtils.getTypeUIElements(elType);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getAttribute(TRACETYPE_ATTR).equals(traceType)) {
                String perspectiveId;
                IConfigurationElement[] perspectiveCE = ce.getChildren(PERSPECTIVE_ELEM);
                if (perspectiveCE.length != 1 || (perspectiveId = perspectiveCE[0].getAttribute(ID_ATTR)).isEmpty()) break;
                return perspectiveId;
            }
            ++n2;
        }
        return null;
    }

    private static @Nullable String getTraceType(ITmfTrace trace) {
        IResource res = trace.getResource();
        if (res == null) {
            return null;
        }
        try {
            String traceType = res.getPersistentProperty(TmfCommonConstants.TRACETYPE);
            return traceType;
        }
        catch (CoreException e) {
            return null;
        }
    }
}

