/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.analysis.callsite;

import com.google.common.annotations.VisibleForTesting;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.StateSystemStringInterner;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.callsite.ITmfCallsiteIterator;
import org.eclipse.tracecompass.tmf.core.analysis.callsite.TimeCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;

class CallsiteIterator
implements ITmfCallsiteIterator {
    private @Nullable ITmfStateSystem fSS = null;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable StateSystemUtils.QuarkIterator fFileIterator = null;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable StateSystemUtils.QuarkIterator fLineIterator = null;
    private int fSourceQuark = -2;
    private @Nullable TimeCallsite fPrevious = null;
    private @Nullable TimeCallsite fCurrent = null;
    private @Nullable TimeCallsite fNext = null;
    private @Nullable ITmfStateInterval fFileInterval = null;
    private @Nullable ITmfStateInterval fLineInterval = null;
    private final StateSystemStringInterner fInterner;

    @VisibleForTesting
    public CallsiteIterator(@Nullable ITmfStateSystem ss, String traceId, String deviceType, String deviceId, long initialTime, StateSystemStringInterner interner) {
        this.fInterner = interner;
        if (ss == null) {
            return;
        }
        int deviceQuark = ss.optQuarkAbsolute(new String[]{"Devices", traceId, deviceType, deviceId});
        if (deviceQuark == -2) {
            return;
        }
        int fileQuark = ss.optQuarkRelative(deviceQuark, new String[]{"Files"});
        if (fileQuark == -2) {
            return;
        }
        int lineQuark = ss.optQuarkRelative(deviceQuark, new String[]{"Lines"});
        if (lineQuark == -2) {
            return;
        }
        this.fFileIterator = new StateSystemUtils.QuarkIterator(ss, fileQuark, initialTime);
        this.fLineIterator = new StateSystemUtils.QuarkIterator(ss, lineQuark, initialTime);
        this.fSourceQuark = ss.optQuarkAbsolute(new String[]{"Sources"});
        this.fSS = ss;
    }

    private static boolean notMatch(@Nullable ITmfStateInterval interval, long time) {
        return interval == null || time == Long.MIN_VALUE && interval.getValue() == null || time != Long.MIN_VALUE && !interval.intersects(time);
    }

    @Override
    public boolean hasNext() {
        TimeCallsite next;
        if (this.fNext != null) {
            return true;
        }
        StateSystemUtils.QuarkIterator fileIterator = this.fFileIterator;
        StateSystemUtils.QuarkIterator lineIterator = this.fLineIterator;
        ITmfStateInterval lineInterval = this.fLineInterval;
        ITmfStateInterval fileInterval = this.fFileInterval;
        long nextTime = Long.MIN_VALUE;
        if (fileIterator == null || lineIterator == null || lineInterval == null && !lineIterator.hasNext() || fileInterval == null && !fileIterator.hasNext()) {
            return false;
        }
        if (fileInterval != null && lineInterval != null) {
            nextTime = Math.min(lineInterval.getEndTime() + 1L, fileInterval.getEndTime() + 1L);
        }
        while (CallsiteIterator.notMatch(fileInterval, nextTime)) {
            if (fileIterator.hasNext()) {
                fileInterval = fileIterator.next();
                continue;
            }
            return false;
        }
        while (CallsiteIterator.notMatch(lineInterval, nextTime)) {
            if (lineIterator.hasNext()) {
                lineInterval = lineIterator.next();
                continue;
            }
            return false;
        }
        this.fFileInterval = fileInterval;
        this.fLineInterval = lineInterval;
        this.fNext = next = this.getCallsite(fileInterval, lineInterval);
        return next != null;
    }

    @Override
    public TimeCallsite next() {
        if (this.hasNext()) {
            TimeCallsite next = Objects.requireNonNull(this.fNext, "Inconsistent state, should be non null if hasNext returned true");
            this.fPrevious = this.fCurrent;
            this.fCurrent = next;
            this.fNext = null;
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        TimeCallsite previous;
        if (this.fPrevious != null) {
            return true;
        }
        StateSystemUtils.QuarkIterator fileIterator = this.fFileIterator;
        StateSystemUtils.QuarkIterator lineIterator = this.fLineIterator;
        ITmfStateInterval lineInterval = this.fLineInterval;
        ITmfStateInterval fileInterval = this.fFileInterval;
        long prevTime = Long.MAX_VALUE;
        if (fileIterator == null || lineIterator == null || lineInterval == null && !fileIterator.hasPrevious() || fileInterval == null && !lineIterator.hasPrevious()) {
            return false;
        }
        if (fileInterval != null && lineInterval != null) {
            prevTime = Math.min(lineInterval.getEndTime() + 1L, fileInterval.getEndTime() + 1L);
        }
        while (CallsiteIterator.notMatch(fileInterval, prevTime)) {
            if (fileIterator.hasPrevious()) {
                fileInterval = fileIterator.previous();
                continue;
            }
            return false;
        }
        while (CallsiteIterator.notMatch(lineInterval, prevTime)) {
            if (lineIterator.hasPrevious()) {
                lineInterval = lineIterator.previous();
                continue;
            }
            return false;
        }
        this.fFileInterval = fileInterval;
        this.fLineInterval = lineInterval;
        this.fPrevious = previous = this.getCallsite(fileInterval, lineInterval);
        return previous != null;
    }

    @Override
    public TimeCallsite previous() {
        if (this.hasPrevious()) {
            TimeCallsite prev = Objects.requireNonNull(this.fPrevious, "Inconsistent state, should be non null if hasPrevious returned true");
            this.fNext = this.fCurrent;
            this.fCurrent = prev;
            this.fPrevious = null;
            return prev;
        }
        throw new NoSuchElementException();
    }

    private @Nullable TimeCallsite getCallsite(@Nullable ITmfStateInterval fileInterval, @Nullable ITmfStateInterval lineInterval) {
        ITmfStateSystem ss = this.fSS;
        if (ss == null || fileInterval == null || lineInterval == null) {
            return null;
        }
        try {
            Object value = fileInterval.getValue();
            if (value instanceof Integer) {
                long fileId = (long)((Integer)value).intValue() + ss.getStartTime();
                Object lineValue = lineInterval.getValue();
                if (lineValue instanceof Integer) {
                    long line = ((Integer)lineValue).intValue();
                    String fileName = this.fInterner.resolve(ss, fileId, this.fSourceQuark);
                    if (fileName != null) {
                        return new TimeCallsite(new TmfCallsite(fileName, line == -1L ? null : Long.valueOf(line)), fileInterval.getStartTime());
                    }
                }
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return null;
    }
}

