/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.timers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.ElementReferenceState;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.PeriodState;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.timers.RosTimersAnalysis;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosTimersDataProvider
extends AbstractTimeGraphDataProvider<RosTimersAnalysis, TimeGraphEntryModel> {
    public static final String SUFFIX = ".dataprovider";

    public RosTimersDataProvider(@NonNull ITmfTrace trace, @NonNull RosTimersAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    @Deprecated
    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        return this.fetchArrows(parameters, monitor);
    }

    @Deprecated
    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        return this.fetchTooltip(parameters, monitor);
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull String getId() {
        return String.valueOf(((RosTimersAnalysis)this.getAnalysisModule()).getId()) + SUFFIX;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable TimeGraphModel getRowModel(@NonNull ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        if (filter == null) {
            return null;
        }
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        Collection times = RosTimersDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        for (ITmfStateInterval interval : ss.query2D(entries.values(), times)) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        ArrayList<@NonNull TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            ArrayList eventList = new ArrayList();
            for (ITmfStateInterval interval : intervals.get((Object)((Integer)entry.getValue()))) {
                long startTime = interval.getStartTime();
                long duration = interval.getEndTime() - startTime + 1L;
                Object valObject = interval.getValue();
                if (valObject instanceof Long) {
                    TimeGraphState state;
                    String attributeName = ss.getAttributeName(interval.getAttribute());
                    if (attributeName.startsWith("0x")) {
                        long ref = (Long)valObject;
                        state = new PeriodState(startTime, duration, ref);
                        this.applyFilterAndAddState(eventList, (ITimeGraphState)state, (Long)entry.getKey(), predicates, monitor);
                        continue;
                    }
                    long ref = (Long)valObject;
                    state = new ElementReferenceState(startTime, duration, ref);
                    this.applyFilterAndAddState(eventList, (ITimeGraphState)state, (Long)entry.getKey(), predicates, monitor);
                    continue;
                }
                if (!(valObject instanceof Integer)) continue;
                int count = (Integer)valObject;
                TimeGraphState state = new TimeGraphState(startTime, duration, 0, Integer.toString(count));
                this.applyFilterAndAddState(eventList, (ITimeGraphState)state, (Long)entry.getKey(), predicates, monitor);
            }
            rows.add(new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        return new TimeGraphModel(rows);
    }

    protected boolean isCacheable() {
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull TmfTreeModel<@NonNull TimeGraphEntryModel> getTree(@NonNull ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        long parentId = this.getId(-1);
        builder.add((Object)new TimeGraphEntryModel(parentId, -1L, String.valueOf(this.getTrace().getName()), ss.getStartTime(), ss.getCurrentEndTime()));
        this.addChildren(ss, (ImmutableList.Builder<TimeGraphEntryModel>)builder, -1, parentId);
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    private void addChildren(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, int quark, long parentId) {
        for (Integer child : ss.getSubAttributes(quark, false)) {
            long childId = this.getId(child);
            String name = ss.getAttributeName(child.intValue());
            boolean isRowModel = quark != -1;
            builder.add((Object)new TimeGraphEntryModel(childId, parentId, name, ss.getStartTime(), ss.getCurrentEndTime(), isRowModel));
            this.addChildren(ss, builder, child, childId);
        }
    }

    public static String getFullDataProviderId() {
        return String.valueOf(RosTimersAnalysis.getFullAnalysisId()) + SUFFIX;
    }
}

