/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.weighted.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class WeightedTree<@NonNull T>
implements Comparable<WeightedTree<T>> {
    private final T fObject;
    private final Map<Object, WeightedTree<T>> fChildren = new HashMap<Object, WeightedTree<T>>();
    private @Nullable WeightedTree<T> fParent;
    private long fWeight = 0L;

    public WeightedTree(T object) {
        this(object, 0L);
    }

    public WeightedTree(T object, long initialWeight) {
        this.fObject = object;
        this.fParent = null;
        this.fWeight = initialWeight;
    }

    protected WeightedTree(WeightedTree<T> copy) {
        this.fObject = copy.fObject;
        for (WeightedTree<T> entry : copy.fChildren.values()) {
            this.fChildren.put(entry.getObject(), entry.copyOf());
        }
        this.fParent = copy.fParent;
        this.fWeight = copy.fWeight;
    }

    public long getWeight() {
        return this.fWeight;
    }

    public WeightedTree<T> copyOf() {
        return new WeightedTree<T>(this);
    }

    public T getObject() {
        return this.fObject;
    }

    protected @Nullable WeightedTree<T> getParent() {
        return this.fParent;
    }

    protected void setParent(WeightedTree<T> parent) {
        this.fParent = parent;
    }

    public Collection<WeightedTree<T>> getChildren() {
        return this.fChildren.values();
    }

    public void addToWeight(long weight) {
        this.fWeight += weight;
    }

    public void addChild(WeightedTree<T> child) {
        WeightedTree<T> childTree = this.fChildren.get(child.getObject());
        if (childTree == null) {
            child.setParent(this);
            this.fChildren.put(child.getObject(), child);
            return;
        }
        childTree.merge(child);
    }

    public final void merge(WeightedTree<T> other) {
        if (!other.getObject().equals(this.getObject())) {
            throw new IllegalArgumentException("AggregatedStackTraces: trying to merge stack traces of different symbols");
        }
        this.fWeight += other.fWeight;
        this.mergeData(other);
        this.mergeChildren(other);
    }

    protected void mergeData(WeightedTree<T> other) {
    }

    private void mergeChildren(WeightedTree<T> other) {
        for (WeightedTree<T> otherChildSite : other.fChildren.values()) {
            T childObject = otherChildSite.getObject();
            WeightedTree<T> childSite = this.fChildren.get(childObject);
            if (childSite == null) {
                this.fChildren.put(childObject, otherChildSite.copyOf());
                continue;
            }
            childSite.merge(otherChildSite);
        }
    }

    public int getMaxDepth() {
        int maxDepth = 0;
        for (WeightedTree<T> child : this.getChildren()) {
            maxDepth = Math.max(maxDepth, child.getMaxDepth());
        }
        return maxDepth + 1;
    }

    public Collection<WeightedTree<@NonNull T>> getExtraDataTrees(int index) {
        return Collections.emptyList();
    }

    public String toString() {
        return "[" + this.fObject + "]: " + this.fWeight;
    }

    @Override
    public int compareTo(WeightedTree<@NonNull T> o) {
        return Long.compare(this.fWeight, o.fWeight);
    }
}

