/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSearch;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;

public class CPPASTImplicitName
extends CPPASTName
implements IASTImplicitName {
    private boolean alternate;
    private boolean isOperator;
    private boolean isDefinition;

    public CPPASTImplicitName(char[] name, IASTNode parent) {
        super(name);
        this.setParent(parent);
        this.setPropertyInParent(IASTImplicitNameOwner.IMPLICIT_NAME);
    }

    public CPPASTImplicitName(OverloadableOperator op, IASTNode parent) {
        this(op.toCharArray(), parent);
        this.isOperator = true;
    }

    @Override
    public CPPASTImplicitName copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CPPASTImplicitName copy(IASTNode.CopyStyle style) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAlternate() {
        return this.alternate;
    }

    public void setAlternate(boolean alternate) {
        this.alternate = alternate;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (!this.alternate && action.shouldVisitImplicitNames || this.alternate && action.shouldVisitImplicitNameAlternates) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isDeclaration() {
        return false;
    }

    @Override
    public boolean isDefinition() {
        return this.isDefinition;
    }

    @Override
    public boolean isReference() {
        return !this.isDefinition;
    }

    public void setIsDefinition(boolean val) {
        this.isDefinition = val;
    }

    public void computeOperatorOffsets(IASTNode relativeNode, boolean trailing) {
        block6: {
            if (relativeNode == null) {
                return;
            }
            try {
                IToken first = trailing ? relativeNode.getTrailingSyntax() : relativeNode.getLeadingSyntax();
                int offset = ((ASTNode)relativeNode).getOffset() + first.getOffset();
                if (trailing) {
                    offset += ((ASTNode)relativeNode).getLength();
                }
                OverloadableOperator oo = OverloadableOperator.valueOf(first);
                if (first.getNext() == null && oo != null || Arrays.equals(first.getCharImage(), Keywords.cDELETE) || Arrays.equals(first.getCharImage(), Keywords.cNEW)) {
                    int length = first.getLength();
                    this.setOffsetAndLength(offset, length);
                } else {
                    this.setOffsetAndLength(offset, 0);
                }
            }
            catch (ExpansionOverlapsBoundaryException e) {
                if (this.computeOperatorOffsetsFallback(relativeNode, trailing)) break block6;
                ASTNode parent = (ASTNode)this.getParent();
                this.setOffsetAndLength(parent.getOffset() + parent.getLength(), 0);
            }
        }
    }

    private boolean computeOperatorOffsetsFallback(IASTNode relativeNode, boolean trailing) {
        int end;
        int start;
        IASTNode parent;
        if (!(relativeNode instanceof ASTNode)) {
            return false;
        }
        ASTNode relative = (ASTNode)relativeNode;
        ASTNodeSearch visitor = new ASTNodeSearch(relativeNode);
        IASTNode sibling = trailing ? visitor.findRightSibling() : visitor.findLeftSibling();
        IASTNode iASTNode = parent = sibling == null ? relativeNode.getParent() : null;
        if (sibling != null && !(sibling instanceof ASTNode) || parent != null && !(parent instanceof ASTNode)) {
            return false;
        }
        ASTNode sib = (ASTNode)sibling;
        ASTNode par = (ASTNode)parent;
        int n = trailing ? relative.getOffset() + relative.getLength() : (start = sib != null ? sib.getOffset() + sib.getLength() : par.getOffset());
        int n2 = trailing ? (sib != null ? sib.getOffset() : par.getOffset() + par.getLength()) : (end = relative.getOffset());
        if (end == start + 1) {
            this.setOffsetAndLength(start, 1);
            return true;
        }
        return false;
    }

    public void setOperator(boolean isOperator) {
        this.isOperator = isOperator;
    }

    @Override
    public boolean isOperator() {
        return this.isOperator;
    }
}

