/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.PendingSyncExec;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class UILockListener
extends LockListener {
    protected Display display;
    protected final Queue pendingWork = new Queue();
    protected PendingSyncExec currentWork = null;
    protected volatile Thread ui;

    public UILockListener(Display display) {
        this.display = display;
    }

    public void aboutToRelease() {
        if (this.isUI()) {
            this.ui = null;
        }
    }

    public boolean aboutToWait(Thread lockOwner) {
        if (this.isUI()) {
            if (this.currentWork != null && this.currentWork.getOperationThread() == lockOwner) {
                return true;
            }
            this.ui = Thread.currentThread();
            try {
                this.doPendingWork();
            }
            finally {
                this.ui = Thread.currentThread();
            }
        }
        return false;
    }

    void addPendingWork(PendingSyncExec work) {
        this.pendingWork.add(work);
    }

    public boolean canBlock() {
        return !this.isUI();
    }

    void doPendingWork() {
        PendingSyncExec work;
        Thread.interrupted();
        while ((work = this.pendingWork.remove()) != null) {
            PendingSyncExec oldWork = this.currentWork;
            try {
                this.currentWork = work;
                work.run();
            }
            finally {
                this.currentWork = oldWork;
            }
        }
    }

    void interruptUI(Runnable runnable) {
        this.reportInterruption(runnable);
        this.display.getThread().interrupt();
    }

    boolean isLockOwner() {
        return this.isLockOwnerThread();
    }

    boolean isUI() {
        return !this.display.isDisposed() && this.display.getThread() == Thread.currentThread();
    }

    boolean isUIWaiting() {
        Thread localUi = this.ui;
        return localUi != null && Thread.currentThread() != localUi;
    }

    private void reportInterruption(Runnable runnable) {
        ThreadInfo[] threads;
        Thread nonUiThread = Thread.currentThread();
        String msg = "To avoid deadlock while executing Display.syncExec() with argument: " + runnable + ", thread " + nonUiThread.getName() + " will interrupt UI thread.";
        MultiStatus main = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 4, msg, null);
        ThreadInfo[] threadInfoArray = threads = ManagementFactory.getThreadMXBean().getThreadInfo(new long[]{nonUiThread.getId(), this.display.getThread().getId()}, true, true);
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo info = threadInfoArray[n2];
            String childMsg = info.getThreadId() == nonUiThread.getId() ? String.valueOf(nonUiThread.getName()) + " thread is an instance of Worker or owns an ILock" : "UI thread waiting on a job or lock.";
            IllegalStateException childEx = new IllegalStateException("Call stack for thread " + info.getThreadName());
            childEx.setStackTrace(info.getStackTrace());
            Status child = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, childMsg, (Throwable)childEx);
            main.add((IStatus)child);
            ++n2;
        }
        WorkbenchPlugin.log((IStatus)main);
    }

    public class Queue {
        private static final int BASE_SIZE = 8;
        protected PendingSyncExec[] elements = new PendingSyncExec[8];
        protected int head = 0;
        protected int tail = 0;

        public synchronized void add(PendingSyncExec element) {
            int newTail = this.increment(this.tail);
            if (newTail == this.head) {
                this.grow();
                newTail = this.tail + 1;
            }
            this.elements[this.tail] = element;
            this.tail = newTail;
        }

        private void grow() {
            int newSize = this.elements.length * 2;
            PendingSyncExec[] newElements = new PendingSyncExec[newSize];
            if (this.tail >= this.head) {
                System.arraycopy(this.elements, this.head, newElements, this.head, this.size());
            } else {
                int newHead = newSize - (this.elements.length - this.head);
                System.arraycopy(this.elements, 0, newElements, 0, this.tail + 1);
                System.arraycopy(this.elements, this.head, newElements, newHead, newSize - newHead);
                this.head = newHead;
            }
            this.elements = newElements;
        }

        private int increment(int index) {
            return index == this.elements.length - 1 ? 0 : index + 1;
        }

        public synchronized PendingSyncExec remove() {
            if (this.tail == this.head) {
                return null;
            }
            PendingSyncExec result = this.elements[this.head];
            this.elements[this.head] = null;
            this.head = this.increment(this.head);
            if (this.tail == this.head && this.elements.length > 8) {
                this.elements = new PendingSyncExec[8];
                this.head = 0;
                this.tail = 0;
            }
            return result;
        }

        private int size() {
            return this.tail > this.head ? this.tail - this.head : this.elements.length - this.head + this.tail;
        }
    }
}

