/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.ui.view.spanlife;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife.SpanLifeEntryModel;
import org.eclipse.tracecompass.incubator.internal.opentracing.ui.view.spanlife.SpanMarkerEvent;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITmfTimeGraphDrawingHelper;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;

public class SpanLifePresentationProvider
extends TimeGraphPresentationProvider {
    private static final @NonNull String ERROR = "error";
    private static final @NonNull String EVENT = "event";
    private static final @NonNull String MESSAGE = "message";
    private static final @NonNull String STACK = "stack";
    private static final @NonNull String OTHER = "other";
    private static final @NonNull String FLAG_EMOJI = "\ud83c\udff3\ufe0f";
    private static final @NonNull RGBA MARKER_COLOR = new RGBA(200, 0, 0, 150);
    private static final int MARKER_COLOR_INT = MARKER_COLOR.hashCode();
    private static final StateItem[] STATE_TABLE = new StateItem[]{new StateItem(new RGB(179, 205, 224), "Fist Service Class"), new StateItem(new RGB(100, 151, 177), "Second Service Class"), new StateItem(new RGB(0, 91, 150), "Third Service Class"), new StateItem(new RGB(3, 57, 108), "Forth Service Class"), new StateItem(new RGB(1, 31, 75), "Fifth Service Class"), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.label(), (Object)"error", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR_INT, (Object)ITimeEventStyleStrings.symbolStyle(), (Object)"CROSS", (Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(0.4f))), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.label(), (Object)"event", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR_INT, (Object)ITimeEventStyleStrings.symbolStyle(), (Object)"DIAMOND", (Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(0.3f))), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.label(), (Object)"message", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR_INT, (Object)ITimeEventStyleStrings.symbolStyle(), (Object)"CIRCLE", (Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(0.3f))), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.label(), (Object)"stack", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR_INT, (Object)ITimeEventStyleStrings.symbolStyle(), (Object)"SQUARE", (Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(0.3f))), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.label(), (Object)"other", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR_INT, (Object)ITimeEventStyleStrings.symbolStyle(), (Object)"\ud83c\udff3\ufe0f", (Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(0.3f)))};

    public SpanLifePresentationProvider() {
        super("Span");
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        ITimeGraphEntry entry;
        LinkedHashMap<String, String> eventHoverToolTipInfo = super.getEventHoverToolTipInfo(event, hoverTime);
        if (eventHoverToolTipInfo == null) {
            eventHoverToolTipInfo = new LinkedHashMap<String, String>();
        }
        if ((entry = event.getEntry()) instanceof TimeGraphEntry) {
            long id = ((TimeGraphEntry)entry).getModel().getId();
            ITimeGraphDataProvider provider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)((TimeGraphEntry)entry));
            long windowStartTime = Long.MIN_VALUE;
            long windowEndTime = Long.MIN_VALUE;
            ITmfTimeGraphDrawingHelper drawingHelper = this.getDrawingHelper();
            if (drawingHelper instanceof TimeGraphControl) {
                TimeGraphControl timeGraphControl = (TimeGraphControl)drawingHelper;
                windowStartTime = timeGraphControl.getTimeDataProvider().getTime0();
                windowEndTime = timeGraphControl.getTimeDataProvider().getTime1();
            }
            ArrayList<@NonNull Long> times = new ArrayList<Long>();
            times.add(windowStartTime);
            times.add(hoverTime);
            times.add(windowEndTime);
            SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(times, Collections.singleton(id));
            @NonNull @NonNull @NonNull TmfModelResponse tooltipResponse = provider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter), (IProgressMonitor)new NullProgressMonitor());
            @NonNull @NonNull Map tooltipModel = (Map)tooltipResponse.getModel();
            if (tooltipModel != null) {
                eventHoverToolTipInfo.putAll(tooltipModel);
            }
        }
        return eventHoverToolTipInfo;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        block18: {
            String type;
            if (!(event instanceof SpanMarkerEvent)) break block18;
            SpanMarkerEvent markerEvent = (SpanMarkerEvent)event;
            switch (type = markerEvent.getType()) {
                case "error": {
                    return 5;
                }
                case "event": {
                    return 6;
                }
                case "message": {
                    return 7;
                }
                case "stack": {
                    return 8;
                }
            }
            return 9;
        }
        if (event instanceof TimeEvent && ((TimeEvent)event).getValue() != Integer.MIN_VALUE) {
            if (event.getEntry() instanceof TimeGraphEntry && ((TimeGraphEntry)event.getEntry()).getModel() instanceof SpanLifeEntryModel) {
                String processName = ((SpanLifeEntryModel)((TimeGraphEntry)event.getEntry()).getModel()).getProcessName();
                return Math.abs(Objects.hash(processName)) % 5;
            }
            return 0;
        }
        return -1;
    }
}

