/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuildInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2PublicationMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2SubCallbackMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2TimerCallbackMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackPublicationInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2SubCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2TimerCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2CallbackType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2Object;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class Ros2CallbackPubMessageFlowSegment
extends Ros2MessageFlowSegment {
    private final @NonNull Ros2CallbackPublicationInstance fCallbackPubInstance;
    private final @NonNull Ros2Object<@NonNull Ros2ObjectHandle> fSource;
    private final @NonNull Ros2PublisherObject fPublisher;

    public Ros2CallbackPubMessageFlowSegment(long startTime, long endTime, @NonNull Ros2CallbackPublicationInstance callbackPubInstance, @NonNull Ros2Object<@NonNull Ros2ObjectHandle> source, @NonNull Ros2PublisherObject publisher) {
        super(startTime, endTime, null);
        this.fCallbackPubInstance = callbackPubInstance;
        this.fSource = source;
        this.fPublisher = publisher;
    }

    public @NonNull Ros2CallbackPublicationInstance getCallbackPubInstance() {
        return this.fCallbackPubInstance;
    }

    public @NonNull Ros2Object<@NonNull Ros2ObjectHandle> getSource() {
        return this.fSource;
    }

    public @NonNull Ros2PublisherObject getPublisher() {
        return this.fPublisher;
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectSuccessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ITmfStateInterval pubInstanceInterval = Ros2MessagesUtil.getPubInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), this.getCallbackPubInstance().getPublicationTimestamp(), this.getCallbackPubInstance().getPublisherHandle());
        if (pubInstanceInterval == null) {
            return Collections.emptyList();
        }
        long startTime = pubInstanceInterval.getStartTime();
        long endTime = pubInstanceInterval.getEndTime();
        Ros2PubInstance pubInstance = (Ros2PubInstance)((Object)pubInstanceInterval.getValue());
        if (pubInstance == null) {
            return Collections.emptyList();
        }
        Ros2PublisherObject pubObject = Ros2ObjectsUtil.getPublisherObjectFromHandle(info.getObjectsSs(), startTime, pubInstance.getPublisherHandle());
        if (pubObject == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Ros2PublicationMessageFlowSegment(startTime, endTime, pubInstance, pubObject));
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectPredecessors(@NonNull Ros2MessageFlowBuildInfo info) {
        long time = this.getCallbackPubInstance().getPublicationTimestamp();
        Ros2CallbackType callbackType = this.getCallbackPubInstance().getCallbackType();
        if (callbackType.equals((Object)Ros2CallbackType.SUBSCRIPTION)) {
            Ros2SubscriptionObject subObject = (Ros2SubscriptionObject)this.getSource();
            ITmfStateInterval subCallbackInstanceInterval = Ros2MessagesUtil.getSubCallbackInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), time, (Ros2ObjectHandle)((Object)subObject.getHandle()));
            if (subCallbackInstanceInterval == null) {
                return Collections.emptyList();
            }
            long startTime = subCallbackInstanceInterval.getStartTime();
            long endTime = subCallbackInstanceInterval.getEndTime();
            Ros2SubCallbackInstance subCallbackInstance = (Ros2SubCallbackInstance)((Object)subCallbackInstanceInterval.getValue());
            if (subCallbackInstance == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new Ros2SubCallbackMessageFlowSegment(startTime, endTime, subCallbackInstance, subObject));
        }
        if (callbackType.equals((Object)Ros2CallbackType.TIMER)) {
            Ros2TimerObject timerObject = (Ros2TimerObject)this.getSource();
            ITmfStateInterval timerCallbackInstanceInterval = Ros2MessagesUtil.getTimerCallbackInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), time, (Ros2ObjectHandle)((Object)timerObject.getHandle()));
            if (timerCallbackInstanceInterval == null) {
                return Collections.emptyList();
            }
            long startTime = timerCallbackInstanceInterval.getStartTime();
            long endTime = timerCallbackInstanceInterval.getEndTime();
            Ros2TimerCallbackInstance timerCallbackInstance = (Ros2TimerCallbackInstance)((Object)timerCallbackInstanceInterval.getValue());
            if (timerCallbackInstance == null) {
                return Collections.emptyList();
            }
            Ros2CallbackInstance callbackInstance = timerCallbackInstance.getCallbackInstance();
            return Collections.singletonList(new Ros2TimerCallbackMessageFlowSegment(startTime, endTime, callbackInstance, timerObject));
        }
        throw new IllegalStateException();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fCallbackPubInstance, this.fSource, this.fPublisher, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ros2CallbackPubMessageFlowSegment)) {
            return false;
        }
        Ros2CallbackPubMessageFlowSegment o = (Ros2CallbackPubMessageFlowSegment)obj;
        if (!this.fCallbackPubInstance.equals((Object)o.fCallbackPubInstance)) {
            return false;
        }
        if (!this.fSource.equals(o.fSource)) {
            return false;
        }
        return this.fPublisher.equals((Object)o.fPublisher);
    }

    @Override
    public String toString() {
        return String.format("Ros2CallbackPubMessageFlowSegment: %s, callbackPubInstance=[%s], source=[%s], pub=[%s]", super.toString(), this.fCallbackPubInstance.toString(), this.fSource.toString(), this.fPublisher.toString());
    }
}

