/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.graph.IEdgeContextStateFactory;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.graph.WorkerSerializer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.GraphHistoryTree;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.HistoryTreeTmfGraph;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfEdgeInterval;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;

public class OsHistoryTreeGraph
extends HistoryTreeTmfGraph {
    public OsHistoryTreeGraph(Path newStateFile, int version, WorkerSerializer workerSerializer, long startTime) throws IOException {
        super(newStateFile, version, workerSerializer, startTime);
    }

    @Override
    protected GraphHistoryTree createHistoryTree(Path treeFile, int version, long startTime) throws IOException {
        try {
            if (Files.exists(treeFile, new LinkOption[0])) {
                GraphHistoryTree sht = new GraphHistoryTree((File)NonNullUtils.checkNotNull((Object)treeFile.toFile()), version, new Reader());
                this.readWorkers(sht);
                this.setFinishedBuilding(true);
                return sht;
            }
        }
        catch (IOException iOException) {
            this.getWorkerAttrib().clear();
        }
        return new GraphHistoryTree((File)NonNullUtils.checkNotNull((Object)treeFile.toFile()), 65536, 50, version, startTime, new Reader());
    }

    @Override
    public @Nullable ITmfEdge appendUnknown(ITmfVertex vertex) {
        return this.append(vertex, new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.UNKNOWN), "");
    }

    @Override
    public @Nullable ITmfEdge append(ITmfVertex vertex) {
        return this.append(vertex, new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.DEFAULT), "");
    }

    @Override
    public @Nullable ITmfEdge edgeUnknown(ITmfVertex from, ITmfVertex to) {
        return this.edge(from, to, new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.UNKNOWN));
    }

    @Override
    public @Nullable ITmfEdge edge(ITmfVertex from, ITmfVertex to) {
        return this.edge(from, to, new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.DEFAULT));
    }

    private class OsEdgeContextStateFactory
    implements IEdgeContextStateFactory {
        private OsEdgeContextStateFactory() {
        }

        @Override
        public ITmfEdgeContextState createContextState(int code) {
            return new OSEdgeContextState(code);
        }
    }

    private class Reader
    implements IHTIntervalReader<TmfEdgeInterval> {
        private Reader() {
        }

        public TmfEdgeInterval readInterval(ISafeByteBufferReader buffer) {
            return TmfEdgeInterval.readBuffer(buffer, new OsEdgeContextStateFactory());
        }
    }
}

