/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IPDOMASTProcessor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class PDOMASTProcessorDesc {
    private static final String Attr_Class = "class";
    private final IConfigurationElement element;
    private final Expression enablementExpression;
    private Boolean fStatus = null;
    private String id;
    private IPDOMASTProcessor processor;
    private static final String VAR_PROJECTNATURES = "projectNatures";
    private static final String VAR_LANGUAGEID = "languageId";
    private static final IPDOMASTProcessor NULL_PROCESSOR = new IPDOMASTProcessor.Abstract(){};

    public PDOMASTProcessorDesc(IConfigurationElement element) {
        this.element = element;
        Expression expr = null;
        IConfigurationElement[] children = element.getChildren("enablement");
        switch (children.length) {
            case 0: {
                this.fStatus = Boolean.TRUE;
                break;
            }
            case 1: {
                try {
                    ExpressionConverter parser = ExpressionConverter.getDefault();
                    expr = parser.perform(children[0]);
                }
                catch (CoreException e) {
                    CCorePlugin.log("Error in enablement expression of " + this.id, e);
                }
                break;
            }
            default: {
                CCorePlugin.log("Too many enablement expressions for " + this.id);
                this.fStatus = Boolean.FALSE;
            }
        }
        this.enablementExpression = expr;
    }

    private boolean matches(ITranslationUnit tu) {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        if (tu == null) {
            return true;
        }
        if (this.enablementExpression != null) {
            try {
                ILanguage language;
                IProject project = null;
                ICProject cProject = tu.getCProject();
                if (cProject != null) {
                    project = cProject.getProject();
                }
                EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
                if (project != null) {
                    String[] natures = project.getDescription().getNatureIds();
                    evalContext.addVariable(VAR_PROJECTNATURES, Arrays.asList(natures));
                }
                if ((language = tu.getLanguage()) != null) {
                    evalContext.addVariable(VAR_LANGUAGEID, (Object)language.getId());
                }
                return this.enablementExpression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                CCorePlugin.log("Error while evaluating enablement expression for " + this.id, e);
            }
        }
        this.fStatus = Boolean.FALSE;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPDOMASTProcessor getProcessor() {
        if (this.processor == null) {
            PDOMASTProcessorDesc pDOMASTProcessorDesc = this;
            synchronized (pDOMASTProcessorDesc) {
                if (this.processor == null) {
                    try {
                        this.processor = (IPDOMASTProcessor)this.element.createExecutableExtension(Attr_Class);
                    }
                    catch (CoreException e) {
                        String id = String.valueOf(this.element.getDeclaringExtension().getNamespaceIdentifier()) + '.' + this.element.getDeclaringExtension().getSimpleIdentifier();
                        CCorePlugin.log("Error in class attribute of " + id, e);
                        this.processor = NULL_PROCESSOR;
                    }
                }
            }
        }
        return this.processor;
    }

    public IPDOMASTProcessor getProcessorFor(IASTTranslationUnit ast) {
        if (ast == null) {
            return this.getProcessor();
        }
        return this.matches(ast.getOriginatingTranslationUnit()) ? this.getProcessor() : null;
    }
}

