/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileTableContentProvider
implements IStructuredContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private FileSearchPage fPage;
    private AbstractTextSearchResult fResult;

    public FileTableContentProvider(FileSearchPage page) {
        this.fPage = page;
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof FileSearchResult) {
            int elementLimit = this.getElementLimit();
            Object[] elements = ((FileSearchResult)inputElement).getElements();
            if (elementLimit != -1 && elements.length > elementLimit) {
                Object[] shownElements = new Object[elementLimit];
                System.arraycopy(elements, 0, shownElements, 0, elementLimit);
                return shownElements;
            }
            return elements;
        }
        return this.EMPTY_ARR;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof FileSearchResult) {
            this.fResult = (FileSearchResult)newInput;
        }
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer = this.getViewer();
        int elementLimit = this.getElementLimit();
        boolean tableLimited = elementLimit != -1;
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object updatedElement = objectArray[n2];
            if (this.fResult.getMatchCount(updatedElement) > 0) {
                if (viewer.testFindItem(updatedElement) != null) {
                    viewer.update(updatedElement, null);
                } else if (!tableLimited || viewer.getTable().getItemCount() < elementLimit) {
                    viewer.add(updatedElement);
                }
            } else {
                viewer.remove(updatedElement);
            }
            ++n2;
        }
    }

    private int getElementLimit() {
        return this.fPage.getElementLimit();
    }

    private TableViewer getViewer() {
        return (TableViewer)this.fPage.getViewer();
    }

    @Override
    public void clear() {
        this.getViewer().refresh();
    }
}

