/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.wst.jsdt.ui.text.java.hover.IJavaEditorTextHover;

public class BestMatchHover
extends AbstractJavaEditorTextHover
implements IInformationProviderExtension2 {
    private List fTextHoverSpecifications;
    private List fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart editor) {
        this();
        this.setEditor(editor);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList(2);
        this.fInstantiatedTextHovers = new ArrayList(2);
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaScriptPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (!"org.eclipse.wst.jsdt.ui.BestMatchHover".equals(hoverDescs[i].getId())) {
                this.fTextHoverSpecifications.add(hoverDescs[i]);
            }
            ++i;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications.size() == 0) {
            return;
        }
        for (JavaEditorTextHoverDescriptor spec : new ArrayList(this.fTextHoverSpecifications)) {
            IJavaEditorTextHover hover = spec.createTextHover();
            if (hover == null) continue;
            hover.setEditor(this.getEditor());
            this.addTextHover(hover);
            this.fTextHoverSpecifications.remove(spec);
        }
    }

    protected void addTextHover(ITextHover hover) {
        if (!this.fInstantiatedTextHovers.contains(hover)) {
            this.fInstantiatedTextHovers.add(hover);
        }
    }

    @Override
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover hover : this.fInstantiatedTextHovers) {
            String s = hover.getHoverInfo(textViewer, hoverRegion);
            if (s == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover hover : this.fInstantiatedTextHovers) {
            if (hover == null) continue;
            if (hover instanceof ITextHoverExtension2) {
                Object info = ((ITextHoverExtension2)hover).getHoverInfo2(textViewer, hoverRegion);
                if (info == null) continue;
                this.fBestHover = hover;
                return info;
            }
            String s = hover.getHoverInfo(textViewer, hoverRegion);
            if (s == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }
}

