/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

public enum BooleanLiteralSet {
    EMPTY,
    TRUE,
    FALSE,
    BOTH;


    private BooleanLiteralSet fromOrdinal(int ordinal) {
        switch (ordinal) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return TRUE;
            }
            case 2: {
                return FALSE;
            }
            case 3: {
                return BOTH;
            }
        }
        throw new IllegalArgumentException("Ordinal: " + ordinal);
    }

    public BooleanLiteralSet intersection(BooleanLiteralSet that) {
        return this.fromOrdinal(this.ordinal() & that.ordinal());
    }

    public BooleanLiteralSet union(BooleanLiteralSet that) {
        return this.fromOrdinal(this.ordinal() | that.ordinal());
    }

    public boolean contains(boolean literalValue) {
        switch (this.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return literalValue;
            }
            case 2: {
                return !literalValue;
            }
            case 3: {
                return true;
            }
        }
        throw new IndexOutOfBoundsException("Ordinal: " + this.ordinal());
    }

    public static BooleanLiteralSet get(boolean literalValue) {
        return literalValue ? TRUE : FALSE;
    }
}

