/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import com.google.common.collect.LinkedHashMultimap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteExperimentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell shell = window.getShell();
        MessageBox confirmOperation = new MessageBox(shell, 292);
        confirmOperation.setText(Messages.DeleteDialog_Title);
        confirmOperation.setMessage(Messages.DeleteExperimentHandler_Message);
        if (confirmOperation.open() != 32) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IRunnableWithProgress operation = monitor -> {
            LinkedHashMultimap experimentsToDelete = LinkedHashMultimap.create();
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof TmfExperimentElement)) continue;
                TmfExperimentElement experimentElement = (TmfExperimentElement)element;
                experimentsToDelete.put((Object)experimentElement.getProject(), (Object)experimentElement);
            }
            monitor.setTaskName(Messages.CloseTraces_TaskName);
            experimentsToDelete.values().forEach(experiment -> Display.getDefault().syncExec(experiment::closeEditors));
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)experimentsToDelete.size());
            subMon.setTaskName(Messages.DeleteExperimentHandler_TaskName);
            for (Map.Entry entry : experimentsToDelete.asMap().entrySet()) {
                IProject project = ((TmfProjectElement)entry.getKey()).getResource();
                try {
                    ResourcesPlugin.getWorkspace().run(mon -> {
                        for (TmfExperimentElement experimentElement : (Collection)entry.getValue()) {
                            IFolder resource = experimentElement.getResource();
                            IPath path = resource.getLocation();
                            if (path != null) {
                                experimentElement.deleteSupplementaryFolder();
                            }
                            resource.delete(true, (IProgressMonitor)subMon.split(1));
                        }
                        subMon.subTask("");
                    }, (ISchedulingRule)project, 1, null);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(Messages.DeleteExperimentHandler_Error, e.getTargetException().toString(), e.getTargetException());
        }
        return null;
    }
}

