/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.core.trace;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class JaegerRestUtils {
    private static final String SERVICES_ENDPOINT = "services";
    private static final String SERVICES_DATA_KEY = "data";
    private static final String TRACES_ENDPOINT = "traces";
    private static final String NANOSECONDS_PADDING = "000";
    private static final long HOUR_TO_SEC = 3600L;
    private static final String DEFAULT_LIMIT = "20";
    private static final String DEFAULT_SERVICE = "jaeger-query";
    private static final String DEFAULT_BASE_URL = "http://localhost:16686/api";
    private static final String DEFAULT_LOOKBACK = "1h";
    private static final String LOOKBACK_1_HOUR = "1h";
    private static final String LOOKBACK_2_HOUR = "2h";
    private static final String LOOKBACK_3_HOUR = "3h";
    private static final String LOOKBACK_6_HOUR = "6h";
    private static final String LOOKBACK_12_HOUR = "12h";
    private static final String SEARCH_END_TIME = "end";
    private static final String NB_TRACES_LIMIT = "limit";
    private static final String LOOKBACK = "lookback";
    private static final String MAX_DURATION = "maxDuration";
    private static final String MIN_DURATION = "minDuration";
    private static final String SERVICE_NAME = "service";
    private static final String SEARCH_START_TIME = "start";
    private static final String TAGS = "tags";

    private JaegerRestUtils() {
    }

    public static String[] fetchServices(String baseUrl) {
        URI uri = UriBuilder.fromUri((String)baseUrl).path(SERVICES_ENDPOINT).build(new Object[0]);
        String response = JaegerRestUtils.jaegerGet(uri.toString());
        Gson gson = new Gson();
        JsonObject jsonResponse = (JsonObject)gson.fromJson(response, JsonObject.class);
        JsonArray servicesArray = jsonResponse.get(SERVICES_DATA_KEY).getAsJsonArray();
        String[] services = new String[servicesArray.size()];
        int i = 0;
        while (i < servicesArray.size()) {
            services[i] = servicesArray.get(i).getAsString();
            ++i;
        }
        return services;
    }

    public static String buildTracesUrl(String baseUrl, String endTime, String limit, String lookback, String maxDuration, String minDuration, String service, String startTime, String tags) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)baseUrl).path(TRACES_ENDPOINT).queryParam(SEARCH_END_TIME, new Object[]{endTime}).queryParam(NB_TRACES_LIMIT, new Object[]{limit}).queryParam(LOOKBACK, new Object[]{lookback}).queryParam(SERVICE_NAME, new Object[]{service}).queryParam(SEARCH_START_TIME, new Object[]{startTime});
        if (!maxDuration.isEmpty()) {
            uriBuilder.queryParam(MAX_DURATION, new Object[]{maxDuration});
        }
        if (!minDuration.isEmpty()) {
            uriBuilder.queryParam(MIN_DURATION, new Object[]{minDuration});
        }
        if (!tags.isEmpty()) {
            try {
                uriBuilder.queryParam(TAGS, new Object[]{URLEncoder.encode(tags, StandardCharsets.UTF_8.name())});
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return uriBuilder.build(new Object[0]).toString();
    }

    public static String fetchJaegerTraces(String url) {
        return JaegerRestUtils.jaegerGet(url);
    }

    private static String jaegerGet(String url) {
        Client client = ClientBuilder.newClient();
        WebTarget resource = client.target(url);
        Invocation.Builder request = resource.request();
        request.accept(new String[]{"application/json"});
        try {
            return (String)request.get(String.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean jaegerCheckConnection(String url) {
        Client client = ClientBuilder.newClient();
        WebTarget resource = client.target(url);
        Invocation.Builder request = resource.request();
        try {
            int status = request.get().getStatus();
            return Response.Status.fromStatusCode((int)status) == Response.Status.OK;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String fetchJaegerTraces(Map<String, Object> parameters) {
        Object targetUrlObject = parameters.get("targetUrl");
        String targetUrlText = targetUrlObject != null ? (String)targetUrlObject : DEFAULT_BASE_URL;
        Object serviceObject = parameters.get(SERVICE_NAME);
        String service = serviceObject != null ? (String)serviceObject : DEFAULT_SERVICE;
        Object tagsObject = parameters.get(TAGS);
        String tags = tagsObject != null ? (String)tagsObject : "";
        Object limitResultsObject = parameters.get(NB_TRACES_LIMIT);
        String limitResults = limitResultsObject != null ? (String)limitResultsObject : DEFAULT_LIMIT;
        Object lookBackObject = parameters.get(LOOKBACK);
        String lookBackText = lookBackObject != null ? (String)lookBackObject : "1h";
        long lookBack = 3600L;
        switch (lookBackText) {
            case "1h": {
                lookBack = 3600L;
                break;
            }
            case "2h": {
                lookBack = 7200L;
                break;
            }
            case "3h": {
                lookBack = 10800L;
                break;
            }
            case "6h": {
                lookBack = 21600L;
                break;
            }
            case "12h": {
                lookBack = 43200L;
                break;
            }
            default: {
                lookBack = 3600L;
            }
        }
        Object maxDurationObject = parameters.get(MAX_DURATION);
        String targetMaxDurationText = maxDurationObject != null ? (String)maxDurationObject : "";
        Object minDurationObject = parameters.get(MIN_DURATION);
        String targetMinDurationText = minDurationObject != null ? (String)minDurationObject : "";
        long startTime = Instant.now().minusSeconds(lookBack).toEpochMilli();
        long endTime = Instant.now().toEpochMilli();
        String requestUrl = JaegerRestUtils.buildTracesUrl(targetUrlText, Long.toString(endTime) + NANOSECONDS_PADDING, limitResults, lookBackText, targetMaxDurationText, targetMinDurationText, service, Long.toString(startTime) + NANOSECONDS_PADDING, tags);
        return JaegerRestUtils.fetchJaegerTraces(requestUrl);
    }

    public static List<String> getTraceIDs(JsonObject tracesObject) {
        JsonArray tracesArray = tracesObject.get(SERVICES_DATA_KEY).getAsJsonArray();
        ArrayList<String> traceIDs = new ArrayList<String>();
        if (tracesArray.size() > 0) {
            int i = 0;
            while (i < tracesArray.size()) {
                JsonObject trace = tracesArray.get(i).getAsJsonObject();
                traceIDs.add(trace.get("traceID").getAsString());
                ++i;
            }
        }
        return traceIDs;
    }
}

