/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.core.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedRangeException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.tracecompass.tmf.filter.parser.FilterParserLexer;
import org.eclipse.tracecompass.tmf.filter.parser.FilterParserParser;

public class FilterValidation {
    private static int getErrorStartEndIndex(CommonTree tree, boolean startIndex) {
        Stack<CommonTree> treeStack = new Stack<CommonTree>();
        treeStack.push(tree);
        CommonTree currentTree = null;
        while (!treeStack.isEmpty()) {
            currentTree = (CommonTree)treeStack.pop();
            int childCount = currentTree.getChildCount();
            int i = childCount - 1;
            while (i >= 0) {
                treeStack.push((CommonTree)currentTree.getChild(i));
                --i;
            }
            if (!(currentTree instanceof CommonErrorNode)) continue;
            if (startIndex) {
                int start = ((CommonErrorNode)currentTree).start.getCharPositionInLine();
                return start;
            }
            int stop = ((CommonErrorNode)currentTree).stop.getCharPositionInLine();
            return stop;
        }
        return -1;
    }

    public static List<Diagnostic> validate(String str) throws IOException, RecognitionException {
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        ANTLRInputStream antlrStream = new ANTLRInputStream((InputStream)input);
        FilterParserLexer lexer = new FilterParserLexer((CharStream)antlrStream);
        ArrayList<RecognitionException> lexerExceptions = new ArrayList<RecognitionException>();
        lexer.setErrorListener(e -> lexerExceptions.add((RecognitionException)e));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        FilterParserParser parser = new FilterParserParser((TokenStream)tokenStream);
        ArrayList<RecognitionException> parserExceptions = new ArrayList<RecognitionException>();
        parser.setErrorListener(e -> parserExceptions.add((RecognitionException)e));
        FilterParserParser.parse_return parse = parser.parse();
        CommonTree tree = parse.getTree();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        lexerExceptions.forEach(e -> {
            String message = lexer.getErrorMessage(e, lexer.getTokenNames());
            Range range = FilterValidation.getRangeFromException(e, str, tree);
            Diagnostic diagnostic = new Diagnostic(range, message);
            diagnostics.add(diagnostic);
        });
        parserExceptions.forEach(e -> {
            String message = parser.getErrorMessage(e, parser.getTokenNames());
            Range range = FilterValidation.getRangeFromException(e, str, tree);
            Diagnostic diagnostic = new Diagnostic(range, message);
            diagnostics.add(diagnostic);
        });
        return FilterValidation.preprocessDiagnostics(diagnostics);
    }

    private static Range getRangeFromException(RecognitionException e, String msg, CommonTree tree) {
        int lineStart = 0;
        int lineEnd = 0;
        int offsetStart = 0;
        int offsetEnd = 0;
        if (e instanceof MismatchedTokenException) {
            offsetStart = FilterValidation.getErrorStartEndIndex(tree, false);
            offsetEnd = msg.length();
            if (offsetStart == -1) {
                offsetStart = e.index - 1;
                offsetEnd = e.index;
            }
        } else if (e instanceof NoViableAltException) {
            offsetStart = FilterValidation.getErrorStartEndIndex(tree, true);
            offsetEnd = msg.length();
        } else if (!(e instanceof EarlyExitException || e instanceof MismatchedNotSetException || e instanceof MismatchedSetException)) {
            boolean cfr_ignored_0 = e instanceof MismatchedRangeException;
        }
        Position start = new Position(lineStart, offsetStart);
        Position end = new Position(lineEnd, offsetEnd);
        return new Range(start, end);
    }

    private static List<Diagnostic> preprocessDiagnostics(List<Diagnostic> diagnostics) {
        ArrayList<Diagnostic> newDiagnostics = new ArrayList<Diagnostic>();
        HashSet<Diagnostic> uniqueDiagnostics = new HashSet<Diagnostic>();
        uniqueDiagnostics.addAll(diagnostics);
        newDiagnostics.addAll(uniqueDiagnostics);
        return newDiagnostics;
    }
}

