/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.hudson.maven.core.trace;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.tracecompass.incubator.internal.hudson.maven.core.trace.MavenEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTrace;

public class MavenTrace
extends TextTrace<MavenEvent> {
    private static final char START_REGEX = '^';
    private static final String DATE_FORMAT_STRING = "HH:mm:ss";
    private static final String DATE_PATTERN = "([0-2]?\\d:[0-5]\\d:[0-5]\\d)";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss", TmfTimePreferences.getLocale());
    private static final String ELAPSED_TIME_STRING = "Time\\selapsed:\\s*([\\d|\\.|\\,]+)\\s*se?c?";
    private static final String GOAL_PATTERN = "^([0-2]?\\d:[0-5]\\d:[0-5]\\d)\\s*\\[(\\S+)\\]\\s+---\\s((.*)\\(.*\\))\\s+@\\s+(\\S+)\\s+---$";
    private static final String TEST_SUMMARY_PATTERN = "^([0-2]?\\d:[0-5]\\d:[0-5]\\d)\\s*Tests\\srun:\\s(\\d+),\\sFailures:\\s(\\d+),\\sErrors:\\s(\\d+),\\sSkipped:\\s(\\d+),\\s*Time\\selapsed:\\s*([\\d|\\.|\\,]+)\\s*se?c?\\s*[^-]*-\\sin\\s(.*)$";
    private static final String TEST_INDIVIDUAL_PATTERN = "^([0-2]?\\d:[0-5]\\d:[0-5]\\d)\\s*((.*)\\(.*\\))\\s*Time\\selapsed:\\s*([\\d|\\.|\\,]+)\\s*se?c?.*$";
    private static final Pattern FIRST_LINE = Pattern.compile("^([0-2]?\\d:[0-5]\\d:[0-5]\\d)\\s*\\[(\\S+)\\]\\s+---\\s((.*)\\(.*\\))\\s+@\\s+(\\S+)\\s+---$|^([0-2]?\\d:[0-5]\\d:[0-5]\\d)\\s*Tests\\srun:\\s(\\d+),\\sFailures:\\s(\\d+),\\sErrors:\\s(\\d+),\\sSkipped:\\s(\\d+),\\s*Time\\selapsed:\\s*([\\d|\\.|\\,]+)\\s*se?c?\\s*[^-]*-\\sin\\s(.*)$|^([0-2]?\\d:[0-5]\\d:[0-5]\\d)\\s*((.*)\\(.*\\))\\s*Time\\selapsed:\\s*([\\d|\\.|\\,]+)\\s*se?c?.*$");

    protected Pattern getFirstLinePattern() {
        return FIRST_LINE;
    }

    protected MavenEvent parseFirstLine(Matcher matcher, String line) {
        try {
            String group = matcher.group(1);
            if (group != null) {
                Date parse = DATE_FORMAT.parse(group);
                MavenEvent event = MavenEvent.createGoal(this, TmfTimestamp.fromMillis((long)parse.getTime()), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5));
                return event;
            }
            group = matcher.group(6);
            if (group != null) {
                Date parse = DATE_FORMAT.parse(group);
                MavenEvent event = MavenEvent.createSummary(this, TmfTimestamp.fromMillis((long)parse.getTime()), matcher.group(12), matcher.group(12), MavenTrace.parseDouble(matcher.group(11)));
                return event;
            }
            group = matcher.group(13);
            if (group != null) {
                Date parse = DATE_FORMAT.parse(group);
                MavenEvent event = MavenEvent.createTest(this, TmfTimestamp.fromMillis((long)parse.getTime()), matcher.group(15), matcher.group(14), MavenTrace.parseDouble(matcher.group(16)));
                return event;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected void parseNextLine(MavenEvent event, String line) {
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return MavenEvent.EVENT_ASPECTS;
    }

    private static Double parseDouble(String original) {
        String dblString = original.replace(",", "");
        return Double.parseDouble(dblString);
    }
}

