/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.StaticSymbolTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReferenceCollectingCallback
implements NodeTraversal.ScopedCallback,
HotSwapCompilerPass,
StaticSymbolTable<Var, Reference> {
    private final Map<Var, ReferenceCollection> referenceMap = new LinkedHashMap<Var, ReferenceCollection>();
    private List<BasicBlock> blockStack = new ArrayList<BasicBlock>();
    private final Behavior behavior;
    private final AbstractCompiler compiler;
    private final Predicate<Var> varFilter;
    private final Set<Var> startedFunctionTraverse = new HashSet<Var>();
    private final Set<Var> finishedFunctionTraverse = new HashSet<Var>();
    private Scope narrowScope;
    static final Behavior DO_NOTHING_BEHAVIOR = new Behavior(){

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
        }
    };

    ReferenceCollectingCallback(AbstractCompiler compiler, Behavior behavior) {
        this(compiler, behavior, (Predicate<Var>)Predicates.alwaysTrue());
    }

    ReferenceCollectingCallback(AbstractCompiler compiler, Behavior behavior, Predicate<Var> varFilter) {
        this.compiler = compiler;
        this.behavior = behavior;
        this.varFilter = varFilter;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
    }

    void processScope(Scope scope) {
        this.narrowScope = scope;
        new NodeTraversal(this.compiler, this).traverseAtScope(scope);
        this.narrowScope = null;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public Iterable<Var> getAllSymbols() {
        return this.referenceMap.keySet();
    }

    public Scope getScope(Var var) {
        return var.scope;
    }

    public ReferenceCollection getReferences(Var v) {
        return this.referenceMap.get(v);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Var v;
        if ((n.isName() || n.isStringKey() && !n.hasChildren()) && (v = n.getString().equals("arguments") ? t.getScope().getArgumentsVar() : t.getScope().getVar(n.getString())) != null) {
            if (this.varFilter.apply((Object)v)) {
                this.addReference(v, new Reference(n, t, ReferenceCollectingCallback.peek(this.blockStack)));
            }
            if (v.getParentNode() != null && NodeUtil.isHoistedFunctionDeclaration(v.getParentNode()) && (this.narrowScope == null || this.narrowScope.getDepth() <= v.getScope().getDepth())) {
                this.outOfBandTraversal(v);
            }
        }
        if (ReferenceCollectingCallback.isBlockBoundary(n, parent)) {
            ReferenceCollectingCallback.pop(this.blockStack);
        }
    }

    private void outOfBandTraversal(Var v) {
        if (this.startedFunctionTraverse.contains(v)) {
            return;
        }
        this.startedFunctionTraverse.add(v);
        Node fnNode = v.getParentNode();
        Preconditions.checkState((boolean)NodeUtil.isHoistedFunctionDeclaration(fnNode));
        Scope containingScope = v.getScope();
        ArrayList<BasicBlock> newBlockStack = null;
        if (containingScope.isGlobal()) {
            newBlockStack = new ArrayList<BasicBlock>();
            newBlockStack.add(this.blockStack.get(0));
        } else {
            for (int i = 0; i < this.blockStack.size(); ++i) {
                if (this.blockStack.get(i).root != containingScope.getRootNode()) continue;
                newBlockStack = new ArrayList<BasicBlock>(this.blockStack.subList(0, i + 1));
            }
        }
        Preconditions.checkNotNull(newBlockStack);
        List<BasicBlock> oldBlockStack = this.blockStack;
        this.blockStack = newBlockStack;
        NodeTraversal outOfBandTraversal = new NodeTraversal(this.compiler, this);
        outOfBandTraversal.traverseFunctionOutOfBand(fnNode, containingScope);
        this.blockStack = oldBlockStack;
        this.finishedFunctionTraverse.add(v);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Node n = t.getScope().getRootNode();
        BasicBlock parent = this.blockStack.isEmpty() ? null : ReferenceCollectingCallback.peek(this.blockStack);
        this.blockStack.add(new BasicBlock(parent, n));
    }

    @Override
    public void exitScope(NodeTraversal t) {
        ReferenceCollectingCallback.pop(this.blockStack);
        if (t.getScope().isGlobal()) {
            this.compiler.updateGlobalVarReferences(this.referenceMap, t.getScopeRoot());
            this.behavior.afterExitScope(t, this.compiler.getGlobalVarReferences());
        } else {
            this.behavior.afterExitScope(t, new ReferenceMapWrapper(this.referenceMap));
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (NodeUtil.isHoistedFunctionDeclaration(n)) {
            Node nameNode = n.getFirstChild();
            Var functionVar = nodeTraversal.getScope().getVar(nameNode.getString());
            if (functionVar != null) {
                if (this.finishedFunctionTraverse.contains(functionVar)) {
                    return false;
                }
                this.startedFunctionTraverse.add(functionVar);
            }
        }
        if (ReferenceCollectingCallback.isBlockBoundary(n, parent)) {
            this.blockStack.add(new BasicBlock(ReferenceCollectingCallback.peek(this.blockStack), n));
        }
        return true;
    }

    private static <T> T pop(List<T> list) {
        return list.remove(list.size() - 1);
    }

    private static <T> T peek(List<T> list) {
        return list.get(list.size() - 1);
    }

    private static boolean isBlockBoundary(Node n, Node parent) {
        if (parent != null) {
            switch (parent.getType()) {
                case 77: 
                case 113: 
                case 114: 
                case 115: 
                case 119: 
                case 158: 
                case 163: {
                    return true;
                }
                case 98: 
                case 100: 
                case 101: 
                case 108: {
                    return n != parent.getFirstChild();
                }
            }
        }
        return n.isCase();
    }

    private void addReference(Var v, Reference reference) {
        ReferenceCollection referenceInfo = this.referenceMap.get(v);
        if (referenceInfo == null) {
            referenceInfo = new ReferenceCollection();
            this.referenceMap.put(v, referenceInfo);
        }
        referenceInfo.add(reference);
    }

    static final class BasicBlock {
        private final BasicBlock parent;
        private final Node root;
        private final boolean isFunction;
        private final boolean isLoop;

        BasicBlock(BasicBlock parent, Node root) {
            int pType;
            this.parent = parent;
            this.root = root;
            this.isFunction = root.isFunction();
            this.isLoop = root.getParent() != null ? (pType = root.getParent().getType()) == 114 || pType == 113 || pType == 115 : false;
        }

        BasicBlock getParent() {
            return this.parent;
        }

        boolean isGlobalScopeBlock() {
            return this.getParent() == null;
        }

        boolean provablyExecutesBefore(BasicBlock thatBlock) {
            BasicBlock currentBlock;
            for (currentBlock = thatBlock; currentBlock != null && currentBlock != this; currentBlock = currentBlock.getParent()) {
            }
            if (currentBlock == this) {
                return true;
            }
            return this.isGlobalScopeBlock() && thatBlock.isGlobalScopeBlock();
        }
    }

    static interface Behavior {
        public void afterExitScope(NodeTraversal var1, ReferenceMap var2);
    }

    static final class Reference
    implements StaticRef {
        private static final Set<Integer> DECLARATION_PARENTS = ImmutableSet.of((Object)118, (Object)162, (Object)149, (Object)83, (Object)105, (Object)158, (Object[])new Integer[]{120, 173});
        private final Node nameNode;
        private final BasicBlock basicBlock;
        private final Scope scope;
        private final InputId inputId;
        private final StaticSourceFile sourceFile;

        Reference(Node nameNode, NodeTraversal t, BasicBlock basicBlock) {
            this(nameNode, basicBlock, t.getScope(), t.getInput().getInputId());
        }

        public String toString() {
            return this.nameNode.toString();
        }

        @VisibleForTesting
        static Reference createRefForTest(CompilerInput input) {
            return new Reference(new Node(38), null, null, input.getInputId());
        }

        private Reference(Node nameNode, BasicBlock basicBlock, Scope scope, InputId inputId) {
            this.nameNode = nameNode;
            this.basicBlock = basicBlock;
            this.scope = scope;
            this.inputId = inputId;
            this.sourceFile = nameNode.getStaticSourceFile();
        }

        Reference cloneWithNewScope(Scope newScope) {
            return new Reference(this.nameNode, this.basicBlock, newScope, this.inputId);
        }

        @Override
        public Var getSymbol() {
            return this.scope.getVar(this.nameNode.getString());
        }

        @Override
        public Node getNode() {
            return this.nameNode;
        }

        public InputId getInputId() {
            return this.inputId;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.sourceFile;
        }

        boolean isDeclaration() {
            return Reference.isDeclarationHelper(this.nameNode);
        }

        private static boolean isDeclarationHelper(Node node) {
            Node parent = node.getParent();
            if (parent.isClass() && node != parent.getFirstChild()) {
                return false;
            }
            if (parent.getParent() == null) {
                return false;
            }
            if (NodeUtil.isNameDeclaration(parent.getParent()) && node == parent.getLastChild() && (parent.getGrandparent() == null || !parent.getGrandparent().isForOf())) {
                return false;
            }
            if (parent.isDestructuringPattern() || parent.isStringKey() && parent.getParent().isObjectPattern() || parent.isComputedProp() && parent.getParent().isObjectPattern() && node == parent.getLastChild() || parent.isDefaultValue() && node == parent.getFirstChild()) {
                return Reference.isDeclarationHelper(parent);
            }
            if (parent.isArrowFunction()) {
                return node == parent.getFirstChild();
            }
            return DECLARATION_PARENTS.contains(parent.getType());
        }

        boolean isVarDeclaration() {
            return this.getParent().isVar();
        }

        boolean isLetDeclaration() {
            return this.getParent().isLet();
        }

        boolean isConstDeclaration() {
            return this.getParent().isConst();
        }

        boolean isHoistedFunction() {
            return NodeUtil.isHoistedFunctionDeclaration(this.getParent());
        }

        boolean isInitializingDeclaration() {
            return this.isDeclaration() && !this.getParent().isVar() && !this.getParent().isLet() || this.nameNode.getFirstChild() != null;
        }

        Node getAssignedValue() {
            return NodeUtil.getRValueOfLValue(this.nameNode);
        }

        BasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        Node getParent() {
            return this.getNode().getParent();
        }

        Node getGrandparent() {
            Node parent = this.getParent();
            return parent == null ? null : parent.getParent();
        }

        private static boolean isLhsOfEnhancedForExpression(Node n) {
            Node parent = n.getParent();
            if (NodeUtil.isNameDeclaration(parent)) {
                return Reference.isLhsOfEnhancedForExpression(parent);
            }
            return NodeUtil.isEnhancedFor(parent) && parent.getFirstChild() == n;
        }

        boolean isSimpleAssignmentToName() {
            Node parent = this.getParent();
            return parent.isAssign() && parent.getFirstChild() == this.nameNode;
        }

        boolean isLvalue() {
            Node parent = this.getParent();
            int parentType = parent.getType();
            return parentType == 118 && this.nameNode.getFirstChild() != null || parentType == 162 && this.nameNode.getFirstChild() != null || parentType == 149 && this.nameNode.getFirstChild() != null || parentType == 179 && parent.getFirstChild() == this.nameNode || parentType == 102 || parentType == 103 || parentType == 120 || NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == this.nameNode || Reference.isLhsOfEnhancedForExpression(this.nameNode) || NodeUtil.isLhsByDestructuring(this.nameNode);
        }

        Scope getScope() {
            return this.scope;
        }
    }

    static class ReferenceCollection
    implements Iterable<Reference> {
        List<Reference> references = new ArrayList<Reference>();

        ReferenceCollection() {
        }

        @Override
        public Iterator<Reference> iterator() {
            return this.references.iterator();
        }

        void add(Reference reference) {
            this.references.add(reference);
        }

        protected boolean isWellDefined() {
            int size = this.references.size();
            if (size == 0) {
                return false;
            }
            Reference init = this.getInitializingReference();
            if (init == null) {
                return false;
            }
            Preconditions.checkState((boolean)this.references.get(0).isDeclaration());
            BasicBlock initBlock = init.getBasicBlock();
            for (int i = 1; i < size; ++i) {
                if (initBlock.provablyExecutesBefore(this.references.get(i).getBasicBlock())) continue;
                return false;
            }
            return true;
        }

        boolean isEscaped() {
            Scope scope = null;
            for (Reference ref : this.references) {
                if (scope == null) {
                    scope = ref.scope;
                    continue;
                }
                if (scope == ref.scope) continue;
                return true;
            }
            return false;
        }

        private boolean isInitializingDeclarationAt(int index) {
            Reference maybeInit = this.references.get(index);
            return maybeInit.isInitializingDeclaration();
        }

        private boolean isInitializingAssignmentAt(int index) {
            Reference maybeDecl;
            if (index < this.references.size() && index > 0 && (maybeDecl = this.references.get(index - 1)).isVarDeclaration()) {
                Preconditions.checkState((!maybeDecl.isInitializingDeclaration() ? 1 : 0) != 0);
                Reference maybeInit = this.references.get(index);
                if (maybeInit.isSimpleAssignmentToName()) {
                    return true;
                }
            }
            return false;
        }

        Reference getInitializingReference() {
            if (this.isInitializingDeclarationAt(0)) {
                return this.references.get(0);
            }
            if (this.isInitializingAssignmentAt(1)) {
                return this.references.get(1);
            }
            return null;
        }

        Reference getInitializingReferenceForConstants() {
            int size = this.references.size();
            for (int i = 0; i < size; ++i) {
                if (!this.isInitializingDeclarationAt(i) && !this.isInitializingAssignmentAt(i)) continue;
                return this.references.get(i);
            }
            return null;
        }

        boolean isAssignedOnceInLifetime() {
            Reference ref = this.getOneAndOnlyAssignment();
            if (ref == null) {
                return false;
            }
            for (BasicBlock block = ref.getBasicBlock(); block != null; block = block.getParent()) {
                if (block.isFunction) {
                    if (ref.getSymbol().getScope() == ref.scope) break;
                    return false;
                }
                if (!block.isLoop) continue;
                return false;
            }
            return true;
        }

        private Reference getOneAndOnlyAssignment() {
            Reference assignment = null;
            int size = this.references.size();
            for (int i = 0; i < size; ++i) {
                Reference ref = this.references.get(i);
                if (!ref.isLvalue() && !ref.isInitializingDeclaration()) continue;
                if (assignment == null) {
                    assignment = ref;
                    continue;
                }
                return null;
            }
            return assignment;
        }

        boolean isNeverAssigned() {
            int size = this.references.size();
            for (int i = 0; i < size; ++i) {
                Reference ref = this.references.get(i);
                if (!ref.isLvalue() && !ref.isInitializingDeclaration()) continue;
                return false;
            }
            return true;
        }

        boolean firstReferenceIsAssigningDeclaration() {
            int size = this.references.size();
            return size > 0 && this.references.get(0).isInitializingDeclaration();
        }
    }

    static interface ReferenceMap {
        public ReferenceCollection getReferences(Var var1);
    }

    private static class ReferenceMapWrapper
    implements ReferenceMap {
        private final Map<Var, ReferenceCollection> referenceMap;

        public ReferenceMapWrapper(Map<Var, ReferenceCollection> referenceMap) {
            this.referenceMap = referenceMap;
        }

        @Override
        public ReferenceCollection getReferences(Var var) {
            return this.referenceMap.get(var);
        }
    }
}

