/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeBinding;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;

class RecoveredTypeBinding
implements ITypeBinding {
    private VariableDeclaration variableDeclaration;
    private Type currentType;
    private BindingResolver resolver;
    private int dimensions;
    private RecoveredTypeBinding innerTypeBinding;
    private ITypeBinding[] typeArguments;
    private org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding referenceBinding;

    RecoveredTypeBinding(BindingResolver resolver, VariableDeclaration variableDeclaration) {
        this.variableDeclaration = variableDeclaration;
        this.resolver = resolver;
        this.currentType = this.getType();
        this.dimensions = variableDeclaration.getExtraDimensions();
        if (this.currentType.isArrayType()) {
            this.dimensions += ((ArrayType)this.currentType).getDimensions();
        }
    }

    RecoveredTypeBinding(BindingResolver resolver, org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding referenceBinding) {
        this.resolver = resolver;
        this.dimensions = referenceBinding.dimensions();
        this.referenceBinding = referenceBinding;
    }

    RecoveredTypeBinding(BindingResolver resolver, Type type) {
        this.currentType = type;
        this.resolver = resolver;
        this.dimensions = 0;
        if (type.isArrayType()) {
            this.dimensions += ((ArrayType)type).getDimensions();
        }
    }

    RecoveredTypeBinding(BindingResolver resolver, RecoveredTypeBinding typeBinding, int dimensions) {
        this.innerTypeBinding = typeBinding;
        this.dimensions = typeBinding.getDimensions() + dimensions;
        this.resolver = resolver;
    }

    @Override
    public ITypeBinding createArrayType(int dims) {
        return this.resolver.getTypeBinding(this, dims);
    }

    @Override
    public String getBinaryName() {
        return null;
    }

    public ITypeBinding getBound() {
        return null;
    }

    @Override
    public ITypeBinding getComponentType() {
        if (this.dimensions == 0) {
            return null;
        }
        return this.resolver.getTypeBinding(this, -1);
    }

    @Override
    public IVariableBinding[] getDeclaredFields() {
        return TypeBinding.NO_VARIABLE_BINDINGS;
    }

    @Override
    public IFunctionBinding[] getDeclaredMethods() {
        return TypeBinding.NO_METHOD_BINDINGS;
    }

    @Override
    public int getDeclaredModifiers() {
        return 0;
    }

    @Override
    public ITypeBinding[] getDeclaredTypes() {
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        return null;
    }

    @Override
    public IFunctionBinding getDeclaringMethod() {
        return null;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public ITypeBinding getElementType() {
        if (this.referenceBinding != null) {
            if (this.referenceBinding.isArrayType()) {
                ArrayBinding arrayBinding = (ArrayBinding)this.referenceBinding;
                return new RecoveredTypeBinding(this.resolver, arrayBinding.leafComponentType);
            }
            return new RecoveredTypeBinding(this.resolver, this.referenceBinding);
        }
        if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.getElementType();
        }
        if (this.currentType != null && this.currentType.isArrayType()) {
            return this.resolver.getTypeBinding(((ArrayType)this.currentType).getElementType());
        }
        if (this.variableDeclaration != null && this.variableDeclaration.getExtraDimensions() != 0) {
            return this.resolver.getTypeBinding(this.getType());
        }
        return null;
    }

    @Override
    public ITypeBinding getErasure() {
        return this;
    }

    public ITypeBinding[] getInterfaces() {
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public String getName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        StringBuffer buffer = new StringBuffer(this.getInternalName());
        buffer.append(brackets);
        return String.valueOf(buffer);
    }

    private String getInternalName() {
        if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.getInternalName();
        }
        if (this.referenceBinding != null) {
            ReferenceBinding typeBinding = null;
            if (this.referenceBinding.isArrayType()) {
                ArrayBinding arrayBinding = (ArrayBinding)this.referenceBinding;
                if (arrayBinding.leafComponentType instanceof ReferenceBinding) {
                    typeBinding = (ReferenceBinding)arrayBinding.leafComponentType;
                }
            } else if (this.referenceBinding instanceof ReferenceBinding) {
                typeBinding = (ReferenceBinding)this.referenceBinding;
            }
            return new String(typeBinding.compoundName[typeBinding.compoundName.length - 1]);
        }
        return this.getTypeNameFrom(this.getType());
    }

    @Override
    public IPackageBinding getPackage() {
        CompilationUnitScope scope = this.resolver.scope();
        if (scope != null) {
            return this.resolver.getPackageBinding(scope.getCurrentPackage());
        }
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public ITypeBinding getSuperclass() {
        return this.resolver.resolveWellKnownType("java.lang.Object");
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.referenceBinding != null) {
            this.typeArguments = TypeBinding.NO_TYPE_BINDINGS;
            return TypeBinding.NO_TYPE_BINDINGS;
        }
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.innerTypeBinding != null) {
            return this.innerTypeBinding.getTypeArguments();
        }
        this.typeArguments = TypeBinding.NO_TYPE_BINDINGS;
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    public ITypeBinding[] getTypeBounds() {
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    @Override
    public ITypeBinding getTypeDeclaration() {
        return this;
    }

    public ITypeBinding[] getTypeParameters() {
        return TypeBinding.NO_TYPE_BINDINGS;
    }

    public boolean isAnnotation() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isAssignmentCompatible(ITypeBinding typeBinding) {
        if ("java.lang.Object".equals(typeBinding.getQualifiedName())) {
            return true;
        }
        return this.isEqualTo(typeBinding);
    }

    public boolean isCapture() {
        return false;
    }

    @Override
    public boolean isCastCompatible(ITypeBinding typeBinding) {
        if ("java.lang.Object".equals(typeBinding.getQualifiedName())) {
            return true;
        }
        return this.isEqualTo(typeBinding);
    }

    @Override
    public boolean isClass() {
        return true;
    }

    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isFromSource() {
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public boolean isNullType() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public boolean isRawType() {
        return false;
    }

    @Override
    public boolean isSubTypeCompatible(ITypeBinding typeBinding) {
        if ("java.lang.Object".equals(typeBinding.getQualifiedName())) {
            return true;
        }
        return this.isEqualTo(typeBinding);
    }

    @Override
    public boolean isTopLevel() {
        return true;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUpperbound() {
        return false;
    }

    @Override
    public IJavaScriptElement getJavaElement() {
        try {
            return new CompilationUnit(null, this.getInternalName(), this.resolver.getWorkingCopyOwner()).getWorkingCopy(this.resolver.getWorkingCopyOwner(), null);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    @Override
    public String getKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Recovered#");
        if (this.innerTypeBinding != null) {
            buffer.append("innerTypeBinding").append(this.innerTypeBinding.getKey());
        } else if (this.currentType != null) {
            buffer.append("currentType").append(this.currentType.toString());
        } else if (this.referenceBinding != null) {
            buffer.append("referenceBinding").append(this.referenceBinding.computeUniqueKey());
        } else if (this.variableDeclaration != null) {
            buffer.append("variableDeclaration").append(this.variableDeclaration.getClass()).append(this.variableDeclaration.getName().getIdentifier()).append(this.variableDeclaration.getExtraDimensions());
        }
        buffer.append(this.getDimensions());
        if (this.typeArguments != null) {
            buffer.append('<');
            int i = 0;
            int max = this.typeArguments.length;
            while (i < max) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append(this.typeArguments[i].getKey());
                ++i;
            }
            buffer.append('>');
        }
        return String.valueOf(buffer);
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isEqualTo(IBinding other) {
        if (!other.isRecovered() || other.getKind() != 2) {
            return false;
        }
        return this.getKey().equals(other.getKey());
    }

    @Override
    public boolean isRecovered() {
        return true;
    }

    private String getTypeNameFrom(Type type) {
        if (type == null) {
            return Util.EMPTY_STRING;
        }
        switch (type.getNodeType0()) {
            case 5: {
                ArrayType arrayType = (ArrayType)type;
                type = arrayType.getElementType();
                return this.getTypeNameFrom(type);
            }
            case 39: {
                PrimitiveType primitiveType = (PrimitiveType)type;
                return primitiveType.getPrimitiveTypeCode().toString();
            }
            case 75: {
                QualifiedType qualifiedType = (QualifiedType)type;
                return qualifiedType.getName().getIdentifier();
            }
            case 43: {
                SimpleType simpleType = (SimpleType)type;
                Name name = simpleType.getName();
                if (name.isQualifiedName()) {
                    QualifiedName qualifiedName = (QualifiedName)name;
                    return qualifiedName.getName().getIdentifier();
                }
                return ((SimpleName)name).getIdentifier();
            }
        }
        return Util.EMPTY_STRING;
    }

    private Type getType() {
        if (this.currentType != null) {
            return this.currentType;
        }
        if (this.variableDeclaration == null) {
            return null;
        }
        switch (this.variableDeclaration.getNodeType()) {
            case 44: {
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)this.variableDeclaration;
                return singleVariableDeclaration.getType();
            }
        }
        ASTNode parent = this.variableDeclaration.getParent();
        switch (parent.getNodeType()) {
            case 58: {
                VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)parent;
                return variableDeclarationExpression.getType();
            }
            case 60: {
                VariableDeclarationStatement statement = (VariableDeclarationStatement)parent;
                return statement.getType();
            }
            case 23: {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)parent;
                return fieldDeclaration.getType();
            }
        }
        return null;
    }

    @Override
    public boolean isCompilationUnit() {
        return false;
    }
}

